// generated file
package org.cthul.log;

import org.cthul.strings.Strings;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

/**
 * Wraps a {@link Logger slf4j Logger}, which is the main user entry point of SLF4J API. 
 * It is expected that logging takes place through concrete implementations 
 * of {@code org.slf4j.Logger}.
 * <p/>
 * The following example was taken from the slf4j Logger documentation and
 * adapted to show how to use a Cthul Logger.
 *
 * <h3>Typical usage pattern:</h3>
 * <pre>
 * import org.cthul.log.CLogger;
 * import org.cthul.log.CLoggerFactory;
 * 
 * public class Wombat {
 *
 *   <span style="color:green">final static CLogger logger = CLoggerFactory.getLogger(Wombat.class);</span>
 *   Integer t;
 *   Integer oldT;
 *
 *   public void setTemperature(Integer temperature) {
 *     oldT = t;        
 *     t = temperature;
 *     <span style="color:green">logger.debug("Temperature set to %s. Old temperature was %s.", t, oldT);</span>
 *     if(temperature.intValue() > 50) {
 *       <span style="color:green">logger.info("Temperature has risen above 50 degrees.");</span>
 *     }
 *   }
 * }
 * </pre>
 * @author Arian Treffer
 */
public class CLocLogger<E extends Enum<?>> extends CLoggerBase{

    private static final String FQCN = CLocLogger.class.getName();
    
    protected final CLocLogConfiguration locConf;

    public CLocLogger(Logger logger) {
        this(logger, CLocLogConfiguration.getDefault());
    }
    
    public CLocLogger(Logger logger, CLocLogConfiguration conf) {
        super(logger, conf);
        this.locConf = new CLocLogConfiguration(this.conf);
    }

    protected String m(E message) {
        return locConf.getMessage(message);
    }

    protected String f(E message) {
        return m(message);
    }

    protected String f(Throwable throwable, E message) {
        return Strings.format(conf, throwable, m(message));
    }

    protected String f(Throwable throwable, E message, Object... args) {
        if (message instanceof NamedParameters) {
            LocFormatArgs fargs = new LocFormatArgs(throwable, ((NamedParameters) message).getNames(), args);
            return Strings.format(conf, m(message), fargs);
        } else {
            return Strings.format(conf, throwable, m(message), args);
        }
    }

    /**
     * Log a message at the trace level.
     * 
     * @param message the message string to be logged
     */
    public void trace(E message) {
        if (trace()) {
            final Throwable throwable = t(message);
            final String msg = f(message);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.TRACE_INT, msg, null, throwable);
            } else {
                logger.trace(msg, throwable);
            }
        }
    }

    /**
     * Log a message at the trace level, according to the specified format and arguments.
     * 
     * @param message the format string
     * @param args an array of arguments
     */
    public void trace(E message, Object... args) {
        if (trace()) {
            final Throwable throwable = t(args);
            final String msg = f(throwable, message, args);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.TRACE_INT, msg, null, throwable);
            } else {
                logger.trace(msg, throwable);
            }
        }
    }

    /**
     * Log a message at the trace level, according to the specified format and arguments.
     * 
     * @param message the format string
     * @param arg1 argument 1
     */
    public void trace(E message, Object arg1) {
        if (trace()) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.TRACE_INT, msg, null, throwable);
            } else {
                logger.trace(msg, throwable);
            }
        }
    }

    /**
     * Log a message at the trace level, according to the specified format and arguments.
     * 
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void trace(E message, Object arg1, Object arg2) {
        if (trace()) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1, arg2);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.TRACE_INT, msg, null, throwable);
            } else {
                logger.trace(msg, throwable);
            }
        }
    }

    /**
     * Log a message at the trace level, according to the specified format and arguments.
     * 
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void trace(E message, Object arg1, Object arg2, Object arg3) {
        if (trace()) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1, arg2, arg3);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.TRACE_INT, msg, null, throwable);
            } else {
                logger.trace(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the trace level.
     * 
     * @param throwable the throwable to log
     * @param message the message string to be logged
     */
    public void trace(Throwable throwable, E message) {
        if (trace()) {
            final String msg = f(throwable, message);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.TRACE_INT, msg, null, throwable);
            } else {
                logger.trace(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the trace level, according to the specified format and arguments.
     * 
     * @param throwable the throwable to log
     * @param message the format string
     * @param args an array of arguments
     */
    public void trace(Throwable throwable, E message, Object... args) {
        if (trace()) {
            final String msg = f(throwable, message, args);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.TRACE_INT, msg, null, throwable);
            } else {
                logger.trace(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the trace level, according to the specified format and arguments.
     * 
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     */
    public void trace(Throwable throwable, E message, Object arg1) {
        if (trace()) {
            final String msg = f(throwable, message, arg1);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.TRACE_INT, msg, null, throwable);
            } else {
                logger.trace(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the trace level, according to the specified format and arguments.
     * 
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void trace(Throwable throwable, E message, Object arg1, Object arg2) {
        if (trace()) {
            final String msg = f(throwable, message, arg1, arg2);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.TRACE_INT, msg, null, throwable);
            } else {
                logger.trace(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the trace level, according to the specified format and arguments.
     * 
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void trace(Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        if (trace()) {
            final String msg = f(throwable, message, arg1, arg2, arg3);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.TRACE_INT, msg, null, throwable);
            } else {
                logger.trace(msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the trace level.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the message string to be logged
     */
    public void trace(Marker marker, E message) {
        if (trace(marker)) {
            final Throwable throwable = t(message);
            final String msg = f(message);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.TRACE_INT, msg, null, throwable);
            } else {
                logger.trace(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the trace level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param args an array of arguments
     */
    public void trace(Marker marker, E message, Object... args) {
        if (trace(marker)) {
            final Throwable throwable = t(args);
            final String msg = f(throwable, message, args);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.TRACE_INT, msg, null, throwable);
            } else {
                logger.trace(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the trace level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param arg1 argument 1
     */
    public void trace(Marker marker, E message, Object arg1) {
        if (trace(marker)) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.TRACE_INT, msg, null, throwable);
            } else {
                logger.trace(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the trace level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void trace(Marker marker, E message, Object arg1, Object arg2) {
        if (trace(marker)) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1, arg2);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.TRACE_INT, msg, null, throwable);
            } else {
                logger.trace(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the trace level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void trace(Marker marker, E message, Object arg1, Object arg2, Object arg3) {
        if (trace(marker)) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1, arg2, arg3);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.TRACE_INT, msg, null, throwable);
            } else {
                logger.trace(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the trace level.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the message string to be logged
     */
    public void trace(Marker marker, Throwable throwable, E message) {
        if (trace(marker)) {
            final String msg = f(throwable, message);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.TRACE_INT, msg, null, throwable);
            } else {
                logger.trace(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the trace level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param args an array of arguments
     */
    public void trace(Marker marker, Throwable throwable, E message, Object... args) {
        if (trace(marker)) {
            final String msg = f(throwable, message, args);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.TRACE_INT, msg, null, throwable);
            } else {
                logger.trace(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the trace level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     */
    public void trace(Marker marker, Throwable throwable, E message, Object arg1) {
        if (trace(marker)) {
            final String msg = f(throwable, message, arg1);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.TRACE_INT, msg, null, throwable);
            } else {
                logger.trace(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the trace level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void trace(Marker marker, Throwable throwable, E message, Object arg1, Object arg2) {
        if (trace(marker)) {
            final String msg = f(throwable, message, arg1, arg2);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.TRACE_INT, msg, null, throwable);
            } else {
                logger.trace(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the trace level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void trace(Marker marker, Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        if (trace(marker)) {
            final String msg = f(throwable, message, arg1, arg2, arg3);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.TRACE_INT, msg, null, throwable);
            } else {
                logger.trace(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message at the debug level.
     * 
     * @param message the message string to be logged
     */
    public void debug(E message) {
        if (debug()) {
            final Throwable throwable = t(message);
            final String msg = f(message);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.DEBUG_INT, msg, null, throwable);
            } else {
                logger.debug(msg, throwable);
            }
        }
    }

    /**
     * Log a message at the debug level, according to the specified format and arguments.
     * 
     * @param message the format string
     * @param args an array of arguments
     */
    public void debug(E message, Object... args) {
        if (debug()) {
            final Throwable throwable = t(args);
            final String msg = f(throwable, message, args);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.DEBUG_INT, msg, null, throwable);
            } else {
                logger.debug(msg, throwable);
            }
        }
    }

    /**
     * Log a message at the debug level, according to the specified format and arguments.
     * 
     * @param message the format string
     * @param arg1 argument 1
     */
    public void debug(E message, Object arg1) {
        if (debug()) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.DEBUG_INT, msg, null, throwable);
            } else {
                logger.debug(msg, throwable);
            }
        }
    }

    /**
     * Log a message at the debug level, according to the specified format and arguments.
     * 
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void debug(E message, Object arg1, Object arg2) {
        if (debug()) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1, arg2);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.DEBUG_INT, msg, null, throwable);
            } else {
                logger.debug(msg, throwable);
            }
        }
    }

    /**
     * Log a message at the debug level, according to the specified format and arguments.
     * 
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void debug(E message, Object arg1, Object arg2, Object arg3) {
        if (debug()) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1, arg2, arg3);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.DEBUG_INT, msg, null, throwable);
            } else {
                logger.debug(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the debug level.
     * 
     * @param throwable the throwable to log
     * @param message the message string to be logged
     */
    public void debug(Throwable throwable, E message) {
        if (debug()) {
            final String msg = f(throwable, message);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.DEBUG_INT, msg, null, throwable);
            } else {
                logger.debug(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the debug level, according to the specified format and arguments.
     * 
     * @param throwable the throwable to log
     * @param message the format string
     * @param args an array of arguments
     */
    public void debug(Throwable throwable, E message, Object... args) {
        if (debug()) {
            final String msg = f(throwable, message, args);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.DEBUG_INT, msg, null, throwable);
            } else {
                logger.debug(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the debug level, according to the specified format and arguments.
     * 
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     */
    public void debug(Throwable throwable, E message, Object arg1) {
        if (debug()) {
            final String msg = f(throwable, message, arg1);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.DEBUG_INT, msg, null, throwable);
            } else {
                logger.debug(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the debug level, according to the specified format and arguments.
     * 
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void debug(Throwable throwable, E message, Object arg1, Object arg2) {
        if (debug()) {
            final String msg = f(throwable, message, arg1, arg2);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.DEBUG_INT, msg, null, throwable);
            } else {
                logger.debug(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the debug level, according to the specified format and arguments.
     * 
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void debug(Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        if (debug()) {
            final String msg = f(throwable, message, arg1, arg2, arg3);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.DEBUG_INT, msg, null, throwable);
            } else {
                logger.debug(msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the debug level.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the message string to be logged
     */
    public void debug(Marker marker, E message) {
        if (debug(marker)) {
            final Throwable throwable = t(message);
            final String msg = f(message);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.DEBUG_INT, msg, null, throwable);
            } else {
                logger.debug(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the debug level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param args an array of arguments
     */
    public void debug(Marker marker, E message, Object... args) {
        if (debug(marker)) {
            final Throwable throwable = t(args);
            final String msg = f(throwable, message, args);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.DEBUG_INT, msg, null, throwable);
            } else {
                logger.debug(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the debug level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param arg1 argument 1
     */
    public void debug(Marker marker, E message, Object arg1) {
        if (debug(marker)) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.DEBUG_INT, msg, null, throwable);
            } else {
                logger.debug(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the debug level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void debug(Marker marker, E message, Object arg1, Object arg2) {
        if (debug(marker)) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1, arg2);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.DEBUG_INT, msg, null, throwable);
            } else {
                logger.debug(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the debug level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void debug(Marker marker, E message, Object arg1, Object arg2, Object arg3) {
        if (debug(marker)) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1, arg2, arg3);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.DEBUG_INT, msg, null, throwable);
            } else {
                logger.debug(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the debug level.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the message string to be logged
     */
    public void debug(Marker marker, Throwable throwable, E message) {
        if (debug(marker)) {
            final String msg = f(throwable, message);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.DEBUG_INT, msg, null, throwable);
            } else {
                logger.debug(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the debug level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param args an array of arguments
     */
    public void debug(Marker marker, Throwable throwable, E message, Object... args) {
        if (debug(marker)) {
            final String msg = f(throwable, message, args);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.DEBUG_INT, msg, null, throwable);
            } else {
                logger.debug(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the debug level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     */
    public void debug(Marker marker, Throwable throwable, E message, Object arg1) {
        if (debug(marker)) {
            final String msg = f(throwable, message, arg1);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.DEBUG_INT, msg, null, throwable);
            } else {
                logger.debug(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the debug level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void debug(Marker marker, Throwable throwable, E message, Object arg1, Object arg2) {
        if (debug(marker)) {
            final String msg = f(throwable, message, arg1, arg2);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.DEBUG_INT, msg, null, throwable);
            } else {
                logger.debug(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the debug level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void debug(Marker marker, Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        if (debug(marker)) {
            final String msg = f(throwable, message, arg1, arg2, arg3);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.DEBUG_INT, msg, null, throwable);
            } else {
                logger.debug(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message at the info level.
     * 
     * @param message the message string to be logged
     */
    public void info(E message) {
        if (info()) {
            final Throwable throwable = t(message);
            final String msg = f(message);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.INFO_INT, msg, null, throwable);
            } else {
                logger.info(msg, throwable);
            }
        }
    }

    /**
     * Log a message at the info level, according to the specified format and arguments.
     * 
     * @param message the format string
     * @param args an array of arguments
     */
    public void info(E message, Object... args) {
        if (info()) {
            final Throwable throwable = t(args);
            final String msg = f(throwable, message, args);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.INFO_INT, msg, null, throwable);
            } else {
                logger.info(msg, throwable);
            }
        }
    }

    /**
     * Log a message at the info level, according to the specified format and arguments.
     * 
     * @param message the format string
     * @param arg1 argument 1
     */
    public void info(E message, Object arg1) {
        if (info()) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.INFO_INT, msg, null, throwable);
            } else {
                logger.info(msg, throwable);
            }
        }
    }

    /**
     * Log a message at the info level, according to the specified format and arguments.
     * 
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void info(E message, Object arg1, Object arg2) {
        if (info()) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1, arg2);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.INFO_INT, msg, null, throwable);
            } else {
                logger.info(msg, throwable);
            }
        }
    }

    /**
     * Log a message at the info level, according to the specified format and arguments.
     * 
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void info(E message, Object arg1, Object arg2, Object arg3) {
        if (info()) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1, arg2, arg3);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.INFO_INT, msg, null, throwable);
            } else {
                logger.info(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the info level.
     * 
     * @param throwable the throwable to log
     * @param message the message string to be logged
     */
    public void info(Throwable throwable, E message) {
        if (info()) {
            final String msg = f(throwable, message);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.INFO_INT, msg, null, throwable);
            } else {
                logger.info(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the info level, according to the specified format and arguments.
     * 
     * @param throwable the throwable to log
     * @param message the format string
     * @param args an array of arguments
     */
    public void info(Throwable throwable, E message, Object... args) {
        if (info()) {
            final String msg = f(throwable, message, args);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.INFO_INT, msg, null, throwable);
            } else {
                logger.info(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the info level, according to the specified format and arguments.
     * 
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     */
    public void info(Throwable throwable, E message, Object arg1) {
        if (info()) {
            final String msg = f(throwable, message, arg1);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.INFO_INT, msg, null, throwable);
            } else {
                logger.info(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the info level, according to the specified format and arguments.
     * 
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void info(Throwable throwable, E message, Object arg1, Object arg2) {
        if (info()) {
            final String msg = f(throwable, message, arg1, arg2);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.INFO_INT, msg, null, throwable);
            } else {
                logger.info(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the info level, according to the specified format and arguments.
     * 
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void info(Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        if (info()) {
            final String msg = f(throwable, message, arg1, arg2, arg3);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.INFO_INT, msg, null, throwable);
            } else {
                logger.info(msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the info level.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the message string to be logged
     */
    public void info(Marker marker, E message) {
        if (info(marker)) {
            final Throwable throwable = t(message);
            final String msg = f(message);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.INFO_INT, msg, null, throwable);
            } else {
                logger.info(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the info level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param args an array of arguments
     */
    public void info(Marker marker, E message, Object... args) {
        if (info(marker)) {
            final Throwable throwable = t(args);
            final String msg = f(throwable, message, args);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.INFO_INT, msg, null, throwable);
            } else {
                logger.info(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the info level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param arg1 argument 1
     */
    public void info(Marker marker, E message, Object arg1) {
        if (info(marker)) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.INFO_INT, msg, null, throwable);
            } else {
                logger.info(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the info level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void info(Marker marker, E message, Object arg1, Object arg2) {
        if (info(marker)) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1, arg2);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.INFO_INT, msg, null, throwable);
            } else {
                logger.info(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the info level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void info(Marker marker, E message, Object arg1, Object arg2, Object arg3) {
        if (info(marker)) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1, arg2, arg3);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.INFO_INT, msg, null, throwable);
            } else {
                logger.info(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the info level.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the message string to be logged
     */
    public void info(Marker marker, Throwable throwable, E message) {
        if (info(marker)) {
            final String msg = f(throwable, message);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.INFO_INT, msg, null, throwable);
            } else {
                logger.info(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the info level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param args an array of arguments
     */
    public void info(Marker marker, Throwable throwable, E message, Object... args) {
        if (info(marker)) {
            final String msg = f(throwable, message, args);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.INFO_INT, msg, null, throwable);
            } else {
                logger.info(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the info level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     */
    public void info(Marker marker, Throwable throwable, E message, Object arg1) {
        if (info(marker)) {
            final String msg = f(throwable, message, arg1);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.INFO_INT, msg, null, throwable);
            } else {
                logger.info(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the info level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void info(Marker marker, Throwable throwable, E message, Object arg1, Object arg2) {
        if (info(marker)) {
            final String msg = f(throwable, message, arg1, arg2);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.INFO_INT, msg, null, throwable);
            } else {
                logger.info(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the info level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void info(Marker marker, Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        if (info(marker)) {
            final String msg = f(throwable, message, arg1, arg2, arg3);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.INFO_INT, msg, null, throwable);
            } else {
                logger.info(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message at the warn level.
     * 
     * @param message the message string to be logged
     */
    public void warn(E message) {
        if (warn()) {
            final Throwable throwable = t(message);
            final String msg = f(message);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.WARN_INT, msg, null, throwable);
            } else {
                logger.warn(msg, throwable);
            }
        }
    }

    /**
     * Log a message at the warn level, according to the specified format and arguments.
     * 
     * @param message the format string
     * @param args an array of arguments
     */
    public void warn(E message, Object... args) {
        if (warn()) {
            final Throwable throwable = t(args);
            final String msg = f(throwable, message, args);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.WARN_INT, msg, null, throwable);
            } else {
                logger.warn(msg, throwable);
            }
        }
    }

    /**
     * Log a message at the warn level, according to the specified format and arguments.
     * 
     * @param message the format string
     * @param arg1 argument 1
     */
    public void warn(E message, Object arg1) {
        if (warn()) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.WARN_INT, msg, null, throwable);
            } else {
                logger.warn(msg, throwable);
            }
        }
    }

    /**
     * Log a message at the warn level, according to the specified format and arguments.
     * 
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void warn(E message, Object arg1, Object arg2) {
        if (warn()) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1, arg2);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.WARN_INT, msg, null, throwable);
            } else {
                logger.warn(msg, throwable);
            }
        }
    }

    /**
     * Log a message at the warn level, according to the specified format and arguments.
     * 
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void warn(E message, Object arg1, Object arg2, Object arg3) {
        if (warn()) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1, arg2, arg3);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.WARN_INT, msg, null, throwable);
            } else {
                logger.warn(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the warn level.
     * 
     * @param throwable the throwable to log
     * @param message the message string to be logged
     */
    public void warn(Throwable throwable, E message) {
        if (warn()) {
            final String msg = f(throwable, message);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.WARN_INT, msg, null, throwable);
            } else {
                logger.warn(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the warn level, according to the specified format and arguments.
     * 
     * @param throwable the throwable to log
     * @param message the format string
     * @param args an array of arguments
     */
    public void warn(Throwable throwable, E message, Object... args) {
        if (warn()) {
            final String msg = f(throwable, message, args);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.WARN_INT, msg, null, throwable);
            } else {
                logger.warn(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the warn level, according to the specified format and arguments.
     * 
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     */
    public void warn(Throwable throwable, E message, Object arg1) {
        if (warn()) {
            final String msg = f(throwable, message, arg1);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.WARN_INT, msg, null, throwable);
            } else {
                logger.warn(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the warn level, according to the specified format and arguments.
     * 
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void warn(Throwable throwable, E message, Object arg1, Object arg2) {
        if (warn()) {
            final String msg = f(throwable, message, arg1, arg2);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.WARN_INT, msg, null, throwable);
            } else {
                logger.warn(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the warn level, according to the specified format and arguments.
     * 
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void warn(Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        if (warn()) {
            final String msg = f(throwable, message, arg1, arg2, arg3);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.WARN_INT, msg, null, throwable);
            } else {
                logger.warn(msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the warn level.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the message string to be logged
     */
    public void warn(Marker marker, E message) {
        if (warn(marker)) {
            final Throwable throwable = t(message);
            final String msg = f(message);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.WARN_INT, msg, null, throwable);
            } else {
                logger.warn(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the warn level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param args an array of arguments
     */
    public void warn(Marker marker, E message, Object... args) {
        if (warn(marker)) {
            final Throwable throwable = t(args);
            final String msg = f(throwable, message, args);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.WARN_INT, msg, null, throwable);
            } else {
                logger.warn(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the warn level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param arg1 argument 1
     */
    public void warn(Marker marker, E message, Object arg1) {
        if (warn(marker)) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.WARN_INT, msg, null, throwable);
            } else {
                logger.warn(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the warn level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void warn(Marker marker, E message, Object arg1, Object arg2) {
        if (warn(marker)) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1, arg2);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.WARN_INT, msg, null, throwable);
            } else {
                logger.warn(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the warn level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void warn(Marker marker, E message, Object arg1, Object arg2, Object arg3) {
        if (warn(marker)) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1, arg2, arg3);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.WARN_INT, msg, null, throwable);
            } else {
                logger.warn(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the warn level.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the message string to be logged
     */
    public void warn(Marker marker, Throwable throwable, E message) {
        if (warn(marker)) {
            final String msg = f(throwable, message);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.WARN_INT, msg, null, throwable);
            } else {
                logger.warn(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the warn level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param args an array of arguments
     */
    public void warn(Marker marker, Throwable throwable, E message, Object... args) {
        if (warn(marker)) {
            final String msg = f(throwable, message, args);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.WARN_INT, msg, null, throwable);
            } else {
                logger.warn(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the warn level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     */
    public void warn(Marker marker, Throwable throwable, E message, Object arg1) {
        if (warn(marker)) {
            final String msg = f(throwable, message, arg1);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.WARN_INT, msg, null, throwable);
            } else {
                logger.warn(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the warn level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void warn(Marker marker, Throwable throwable, E message, Object arg1, Object arg2) {
        if (warn(marker)) {
            final String msg = f(throwable, message, arg1, arg2);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.WARN_INT, msg, null, throwable);
            } else {
                logger.warn(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the warn level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void warn(Marker marker, Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        if (warn(marker)) {
            final String msg = f(throwable, message, arg1, arg2, arg3);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.WARN_INT, msg, null, throwable);
            } else {
                logger.warn(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message at the error level.
     * 
     * @param message the message string to be logged
     */
    public void error(E message) {
        if (error()) {
            final Throwable throwable = t(message);
            final String msg = f(message);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.ERROR_INT, msg, null, throwable);
            } else {
                logger.error(msg, throwable);
            }
        }
    }

    /**
     * Log a message at the error level, according to the specified format and arguments.
     * 
     * @param message the format string
     * @param args an array of arguments
     */
    public void error(E message, Object... args) {
        if (error()) {
            final Throwable throwable = t(args);
            final String msg = f(throwable, message, args);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.ERROR_INT, msg, null, throwable);
            } else {
                logger.error(msg, throwable);
            }
        }
    }

    /**
     * Log a message at the error level, according to the specified format and arguments.
     * 
     * @param message the format string
     * @param arg1 argument 1
     */
    public void error(E message, Object arg1) {
        if (error()) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.ERROR_INT, msg, null, throwable);
            } else {
                logger.error(msg, throwable);
            }
        }
    }

    /**
     * Log a message at the error level, according to the specified format and arguments.
     * 
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void error(E message, Object arg1, Object arg2) {
        if (error()) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1, arg2);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.ERROR_INT, msg, null, throwable);
            } else {
                logger.error(msg, throwable);
            }
        }
    }

    /**
     * Log a message at the error level, according to the specified format and arguments.
     * 
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void error(E message, Object arg1, Object arg2, Object arg3) {
        if (error()) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1, arg2, arg3);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.ERROR_INT, msg, null, throwable);
            } else {
                logger.error(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the error level.
     * 
     * @param throwable the throwable to log
     * @param message the message string to be logged
     */
    public void error(Throwable throwable, E message) {
        if (error()) {
            final String msg = f(throwable, message);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.ERROR_INT, msg, null, throwable);
            } else {
                logger.error(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the error level, according to the specified format and arguments.
     * 
     * @param throwable the throwable to log
     * @param message the format string
     * @param args an array of arguments
     */
    public void error(Throwable throwable, E message, Object... args) {
        if (error()) {
            final String msg = f(throwable, message, args);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.ERROR_INT, msg, null, throwable);
            } else {
                logger.error(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the error level, according to the specified format and arguments.
     * 
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     */
    public void error(Throwable throwable, E message, Object arg1) {
        if (error()) {
            final String msg = f(throwable, message, arg1);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.ERROR_INT, msg, null, throwable);
            } else {
                logger.error(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the error level, according to the specified format and arguments.
     * 
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void error(Throwable throwable, E message, Object arg1, Object arg2) {
        if (error()) {
            final String msg = f(throwable, message, arg1, arg2);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.ERROR_INT, msg, null, throwable);
            } else {
                logger.error(msg, throwable);
            }
        }
    }

    /**
     * Log an exception at the error level, according to the specified format and arguments.
     * 
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void error(Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        if (error()) {
            final String msg = f(throwable, message, arg1, arg2, arg3);
            if (laLogger != null) {
                laLogger.log(null, FQCN, LocationAwareLogger.ERROR_INT, msg, null, throwable);
            } else {
                logger.error(msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the error level.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the message string to be logged
     */
    public void error(Marker marker, E message) {
        if (error(marker)) {
            final Throwable throwable = t(message);
            final String msg = f(message);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.ERROR_INT, msg, null, throwable);
            } else {
                logger.error(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the error level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param args an array of arguments
     */
    public void error(Marker marker, E message, Object... args) {
        if (error(marker)) {
            final Throwable throwable = t(args);
            final String msg = f(throwable, message, args);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.ERROR_INT, msg, null, throwable);
            } else {
                logger.error(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the error level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param arg1 argument 1
     */
    public void error(Marker marker, E message, Object arg1) {
        if (error(marker)) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.ERROR_INT, msg, null, throwable);
            } else {
                logger.error(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the error level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void error(Marker marker, E message, Object arg1, Object arg2) {
        if (error(marker)) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1, arg2);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.ERROR_INT, msg, null, throwable);
            } else {
                logger.error(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message with the specific Marker at the error level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void error(Marker marker, E message, Object arg1, Object arg2, Object arg3) {
        if (error(marker)) {
            final Throwable throwable = t(arg1);
            final String msg = f(throwable, message, arg1, arg2, arg3);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.ERROR_INT, msg, null, throwable);
            } else {
                logger.error(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the error level.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the message string to be logged
     */
    public void error(Marker marker, Throwable throwable, E message) {
        if (error(marker)) {
            final String msg = f(throwable, message);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.ERROR_INT, msg, null, throwable);
            } else {
                logger.error(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the error level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param args an array of arguments
     */
    public void error(Marker marker, Throwable throwable, E message, Object... args) {
        if (error(marker)) {
            final String msg = f(throwable, message, args);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.ERROR_INT, msg, null, throwable);
            } else {
                logger.error(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the error level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     */
    public void error(Marker marker, Throwable throwable, E message, Object arg1) {
        if (error(marker)) {
            final String msg = f(throwable, message, arg1);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.ERROR_INT, msg, null, throwable);
            } else {
                logger.error(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the error level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void error(Marker marker, Throwable throwable, E message, Object arg1, Object arg2) {
        if (error(marker)) {
            final String msg = f(throwable, message, arg1, arg2);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.ERROR_INT, msg, null, throwable);
            } else {
                logger.error(marker, msg, throwable);
            }
        }
    }

    /**
     * Log an exception with the specific Marker at the error level, according to the specified format and arguments.
     * 
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void error(Marker marker, Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        if (error(marker)) {
            final String msg = f(throwable, message, arg1, arg2, arg3);
            if (laLogger != null) {
                laLogger.log(marker, FQCN, LocationAwareLogger.ERROR_INT, msg, null, throwable);
            } else {
                logger.error(marker, msg, throwable);
            }
        }
    }

    /**
     * Log a message at the given level.
     * 
     * @param level the log level
     * @param message the message string to be logged
     */
    public void log(CLogLevel level, E message) {
        switch (level) {
            case Trace:
                trace(message);
                break;
            case Debug:
                debug(message);
                break;
            case Info:
                info(message);
                break;
            case Warn:
                warn(message);
                break;
            case Error:
                error(message);
                break;
            default:
                throw new IllegalArgumentException(level.toString());
        }
    }

    /**
     * Log a message at the given level, according to the specified format and arguments.
     * 
     * @param level the log level
     * @param message the format string
     * @param args an array of arguments
     */
    public void log(CLogLevel level, E message, Object... args) {
        switch (level) {
            case Trace:
                trace(message, args);
                break;
            case Debug:
                debug(message, args);
                break;
            case Info:
                info(message, args);
                break;
            case Warn:
                warn(message, args);
                break;
            case Error:
                error(message, args);
                break;
            default:
                throw new IllegalArgumentException(level.toString());
        }
    }

    /**
     * Log a message at the given level, according to the specified format and arguments.
     * 
     * @param level the log level
     * @param message the format string
     * @param arg1 argument 1
     */
    public void log(CLogLevel level, E message, Object arg1) {
        switch (level) {
            case Trace:
                trace(message, arg1);
                break;
            case Debug:
                debug(message, arg1);
                break;
            case Info:
                info(message, arg1);
                break;
            case Warn:
                warn(message, arg1);
                break;
            case Error:
                error(message, arg1);
                break;
            default:
                throw new IllegalArgumentException(level.toString());
        }
    }

    /**
     * Log a message at the given level, according to the specified format and arguments.
     * 
     * @param level the log level
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void log(CLogLevel level, E message, Object arg1, Object arg2) {
        switch (level) {
            case Trace:
                trace(message, arg1, arg2);
                break;
            case Debug:
                debug(message, arg1, arg2);
                break;
            case Info:
                info(message, arg1, arg2);
                break;
            case Warn:
                warn(message, arg1, arg2);
                break;
            case Error:
                error(message, arg1, arg2);
                break;
            default:
                throw new IllegalArgumentException(level.toString());
        }
    }

    /**
     * Log a message at the given level, according to the specified format and arguments.
     * 
     * @param level the log level
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void log(CLogLevel level, E message, Object arg1, Object arg2, Object arg3) {
        switch (level) {
            case Trace:
                trace(message, arg1, arg2, arg3);
                break;
            case Debug:
                debug(message, arg1, arg2, arg3);
                break;
            case Info:
                info(message, arg1, arg2, arg3);
                break;
            case Warn:
                warn(message, arg1, arg2, arg3);
                break;
            case Error:
                error(message, arg1, arg2, arg3);
                break;
            default:
                throw new IllegalArgumentException(level.toString());
        }
    }

    /**
     * Log an exception at the given level.
     * 
     * @param level the log level
     * @param throwable the throwable to log
     * @param message the message string to be logged
     */
    public void log(CLogLevel level, Throwable throwable, E message) {
        switch (level) {
            case Trace:
                trace(throwable, message);
                break;
            case Debug:
                debug(throwable, message);
                break;
            case Info:
                info(throwable, message);
                break;
            case Warn:
                warn(throwable, message);
                break;
            case Error:
                error(throwable, message);
                break;
            default:
                throw new IllegalArgumentException(level.toString());
        }
    }

    /**
     * Log an exception at the given level, according to the specified format and arguments.
     * 
     * @param level the log level
     * @param throwable the throwable to log
     * @param message the format string
     * @param args an array of arguments
     */
    public void log(CLogLevel level, Throwable throwable, E message, Object... args) {
        switch (level) {
            case Trace:
                trace(throwable, message, args);
                break;
            case Debug:
                debug(throwable, message, args);
                break;
            case Info:
                info(throwable, message, args);
                break;
            case Warn:
                warn(throwable, message, args);
                break;
            case Error:
                error(throwable, message, args);
                break;
            default:
                throw new IllegalArgumentException(level.toString());
        }
    }

    /**
     * Log an exception at the given level, according to the specified format and arguments.
     * 
     * @param level the log level
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     */
    public void log(CLogLevel level, Throwable throwable, E message, Object arg1) {
        switch (level) {
            case Trace:
                trace(throwable, message, arg1);
                break;
            case Debug:
                debug(throwable, message, arg1);
                break;
            case Info:
                info(throwable, message, arg1);
                break;
            case Warn:
                warn(throwable, message, arg1);
                break;
            case Error:
                error(throwable, message, arg1);
                break;
            default:
                throw new IllegalArgumentException(level.toString());
        }
    }

    /**
     * Log an exception at the given level, according to the specified format and arguments.
     * 
     * @param level the log level
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void log(CLogLevel level, Throwable throwable, E message, Object arg1, Object arg2) {
        switch (level) {
            case Trace:
                trace(throwable, message, arg1, arg2);
                break;
            case Debug:
                debug(throwable, message, arg1, arg2);
                break;
            case Info:
                info(throwable, message, arg1, arg2);
                break;
            case Warn:
                warn(throwable, message, arg1, arg2);
                break;
            case Error:
                error(throwable, message, arg1, arg2);
                break;
            default:
                throw new IllegalArgumentException(level.toString());
        }
    }

    /**
     * Log an exception at the given level, according to the specified format and arguments.
     * 
     * @param level the log level
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void log(CLogLevel level, Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        switch (level) {
            case Trace:
                trace(throwable, message, arg1, arg2, arg3);
                break;
            case Debug:
                debug(throwable, message, arg1, arg2, arg3);
                break;
            case Info:
                info(throwable, message, arg1, arg2, arg3);
                break;
            case Warn:
                warn(throwable, message, arg1, arg2, arg3);
                break;
            case Error:
                error(throwable, message, arg1, arg2, arg3);
                break;
            default:
                throw new IllegalArgumentException(level.toString());
        }
    }

    /**
     * Log a message with the specific Marker at the given level.
     * 
     * @param level the log level
     * @param marker the marker data specific to this log statement
     * @param message the message string to be logged
     */
    public void log(CLogLevel level, Marker marker, E message) {
        switch (level) {
            case Trace:
                trace(marker, message);
                break;
            case Debug:
                debug(marker, message);
                break;
            case Info:
                info(marker, message);
                break;
            case Warn:
                warn(marker, message);
                break;
            case Error:
                error(marker, message);
                break;
            default:
                throw new IllegalArgumentException(level.toString());
        }
    }

    /**
     * Log a message with the specific Marker at the given level, according to the specified format and arguments.
     * 
     * @param level the log level
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param args an array of arguments
     */
    public void log(CLogLevel level, Marker marker, E message, Object... args) {
        switch (level) {
            case Trace:
                trace(marker, message, args);
                break;
            case Debug:
                debug(marker, message, args);
                break;
            case Info:
                info(marker, message, args);
                break;
            case Warn:
                warn(marker, message, args);
                break;
            case Error:
                error(marker, message, args);
                break;
            default:
                throw new IllegalArgumentException(level.toString());
        }
    }

    /**
     * Log a message with the specific Marker at the given level, according to the specified format and arguments.
     * 
     * @param level the log level
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param arg1 argument 1
     */
    public void log(CLogLevel level, Marker marker, E message, Object arg1) {
        switch (level) {
            case Trace:
                trace(marker, message, arg1);
                break;
            case Debug:
                debug(marker, message, arg1);
                break;
            case Info:
                info(marker, message, arg1);
                break;
            case Warn:
                warn(marker, message, arg1);
                break;
            case Error:
                error(marker, message, arg1);
                break;
            default:
                throw new IllegalArgumentException(level.toString());
        }
    }

    /**
     * Log a message with the specific Marker at the given level, according to the specified format and arguments.
     * 
     * @param level the log level
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void log(CLogLevel level, Marker marker, E message, Object arg1, Object arg2) {
        switch (level) {
            case Trace:
                trace(marker, message, arg1, arg2);
                break;
            case Debug:
                debug(marker, message, arg1, arg2);
                break;
            case Info:
                info(marker, message, arg1, arg2);
                break;
            case Warn:
                warn(marker, message, arg1, arg2);
                break;
            case Error:
                error(marker, message, arg1, arg2);
                break;
            default:
                throw new IllegalArgumentException(level.toString());
        }
    }

    /**
     * Log a message with the specific Marker at the given level, according to the specified format and arguments.
     * 
     * @param level the log level
     * @param marker the marker data specific to this log statement
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void log(CLogLevel level, Marker marker, E message, Object arg1, Object arg2, Object arg3) {
        switch (level) {
            case Trace:
                trace(marker, message, arg1, arg2, arg3);
                break;
            case Debug:
                debug(marker, message, arg1, arg2, arg3);
                break;
            case Info:
                info(marker, message, arg1, arg2, arg3);
                break;
            case Warn:
                warn(marker, message, arg1, arg2, arg3);
                break;
            case Error:
                error(marker, message, arg1, arg2, arg3);
                break;
            default:
                throw new IllegalArgumentException(level.toString());
        }
    }

    /**
     * Log an exception with the specific Marker at the given level.
     * 
     * @param level the log level
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the message string to be logged
     */
    public void log(CLogLevel level, Marker marker, Throwable throwable, E message) {
        switch (level) {
            case Trace:
                trace(marker, throwable, message);
                break;
            case Debug:
                debug(marker, throwable, message);
                break;
            case Info:
                info(marker, throwable, message);
                break;
            case Warn:
                warn(marker, throwable, message);
                break;
            case Error:
                error(marker, throwable, message);
                break;
            default:
                throw new IllegalArgumentException(level.toString());
        }
    }

    /**
     * Log an exception with the specific Marker at the given level, according to the specified format and arguments.
     * 
     * @param level the log level
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param args an array of arguments
     */
    public void log(CLogLevel level, Marker marker, Throwable throwable, E message, Object... args) {
        switch (level) {
            case Trace:
                trace(marker, throwable, message, args);
                break;
            case Debug:
                debug(marker, throwable, message, args);
                break;
            case Info:
                info(marker, throwable, message, args);
                break;
            case Warn:
                warn(marker, throwable, message, args);
                break;
            case Error:
                error(marker, throwable, message, args);
                break;
            default:
                throw new IllegalArgumentException(level.toString());
        }
    }

    /**
     * Log an exception with the specific Marker at the given level, according to the specified format and arguments.
     * 
     * @param level the log level
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     */
    public void log(CLogLevel level, Marker marker, Throwable throwable, E message, Object arg1) {
        switch (level) {
            case Trace:
                trace(marker, throwable, message, arg1);
                break;
            case Debug:
                debug(marker, throwable, message, arg1);
                break;
            case Info:
                info(marker, throwable, message, arg1);
                break;
            case Warn:
                warn(marker, throwable, message, arg1);
                break;
            case Error:
                error(marker, throwable, message, arg1);
                break;
            default:
                throw new IllegalArgumentException(level.toString());
        }
    }

    /**
     * Log an exception with the specific Marker at the given level, according to the specified format and arguments.
     * 
     * @param level the log level
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     */
    public void log(CLogLevel level, Marker marker, Throwable throwable, E message, Object arg1, Object arg2) {
        switch (level) {
            case Trace:
                trace(marker, throwable, message, arg1, arg2);
                break;
            case Debug:
                debug(marker, throwable, message, arg1, arg2);
                break;
            case Info:
                info(marker, throwable, message, arg1, arg2);
                break;
            case Warn:
                warn(marker, throwable, message, arg1, arg2);
                break;
            case Error:
                error(marker, throwable, message, arg1, arg2);
                break;
            default:
                throw new IllegalArgumentException(level.toString());
        }
    }

    /**
     * Log an exception with the specific Marker at the given level, according to the specified format and arguments.
     * 
     * @param level the log level
     * @param marker the marker data specific to this log statement
     * @param throwable the throwable to log
     * @param message the format string
     * @param arg1 argument 1
     * @param arg2 argument 2
     * @param arg3 argument 3
     */
    public void log(CLogLevel level, Marker marker, Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        switch (level) {
            case Trace:
                trace(marker, throwable, message, arg1, arg2, arg3);
                break;
            case Debug:
                debug(marker, throwable, message, arg1, arg2, arg3);
                break;
            case Info:
                info(marker, throwable, message, arg1, arg2, arg3);
                break;
            case Warn:
                warn(marker, throwable, message, arg1, arg2, arg3);
                break;
            case Error:
                error(marker, throwable, message, arg1, arg2, arg3);
                break;
            default:
                throw new IllegalArgumentException(level.toString());
        }
    }

}
