/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.log;

import org.cthul.log.CLocLogConfiguration;
import org.cthul.log.CLogConfigurationBase;
import org.cthul.log.CLogLevel;
import org.cthul.log.CLoggerBase;
import org.cthul.log.LocFormatArgs;
import org.cthul.log.NamedParameters;
import org.cthul.strings.Strings;
import org.cthul.strings.format.FormatArgs;
import org.cthul.strings.format.FormatterConfiguration;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class CLocLogger<E extends Enum<?>>
extends CLoggerBase {
    private static final String FQCN = CLocLogger.class.getName();
    protected final CLocLogConfiguration locConf;

    public CLocLogger(Logger logger) {
        this(logger, CLocLogConfiguration.getDefault());
    }

    public CLocLogger(Logger logger, CLocLogConfiguration conf) {
        super(logger, (CLogConfigurationBase)conf);
        this.locConf = new CLocLogConfiguration(this.conf);
    }

    protected String m(E message) {
        return this.locConf.getMessage((Enum<?>)message);
    }

    protected String f(E message) {
        return this.m(message);
    }

    protected String f(Throwable throwable, E message) {
        return Strings.format((FormatterConfiguration)this.conf, (Throwable)throwable, (Object)this.m(message), (Object[])new Object[0]);
    }

    protected String f(Throwable throwable, E message, Object ... args) {
        if (message instanceof NamedParameters) {
            LocFormatArgs fargs = new LocFormatArgs(throwable, ((NamedParameters)message).getNames(), args);
            return Strings.format((FormatterConfiguration)this.conf, (Object)this.m(message), (FormatArgs)fargs);
        }
        return Strings.format((FormatterConfiguration)this.conf, (Throwable)throwable, (Object)this.m(message), (Object[])args);
    }

    public void trace(E message) {
        if (this.trace()) {
            Throwable throwable = CLocLogger.t(message);
            String msg = this.f(message);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 0, msg, null, throwable);
            } else {
                this.logger.trace(msg, throwable);
            }
        }
    }

    public void trace(E message, Object ... args) {
        if (this.trace()) {
            Throwable throwable = CLocLogger.t((Object[])args);
            String msg = this.f(throwable, message, args);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 0, msg, null, throwable);
            } else {
                this.logger.trace(msg, throwable);
            }
        }
    }

    public void trace(E message, Object arg1) {
        if (this.trace()) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 0, msg, null, throwable);
            } else {
                this.logger.trace(msg, throwable);
            }
        }
    }

    public void trace(E message, Object arg1, Object arg2) {
        if (this.trace()) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1, arg2);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 0, msg, null, throwable);
            } else {
                this.logger.trace(msg, throwable);
            }
        }
    }

    public void trace(E message, Object arg1, Object arg2, Object arg3) {
        if (this.trace()) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1, arg2, arg3);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 0, msg, null, throwable);
            } else {
                this.logger.trace(msg, throwable);
            }
        }
    }

    public void trace(Throwable throwable, E message) {
        if (this.trace()) {
            String msg = this.f(throwable, message);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 0, msg, null, throwable);
            } else {
                this.logger.trace(msg, throwable);
            }
        }
    }

    public void trace(Throwable throwable, E message, Object ... args) {
        if (this.trace()) {
            String msg = this.f(throwable, message, args);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 0, msg, null, throwable);
            } else {
                this.logger.trace(msg, throwable);
            }
        }
    }

    public void trace(Throwable throwable, E message, Object arg1) {
        if (this.trace()) {
            String msg = this.f(throwable, message, arg1);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 0, msg, null, throwable);
            } else {
                this.logger.trace(msg, throwable);
            }
        }
    }

    public void trace(Throwable throwable, E message, Object arg1, Object arg2) {
        if (this.trace()) {
            String msg = this.f(throwable, message, arg1, arg2);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 0, msg, null, throwable);
            } else {
                this.logger.trace(msg, throwable);
            }
        }
    }

    public void trace(Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        if (this.trace()) {
            String msg = this.f(throwable, message, arg1, arg2, arg3);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 0, msg, null, throwable);
            } else {
                this.logger.trace(msg, throwable);
            }
        }
    }

    public void trace(Marker marker, E message) {
        if (this.trace(marker)) {
            Throwable throwable = CLocLogger.t(message);
            String msg = this.f(message);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 0, msg, null, throwable);
            } else {
                this.logger.trace(marker, msg, throwable);
            }
        }
    }

    public void trace(Marker marker, E message, Object ... args) {
        if (this.trace(marker)) {
            Throwable throwable = CLocLogger.t((Object[])args);
            String msg = this.f(throwable, message, args);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 0, msg, null, throwable);
            } else {
                this.logger.trace(marker, msg, throwable);
            }
        }
    }

    public void trace(Marker marker, E message, Object arg1) {
        if (this.trace(marker)) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 0, msg, null, throwable);
            } else {
                this.logger.trace(marker, msg, throwable);
            }
        }
    }

    public void trace(Marker marker, E message, Object arg1, Object arg2) {
        if (this.trace(marker)) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1, arg2);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 0, msg, null, throwable);
            } else {
                this.logger.trace(marker, msg, throwable);
            }
        }
    }

    public void trace(Marker marker, E message, Object arg1, Object arg2, Object arg3) {
        if (this.trace(marker)) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1, arg2, arg3);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 0, msg, null, throwable);
            } else {
                this.logger.trace(marker, msg, throwable);
            }
        }
    }

    public void trace(Marker marker, Throwable throwable, E message) {
        if (this.trace(marker)) {
            String msg = this.f(throwable, message);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 0, msg, null, throwable);
            } else {
                this.logger.trace(marker, msg, throwable);
            }
        }
    }

    public void trace(Marker marker, Throwable throwable, E message, Object ... args) {
        if (this.trace(marker)) {
            String msg = this.f(throwable, message, args);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 0, msg, null, throwable);
            } else {
                this.logger.trace(marker, msg, throwable);
            }
        }
    }

    public void trace(Marker marker, Throwable throwable, E message, Object arg1) {
        if (this.trace(marker)) {
            String msg = this.f(throwable, message, arg1);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 0, msg, null, throwable);
            } else {
                this.logger.trace(marker, msg, throwable);
            }
        }
    }

    public void trace(Marker marker, Throwable throwable, E message, Object arg1, Object arg2) {
        if (this.trace(marker)) {
            String msg = this.f(throwable, message, arg1, arg2);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 0, msg, null, throwable);
            } else {
                this.logger.trace(marker, msg, throwable);
            }
        }
    }

    public void trace(Marker marker, Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        if (this.trace(marker)) {
            String msg = this.f(throwable, message, arg1, arg2, arg3);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 0, msg, null, throwable);
            } else {
                this.logger.trace(marker, msg, throwable);
            }
        }
    }

    public void debug(E message) {
        if (this.debug()) {
            Throwable throwable = CLocLogger.t(message);
            String msg = this.f(message);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 10, msg, null, throwable);
            } else {
                this.logger.debug(msg, throwable);
            }
        }
    }

    public void debug(E message, Object ... args) {
        if (this.debug()) {
            Throwable throwable = CLocLogger.t((Object[])args);
            String msg = this.f(throwable, message, args);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 10, msg, null, throwable);
            } else {
                this.logger.debug(msg, throwable);
            }
        }
    }

    public void debug(E message, Object arg1) {
        if (this.debug()) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 10, msg, null, throwable);
            } else {
                this.logger.debug(msg, throwable);
            }
        }
    }

    public void debug(E message, Object arg1, Object arg2) {
        if (this.debug()) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1, arg2);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 10, msg, null, throwable);
            } else {
                this.logger.debug(msg, throwable);
            }
        }
    }

    public void debug(E message, Object arg1, Object arg2, Object arg3) {
        if (this.debug()) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1, arg2, arg3);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 10, msg, null, throwable);
            } else {
                this.logger.debug(msg, throwable);
            }
        }
    }

    public void debug(Throwable throwable, E message) {
        if (this.debug()) {
            String msg = this.f(throwable, message);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 10, msg, null, throwable);
            } else {
                this.logger.debug(msg, throwable);
            }
        }
    }

    public void debug(Throwable throwable, E message, Object ... args) {
        if (this.debug()) {
            String msg = this.f(throwable, message, args);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 10, msg, null, throwable);
            } else {
                this.logger.debug(msg, throwable);
            }
        }
    }

    public void debug(Throwable throwable, E message, Object arg1) {
        if (this.debug()) {
            String msg = this.f(throwable, message, arg1);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 10, msg, null, throwable);
            } else {
                this.logger.debug(msg, throwable);
            }
        }
    }

    public void debug(Throwable throwable, E message, Object arg1, Object arg2) {
        if (this.debug()) {
            String msg = this.f(throwable, message, arg1, arg2);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 10, msg, null, throwable);
            } else {
                this.logger.debug(msg, throwable);
            }
        }
    }

    public void debug(Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        if (this.debug()) {
            String msg = this.f(throwable, message, arg1, arg2, arg3);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 10, msg, null, throwable);
            } else {
                this.logger.debug(msg, throwable);
            }
        }
    }

    public void debug(Marker marker, E message) {
        if (this.debug(marker)) {
            Throwable throwable = CLocLogger.t(message);
            String msg = this.f(message);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 10, msg, null, throwable);
            } else {
                this.logger.debug(marker, msg, throwable);
            }
        }
    }

    public void debug(Marker marker, E message, Object ... args) {
        if (this.debug(marker)) {
            Throwable throwable = CLocLogger.t((Object[])args);
            String msg = this.f(throwable, message, args);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 10, msg, null, throwable);
            } else {
                this.logger.debug(marker, msg, throwable);
            }
        }
    }

    public void debug(Marker marker, E message, Object arg1) {
        if (this.debug(marker)) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 10, msg, null, throwable);
            } else {
                this.logger.debug(marker, msg, throwable);
            }
        }
    }

    public void debug(Marker marker, E message, Object arg1, Object arg2) {
        if (this.debug(marker)) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1, arg2);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 10, msg, null, throwable);
            } else {
                this.logger.debug(marker, msg, throwable);
            }
        }
    }

    public void debug(Marker marker, E message, Object arg1, Object arg2, Object arg3) {
        if (this.debug(marker)) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1, arg2, arg3);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 10, msg, null, throwable);
            } else {
                this.logger.debug(marker, msg, throwable);
            }
        }
    }

    public void debug(Marker marker, Throwable throwable, E message) {
        if (this.debug(marker)) {
            String msg = this.f(throwable, message);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 10, msg, null, throwable);
            } else {
                this.logger.debug(marker, msg, throwable);
            }
        }
    }

    public void debug(Marker marker, Throwable throwable, E message, Object ... args) {
        if (this.debug(marker)) {
            String msg = this.f(throwable, message, args);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 10, msg, null, throwable);
            } else {
                this.logger.debug(marker, msg, throwable);
            }
        }
    }

    public void debug(Marker marker, Throwable throwable, E message, Object arg1) {
        if (this.debug(marker)) {
            String msg = this.f(throwable, message, arg1);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 10, msg, null, throwable);
            } else {
                this.logger.debug(marker, msg, throwable);
            }
        }
    }

    public void debug(Marker marker, Throwable throwable, E message, Object arg1, Object arg2) {
        if (this.debug(marker)) {
            String msg = this.f(throwable, message, arg1, arg2);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 10, msg, null, throwable);
            } else {
                this.logger.debug(marker, msg, throwable);
            }
        }
    }

    public void debug(Marker marker, Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        if (this.debug(marker)) {
            String msg = this.f(throwable, message, arg1, arg2, arg3);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 10, msg, null, throwable);
            } else {
                this.logger.debug(marker, msg, throwable);
            }
        }
    }

    public void info(E message) {
        if (this.info()) {
            Throwable throwable = CLocLogger.t(message);
            String msg = this.f(message);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 20, msg, null, throwable);
            } else {
                this.logger.info(msg, throwable);
            }
        }
    }

    public void info(E message, Object ... args) {
        if (this.info()) {
            Throwable throwable = CLocLogger.t((Object[])args);
            String msg = this.f(throwable, message, args);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 20, msg, null, throwable);
            } else {
                this.logger.info(msg, throwable);
            }
        }
    }

    public void info(E message, Object arg1) {
        if (this.info()) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 20, msg, null, throwable);
            } else {
                this.logger.info(msg, throwable);
            }
        }
    }

    public void info(E message, Object arg1, Object arg2) {
        if (this.info()) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1, arg2);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 20, msg, null, throwable);
            } else {
                this.logger.info(msg, throwable);
            }
        }
    }

    public void info(E message, Object arg1, Object arg2, Object arg3) {
        if (this.info()) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1, arg2, arg3);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 20, msg, null, throwable);
            } else {
                this.logger.info(msg, throwable);
            }
        }
    }

    public void info(Throwable throwable, E message) {
        if (this.info()) {
            String msg = this.f(throwable, message);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 20, msg, null, throwable);
            } else {
                this.logger.info(msg, throwable);
            }
        }
    }

    public void info(Throwable throwable, E message, Object ... args) {
        if (this.info()) {
            String msg = this.f(throwable, message, args);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 20, msg, null, throwable);
            } else {
                this.logger.info(msg, throwable);
            }
        }
    }

    public void info(Throwable throwable, E message, Object arg1) {
        if (this.info()) {
            String msg = this.f(throwable, message, arg1);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 20, msg, null, throwable);
            } else {
                this.logger.info(msg, throwable);
            }
        }
    }

    public void info(Throwable throwable, E message, Object arg1, Object arg2) {
        if (this.info()) {
            String msg = this.f(throwable, message, arg1, arg2);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 20, msg, null, throwable);
            } else {
                this.logger.info(msg, throwable);
            }
        }
    }

    public void info(Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        if (this.info()) {
            String msg = this.f(throwable, message, arg1, arg2, arg3);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 20, msg, null, throwable);
            } else {
                this.logger.info(msg, throwable);
            }
        }
    }

    public void info(Marker marker, E message) {
        if (this.info(marker)) {
            Throwable throwable = CLocLogger.t(message);
            String msg = this.f(message);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 20, msg, null, throwable);
            } else {
                this.logger.info(marker, msg, throwable);
            }
        }
    }

    public void info(Marker marker, E message, Object ... args) {
        if (this.info(marker)) {
            Throwable throwable = CLocLogger.t((Object[])args);
            String msg = this.f(throwable, message, args);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 20, msg, null, throwable);
            } else {
                this.logger.info(marker, msg, throwable);
            }
        }
    }

    public void info(Marker marker, E message, Object arg1) {
        if (this.info(marker)) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 20, msg, null, throwable);
            } else {
                this.logger.info(marker, msg, throwable);
            }
        }
    }

    public void info(Marker marker, E message, Object arg1, Object arg2) {
        if (this.info(marker)) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1, arg2);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 20, msg, null, throwable);
            } else {
                this.logger.info(marker, msg, throwable);
            }
        }
    }

    public void info(Marker marker, E message, Object arg1, Object arg2, Object arg3) {
        if (this.info(marker)) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1, arg2, arg3);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 20, msg, null, throwable);
            } else {
                this.logger.info(marker, msg, throwable);
            }
        }
    }

    public void info(Marker marker, Throwable throwable, E message) {
        if (this.info(marker)) {
            String msg = this.f(throwable, message);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 20, msg, null, throwable);
            } else {
                this.logger.info(marker, msg, throwable);
            }
        }
    }

    public void info(Marker marker, Throwable throwable, E message, Object ... args) {
        if (this.info(marker)) {
            String msg = this.f(throwable, message, args);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 20, msg, null, throwable);
            } else {
                this.logger.info(marker, msg, throwable);
            }
        }
    }

    public void info(Marker marker, Throwable throwable, E message, Object arg1) {
        if (this.info(marker)) {
            String msg = this.f(throwable, message, arg1);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 20, msg, null, throwable);
            } else {
                this.logger.info(marker, msg, throwable);
            }
        }
    }

    public void info(Marker marker, Throwable throwable, E message, Object arg1, Object arg2) {
        if (this.info(marker)) {
            String msg = this.f(throwable, message, arg1, arg2);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 20, msg, null, throwable);
            } else {
                this.logger.info(marker, msg, throwable);
            }
        }
    }

    public void info(Marker marker, Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        if (this.info(marker)) {
            String msg = this.f(throwable, message, arg1, arg2, arg3);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 20, msg, null, throwable);
            } else {
                this.logger.info(marker, msg, throwable);
            }
        }
    }

    public void warn(E message) {
        if (this.warn()) {
            Throwable throwable = CLocLogger.t(message);
            String msg = this.f(message);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 30, msg, null, throwable);
            } else {
                this.logger.warn(msg, throwable);
            }
        }
    }

    public void warn(E message, Object ... args) {
        if (this.warn()) {
            Throwable throwable = CLocLogger.t((Object[])args);
            String msg = this.f(throwable, message, args);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 30, msg, null, throwable);
            } else {
                this.logger.warn(msg, throwable);
            }
        }
    }

    public void warn(E message, Object arg1) {
        if (this.warn()) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 30, msg, null, throwable);
            } else {
                this.logger.warn(msg, throwable);
            }
        }
    }

    public void warn(E message, Object arg1, Object arg2) {
        if (this.warn()) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1, arg2);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 30, msg, null, throwable);
            } else {
                this.logger.warn(msg, throwable);
            }
        }
    }

    public void warn(E message, Object arg1, Object arg2, Object arg3) {
        if (this.warn()) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1, arg2, arg3);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 30, msg, null, throwable);
            } else {
                this.logger.warn(msg, throwable);
            }
        }
    }

    public void warn(Throwable throwable, E message) {
        if (this.warn()) {
            String msg = this.f(throwable, message);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 30, msg, null, throwable);
            } else {
                this.logger.warn(msg, throwable);
            }
        }
    }

    public void warn(Throwable throwable, E message, Object ... args) {
        if (this.warn()) {
            String msg = this.f(throwable, message, args);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 30, msg, null, throwable);
            } else {
                this.logger.warn(msg, throwable);
            }
        }
    }

    public void warn(Throwable throwable, E message, Object arg1) {
        if (this.warn()) {
            String msg = this.f(throwable, message, arg1);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 30, msg, null, throwable);
            } else {
                this.logger.warn(msg, throwable);
            }
        }
    }

    public void warn(Throwable throwable, E message, Object arg1, Object arg2) {
        if (this.warn()) {
            String msg = this.f(throwable, message, arg1, arg2);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 30, msg, null, throwable);
            } else {
                this.logger.warn(msg, throwable);
            }
        }
    }

    public void warn(Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        if (this.warn()) {
            String msg = this.f(throwable, message, arg1, arg2, arg3);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 30, msg, null, throwable);
            } else {
                this.logger.warn(msg, throwable);
            }
        }
    }

    public void warn(Marker marker, E message) {
        if (this.warn(marker)) {
            Throwable throwable = CLocLogger.t(message);
            String msg = this.f(message);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 30, msg, null, throwable);
            } else {
                this.logger.warn(marker, msg, throwable);
            }
        }
    }

    public void warn(Marker marker, E message, Object ... args) {
        if (this.warn(marker)) {
            Throwable throwable = CLocLogger.t((Object[])args);
            String msg = this.f(throwable, message, args);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 30, msg, null, throwable);
            } else {
                this.logger.warn(marker, msg, throwable);
            }
        }
    }

    public void warn(Marker marker, E message, Object arg1) {
        if (this.warn(marker)) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 30, msg, null, throwable);
            } else {
                this.logger.warn(marker, msg, throwable);
            }
        }
    }

    public void warn(Marker marker, E message, Object arg1, Object arg2) {
        if (this.warn(marker)) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1, arg2);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 30, msg, null, throwable);
            } else {
                this.logger.warn(marker, msg, throwable);
            }
        }
    }

    public void warn(Marker marker, E message, Object arg1, Object arg2, Object arg3) {
        if (this.warn(marker)) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1, arg2, arg3);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 30, msg, null, throwable);
            } else {
                this.logger.warn(marker, msg, throwable);
            }
        }
    }

    public void warn(Marker marker, Throwable throwable, E message) {
        if (this.warn(marker)) {
            String msg = this.f(throwable, message);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 30, msg, null, throwable);
            } else {
                this.logger.warn(marker, msg, throwable);
            }
        }
    }

    public void warn(Marker marker, Throwable throwable, E message, Object ... args) {
        if (this.warn(marker)) {
            String msg = this.f(throwable, message, args);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 30, msg, null, throwable);
            } else {
                this.logger.warn(marker, msg, throwable);
            }
        }
    }

    public void warn(Marker marker, Throwable throwable, E message, Object arg1) {
        if (this.warn(marker)) {
            String msg = this.f(throwable, message, arg1);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 30, msg, null, throwable);
            } else {
                this.logger.warn(marker, msg, throwable);
            }
        }
    }

    public void warn(Marker marker, Throwable throwable, E message, Object arg1, Object arg2) {
        if (this.warn(marker)) {
            String msg = this.f(throwable, message, arg1, arg2);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 30, msg, null, throwable);
            } else {
                this.logger.warn(marker, msg, throwable);
            }
        }
    }

    public void warn(Marker marker, Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        if (this.warn(marker)) {
            String msg = this.f(throwable, message, arg1, arg2, arg3);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 30, msg, null, throwable);
            } else {
                this.logger.warn(marker, msg, throwable);
            }
        }
    }

    public void error(E message) {
        if (this.error()) {
            Throwable throwable = CLocLogger.t(message);
            String msg = this.f(message);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 40, msg, null, throwable);
            } else {
                this.logger.error(msg, throwable);
            }
        }
    }

    public void error(E message, Object ... args) {
        if (this.error()) {
            Throwable throwable = CLocLogger.t((Object[])args);
            String msg = this.f(throwable, message, args);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 40, msg, null, throwable);
            } else {
                this.logger.error(msg, throwable);
            }
        }
    }

    public void error(E message, Object arg1) {
        if (this.error()) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 40, msg, null, throwable);
            } else {
                this.logger.error(msg, throwable);
            }
        }
    }

    public void error(E message, Object arg1, Object arg2) {
        if (this.error()) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1, arg2);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 40, msg, null, throwable);
            } else {
                this.logger.error(msg, throwable);
            }
        }
    }

    public void error(E message, Object arg1, Object arg2, Object arg3) {
        if (this.error()) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1, arg2, arg3);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 40, msg, null, throwable);
            } else {
                this.logger.error(msg, throwable);
            }
        }
    }

    public void error(Throwable throwable, E message) {
        if (this.error()) {
            String msg = this.f(throwable, message);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 40, msg, null, throwable);
            } else {
                this.logger.error(msg, throwable);
            }
        }
    }

    public void error(Throwable throwable, E message, Object ... args) {
        if (this.error()) {
            String msg = this.f(throwable, message, args);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 40, msg, null, throwable);
            } else {
                this.logger.error(msg, throwable);
            }
        }
    }

    public void error(Throwable throwable, E message, Object arg1) {
        if (this.error()) {
            String msg = this.f(throwable, message, arg1);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 40, msg, null, throwable);
            } else {
                this.logger.error(msg, throwable);
            }
        }
    }

    public void error(Throwable throwable, E message, Object arg1, Object arg2) {
        if (this.error()) {
            String msg = this.f(throwable, message, arg1, arg2);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 40, msg, null, throwable);
            } else {
                this.logger.error(msg, throwable);
            }
        }
    }

    public void error(Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        if (this.error()) {
            String msg = this.f(throwable, message, arg1, arg2, arg3);
            if (this.laLogger != null) {
                this.laLogger.log(null, FQCN, 40, msg, null, throwable);
            } else {
                this.logger.error(msg, throwable);
            }
        }
    }

    public void error(Marker marker, E message) {
        if (this.error(marker)) {
            Throwable throwable = CLocLogger.t(message);
            String msg = this.f(message);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 40, msg, null, throwable);
            } else {
                this.logger.error(marker, msg, throwable);
            }
        }
    }

    public void error(Marker marker, E message, Object ... args) {
        if (this.error(marker)) {
            Throwable throwable = CLocLogger.t((Object[])args);
            String msg = this.f(throwable, message, args);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 40, msg, null, throwable);
            } else {
                this.logger.error(marker, msg, throwable);
            }
        }
    }

    public void error(Marker marker, E message, Object arg1) {
        if (this.error(marker)) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 40, msg, null, throwable);
            } else {
                this.logger.error(marker, msg, throwable);
            }
        }
    }

    public void error(Marker marker, E message, Object arg1, Object arg2) {
        if (this.error(marker)) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1, arg2);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 40, msg, null, throwable);
            } else {
                this.logger.error(marker, msg, throwable);
            }
        }
    }

    public void error(Marker marker, E message, Object arg1, Object arg2, Object arg3) {
        if (this.error(marker)) {
            Throwable throwable = CLocLogger.t((Object)arg1);
            String msg = this.f(throwable, message, arg1, arg2, arg3);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 40, msg, null, throwable);
            } else {
                this.logger.error(marker, msg, throwable);
            }
        }
    }

    public void error(Marker marker, Throwable throwable, E message) {
        if (this.error(marker)) {
            String msg = this.f(throwable, message);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 40, msg, null, throwable);
            } else {
                this.logger.error(marker, msg, throwable);
            }
        }
    }

    public void error(Marker marker, Throwable throwable, E message, Object ... args) {
        if (this.error(marker)) {
            String msg = this.f(throwable, message, args);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 40, msg, null, throwable);
            } else {
                this.logger.error(marker, msg, throwable);
            }
        }
    }

    public void error(Marker marker, Throwable throwable, E message, Object arg1) {
        if (this.error(marker)) {
            String msg = this.f(throwable, message, arg1);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 40, msg, null, throwable);
            } else {
                this.logger.error(marker, msg, throwable);
            }
        }
    }

    public void error(Marker marker, Throwable throwable, E message, Object arg1, Object arg2) {
        if (this.error(marker)) {
            String msg = this.f(throwable, message, arg1, arg2);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 40, msg, null, throwable);
            } else {
                this.logger.error(marker, msg, throwable);
            }
        }
    }

    public void error(Marker marker, Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        if (this.error(marker)) {
            String msg = this.f(throwable, message, arg1, arg2, arg3);
            if (this.laLogger != null) {
                this.laLogger.log(marker, FQCN, 40, msg, null, throwable);
            } else {
                this.logger.error(marker, msg, throwable);
            }
        }
    }

    public void log(CLogLevel level, E message) {
        switch (level) {
            case Trace: {
                this.trace(message);
                break;
            }
            case Debug: {
                this.debug(message);
                break;
            }
            case Info: {
                this.info(message);
                break;
            }
            case Warn: {
                this.warn(message);
                break;
            }
            case Error: {
                this.error(message);
                break;
            }
            default: {
                throw new IllegalArgumentException(level.toString());
            }
        }
    }

    public void log(CLogLevel level, E message, Object ... args) {
        switch (level) {
            case Trace: {
                this.trace(message, args);
                break;
            }
            case Debug: {
                this.debug(message, args);
                break;
            }
            case Info: {
                this.info(message, args);
                break;
            }
            case Warn: {
                this.warn(message, args);
                break;
            }
            case Error: {
                this.error(message, args);
                break;
            }
            default: {
                throw new IllegalArgumentException(level.toString());
            }
        }
    }

    public void log(CLogLevel level, E message, Object arg1) {
        switch (level) {
            case Trace: {
                this.trace(message, arg1);
                break;
            }
            case Debug: {
                this.debug(message, arg1);
                break;
            }
            case Info: {
                this.info(message, arg1);
                break;
            }
            case Warn: {
                this.warn(message, arg1);
                break;
            }
            case Error: {
                this.error(message, arg1);
                break;
            }
            default: {
                throw new IllegalArgumentException(level.toString());
            }
        }
    }

    public void log(CLogLevel level, E message, Object arg1, Object arg2) {
        switch (level) {
            case Trace: {
                this.trace(message, arg1, arg2);
                break;
            }
            case Debug: {
                this.debug(message, arg1, arg2);
                break;
            }
            case Info: {
                this.info(message, arg1, arg2);
                break;
            }
            case Warn: {
                this.warn(message, arg1, arg2);
                break;
            }
            case Error: {
                this.error(message, arg1, arg2);
                break;
            }
            default: {
                throw new IllegalArgumentException(level.toString());
            }
        }
    }

    public void log(CLogLevel level, E message, Object arg1, Object arg2, Object arg3) {
        switch (level) {
            case Trace: {
                this.trace(message, arg1, arg2, arg3);
                break;
            }
            case Debug: {
                this.debug(message, arg1, arg2, arg3);
                break;
            }
            case Info: {
                this.info(message, arg1, arg2, arg3);
                break;
            }
            case Warn: {
                this.warn(message, arg1, arg2, arg3);
                break;
            }
            case Error: {
                this.error(message, arg1, arg2, arg3);
                break;
            }
            default: {
                throw new IllegalArgumentException(level.toString());
            }
        }
    }

    public void log(CLogLevel level, Throwable throwable, E message) {
        switch (level) {
            case Trace: {
                this.trace(throwable, message);
                break;
            }
            case Debug: {
                this.debug(throwable, message);
                break;
            }
            case Info: {
                this.info(throwable, message);
                break;
            }
            case Warn: {
                this.warn(throwable, message);
                break;
            }
            case Error: {
                this.error(throwable, message);
                break;
            }
            default: {
                throw new IllegalArgumentException(level.toString());
            }
        }
    }

    public void log(CLogLevel level, Throwable throwable, E message, Object ... args) {
        switch (level) {
            case Trace: {
                this.trace(throwable, message, args);
                break;
            }
            case Debug: {
                this.debug(throwable, message, args);
                break;
            }
            case Info: {
                this.info(throwable, message, args);
                break;
            }
            case Warn: {
                this.warn(throwable, message, args);
                break;
            }
            case Error: {
                this.error(throwable, message, args);
                break;
            }
            default: {
                throw new IllegalArgumentException(level.toString());
            }
        }
    }

    public void log(CLogLevel level, Throwable throwable, E message, Object arg1) {
        switch (level) {
            case Trace: {
                this.trace(throwable, message, arg1);
                break;
            }
            case Debug: {
                this.debug(throwable, message, arg1);
                break;
            }
            case Info: {
                this.info(throwable, message, arg1);
                break;
            }
            case Warn: {
                this.warn(throwable, message, arg1);
                break;
            }
            case Error: {
                this.error(throwable, message, arg1);
                break;
            }
            default: {
                throw new IllegalArgumentException(level.toString());
            }
        }
    }

    public void log(CLogLevel level, Throwable throwable, E message, Object arg1, Object arg2) {
        switch (level) {
            case Trace: {
                this.trace(throwable, message, arg1, arg2);
                break;
            }
            case Debug: {
                this.debug(throwable, message, arg1, arg2);
                break;
            }
            case Info: {
                this.info(throwable, message, arg1, arg2);
                break;
            }
            case Warn: {
                this.warn(throwable, message, arg1, arg2);
                break;
            }
            case Error: {
                this.error(throwable, message, arg1, arg2);
                break;
            }
            default: {
                throw new IllegalArgumentException(level.toString());
            }
        }
    }

    public void log(CLogLevel level, Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        switch (level) {
            case Trace: {
                this.trace(throwable, message, arg1, arg2, arg3);
                break;
            }
            case Debug: {
                this.debug(throwable, message, arg1, arg2, arg3);
                break;
            }
            case Info: {
                this.info(throwable, message, arg1, arg2, arg3);
                break;
            }
            case Warn: {
                this.warn(throwable, message, arg1, arg2, arg3);
                break;
            }
            case Error: {
                this.error(throwable, message, arg1, arg2, arg3);
                break;
            }
            default: {
                throw new IllegalArgumentException(level.toString());
            }
        }
    }

    public void log(CLogLevel level, Marker marker, E message) {
        switch (level) {
            case Trace: {
                this.trace(marker, message);
                break;
            }
            case Debug: {
                this.debug(marker, message);
                break;
            }
            case Info: {
                this.info(marker, message);
                break;
            }
            case Warn: {
                this.warn(marker, message);
                break;
            }
            case Error: {
                this.error(marker, message);
                break;
            }
            default: {
                throw new IllegalArgumentException(level.toString());
            }
        }
    }

    public void log(CLogLevel level, Marker marker, E message, Object ... args) {
        switch (level) {
            case Trace: {
                this.trace(marker, message, args);
                break;
            }
            case Debug: {
                this.debug(marker, message, args);
                break;
            }
            case Info: {
                this.info(marker, message, args);
                break;
            }
            case Warn: {
                this.warn(marker, message, args);
                break;
            }
            case Error: {
                this.error(marker, message, args);
                break;
            }
            default: {
                throw new IllegalArgumentException(level.toString());
            }
        }
    }

    public void log(CLogLevel level, Marker marker, E message, Object arg1) {
        switch (level) {
            case Trace: {
                this.trace(marker, message, arg1);
                break;
            }
            case Debug: {
                this.debug(marker, message, arg1);
                break;
            }
            case Info: {
                this.info(marker, message, arg1);
                break;
            }
            case Warn: {
                this.warn(marker, message, arg1);
                break;
            }
            case Error: {
                this.error(marker, message, arg1);
                break;
            }
            default: {
                throw new IllegalArgumentException(level.toString());
            }
        }
    }

    public void log(CLogLevel level, Marker marker, E message, Object arg1, Object arg2) {
        switch (level) {
            case Trace: {
                this.trace(marker, message, arg1, arg2);
                break;
            }
            case Debug: {
                this.debug(marker, message, arg1, arg2);
                break;
            }
            case Info: {
                this.info(marker, message, arg1, arg2);
                break;
            }
            case Warn: {
                this.warn(marker, message, arg1, arg2);
                break;
            }
            case Error: {
                this.error(marker, message, arg1, arg2);
                break;
            }
            default: {
                throw new IllegalArgumentException(level.toString());
            }
        }
    }

    public void log(CLogLevel level, Marker marker, E message, Object arg1, Object arg2, Object arg3) {
        switch (level) {
            case Trace: {
                this.trace(marker, message, arg1, arg2, arg3);
                break;
            }
            case Debug: {
                this.debug(marker, message, arg1, arg2, arg3);
                break;
            }
            case Info: {
                this.info(marker, message, arg1, arg2, arg3);
                break;
            }
            case Warn: {
                this.warn(marker, message, arg1, arg2, arg3);
                break;
            }
            case Error: {
                this.error(marker, message, arg1, arg2, arg3);
                break;
            }
            default: {
                throw new IllegalArgumentException(level.toString());
            }
        }
    }

    public void log(CLogLevel level, Marker marker, Throwable throwable, E message) {
        switch (level) {
            case Trace: {
                this.trace(marker, throwable, message);
                break;
            }
            case Debug: {
                this.debug(marker, throwable, message);
                break;
            }
            case Info: {
                this.info(marker, throwable, message);
                break;
            }
            case Warn: {
                this.warn(marker, throwable, message);
                break;
            }
            case Error: {
                this.error(marker, throwable, message);
                break;
            }
            default: {
                throw new IllegalArgumentException(level.toString());
            }
        }
    }

    public void log(CLogLevel level, Marker marker, Throwable throwable, E message, Object ... args) {
        switch (level) {
            case Trace: {
                this.trace(marker, throwable, message, args);
                break;
            }
            case Debug: {
                this.debug(marker, throwable, message, args);
                break;
            }
            case Info: {
                this.info(marker, throwable, message, args);
                break;
            }
            case Warn: {
                this.warn(marker, throwable, message, args);
                break;
            }
            case Error: {
                this.error(marker, throwable, message, args);
                break;
            }
            default: {
                throw new IllegalArgumentException(level.toString());
            }
        }
    }

    public void log(CLogLevel level, Marker marker, Throwable throwable, E message, Object arg1) {
        switch (level) {
            case Trace: {
                this.trace(marker, throwable, message, arg1);
                break;
            }
            case Debug: {
                this.debug(marker, throwable, message, arg1);
                break;
            }
            case Info: {
                this.info(marker, throwable, message, arg1);
                break;
            }
            case Warn: {
                this.warn(marker, throwable, message, arg1);
                break;
            }
            case Error: {
                this.error(marker, throwable, message, arg1);
                break;
            }
            default: {
                throw new IllegalArgumentException(level.toString());
            }
        }
    }

    public void log(CLogLevel level, Marker marker, Throwable throwable, E message, Object arg1, Object arg2) {
        switch (level) {
            case Trace: {
                this.trace(marker, throwable, message, arg1, arg2);
                break;
            }
            case Debug: {
                this.debug(marker, throwable, message, arg1, arg2);
                break;
            }
            case Info: {
                this.info(marker, throwable, message, arg1, arg2);
                break;
            }
            case Warn: {
                this.warn(marker, throwable, message, arg1, arg2);
                break;
            }
            case Error: {
                this.error(marker, throwable, message, arg1, arg2);
                break;
            }
            default: {
                throw new IllegalArgumentException(level.toString());
            }
        }
    }

    public void log(CLogLevel level, Marker marker, Throwable throwable, E message, Object arg1, Object arg2, Object arg3) {
        switch (level) {
            case Trace: {
                this.trace(marker, throwable, message, arg1, arg2, arg3);
                break;
            }
            case Debug: {
                this.debug(marker, throwable, message, arg1, arg2, arg3);
                break;
            }
            case Info: {
                this.info(marker, throwable, message, arg1, arg2, arg3);
                break;
            }
            case Warn: {
                this.warn(marker, throwable, message, arg1, arg2, arg3);
                break;
            }
            case Error: {
                this.error(marker, throwable, message, arg1, arg2, arg3);
                break;
            }
            default: {
                throw new IllegalArgumentException(level.toString());
            }
        }
    }
}

