/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.log.util;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyorException;
import ch.qos.cal10n.MessageParameterObj;
import ch.qos.cal10n.util.AnnotationExtractor;
import ch.qos.cal10n.util.CAL10NResourceBundle;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cthul.log.util.CLocResourceBundleFinder;
import org.cthul.strings.Strings;
import org.cthul.strings.format.FormatterConfiguration;

public class CLocMessageConveyor
implements IMessageConveyor {
    protected final LocaleProvider localeProvider;
    protected Locale lastLocale = null;
    protected final FormatterConfiguration conf;
    protected final Map<String, CAL10NResourceBundle> cache = new ConcurrentHashMap<String, CAL10NResourceBundle>();

    public CLocMessageConveyor(Locale locale) {
        this(new SimpleLocaleProvider(locale));
    }

    public CLocMessageConveyor(LocaleProvider localeProvider) {
        this(localeProvider, null);
    }

    public CLocMessageConveyor(FormatterConfiguration conf) {
        this(new ConfigurationLocale(conf), conf);
    }

    public CLocMessageConveyor(LocaleProvider localeProvider, FormatterConfiguration conf) {
        this.localeProvider = localeProvider;
        this.conf = conf;
    }

    public <E extends Enum<?>> String getMessage(E key, Object ... args) throws MessageConveyorException {
        String keyAsStr;
        String value;
        String declararingClassName = key.getDeclaringClass().getName();
        CAL10NResourceBundle rb = this.cache.get(declararingClassName);
        if (rb == null || rb.hasChanged()) {
            rb = this.lookup(key);
            this.cache.put(declararingClassName, rb);
        }
        if ((value = rb.getString(keyAsStr = key.toString())) == null) {
            return "?" + keyAsStr + "?";
        }
        if (args == null || args.length == 0) {
            return value;
        }
        return this.format(value, args);
    }

    protected String format(String message, Object[] args) {
        if (this.conf != null) {
            return Strings.format((FormatterConfiguration)this.conf, (Object)message, (Object[])args);
        }
        return MessageFormat.format(message, args);
    }

    protected <E extends Enum<?>> CAL10NResourceBundle lookup(E key) throws MessageConveyorException {
        String baseName;
        Class<?> declaringClass = key.getDeclaringClass();
        Locale locale = this.localeProvider.getLocale();
        if (locale != this.lastLocale) {
            this.lastLocale = locale;
            this.cache.clear();
        }
        if ((baseName = AnnotationExtractor.getBaseName(key.getDeclaringClass())) == null) {
            baseName = key.getClass().getName();
        }
        if (baseName == null) {
            throw new MessageConveyorException("Missing @BaseName annotation in enum type [" + key.getClass().getName() + "]. See also " + "http://cal10n.qos.ch/codes.html#missingBaseNameAnnotation");
        }
        String charset = AnnotationExtractor.getCharset(declaringClass, (Locale)locale);
        CAL10NResourceBundle rb = CLocResourceBundleFinder.getBundle(declaringClass.getClassLoader(), baseName, locale, charset);
        if (rb == null) {
            throw new MessageConveyorException("Failed to locate resource bundle [" + baseName + "] for locale [" + locale + "] for enum type [" + key.getDeclaringClass().getName() + "]");
        }
        return rb;
    }

    public String getMessage(MessageParameterObj mpo) throws MessageConveyorException {
        if (mpo == null) {
            throw new IllegalArgumentException("MessageParameterObj argumument cannot be null");
        }
        return this.getMessage(mpo.getKey(), mpo.getArgs());
    }

    public static class ConfigurationLocale
    extends LocaleProvider {
        private final FormatterConfiguration conf;

        public ConfigurationLocale(FormatterConfiguration conf) {
            this.conf = conf;
        }

        @Override
        public Locale getLocale() {
            return this.conf.locale();
        }
    }

    public static class SimpleLocaleProvider
    extends LocaleProvider {
        private final Locale locale;

        public SimpleLocaleProvider(Locale locale) {
            this.locale = locale;
        }

        @Override
        public Locale getLocale() {
            return this.locale;
        }
    }

    public static abstract class LocaleProvider {
        public abstract Locale getLocale();
    }
}

