/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.chain;

import java.util.Collection;
import org.cthul.matchers.chain.ChainBuilder;
import org.cthul.matchers.chain.ChainFactory;
import org.cthul.matchers.chain.MatcherChainBase;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;

public class AndChainMatcher<T>
extends MatcherChainBase<T> {
    public static final ChainFactory FACTORY = new ChainFactory(){

        @Override
        public <T> Matcher<T> create(Collection<? extends Matcher<? super T>> chain) {
            return new AndChainMatcher(chain);
        }
    };

    public AndChainMatcher(Collection<? extends Matcher<? super T>> matchers) {
        super(matchers);
    }

    public AndChainMatcher(Matcher<? super T> ... matchers) {
        super(matchers);
    }

    public void describeTo(Description description) {
        boolean first = true;
        for (Matcher m : this.matchers) {
            if (first) {
                first = false;
            } else {
                description.appendText(" and ");
            }
            this.nestedDescribe(description, (SelfDescribing)m);
        }
    }

    @Override
    public boolean matches(Object item) {
        for (Matcher m : this.matchers) {
            if (m.matches(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(Object item, Description mismatch) {
        for (Matcher m : this.matchers) {
            if (AndChainMatcher.quickMatch(m, item, mismatch)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void describeMismatch(Object item, Description description) {
        this.matches(item, description);
    }

    @Override
    public int getPrecedence() {
        return 16384;
    }

    @Factory
    public static <T> Matcher<T> and(Matcher<? super T> ... matchers) {
        return new AndChainMatcher<T>(matchers);
    }

    @Factory
    public static <T> Matcher<T> and(Collection<? extends Matcher<? super T>> matchers) {
        return new AndChainMatcher<T>(matchers);
    }

    @Factory
    public static <T> Builder<T> both(Matcher<? super T> m) {
        return new Builder<T>().and(m);
    }

    @Factory
    public static <T> Builder<T> both(Matcher<? super T> ... m) {
        return new Builder<T>().and(m);
    }

    @Factory
    public static <T> Builder<T> all(Matcher<? super T> m) {
        return new Builder<T>().and(m);
    }

    @Factory
    public static <T> Builder<T> all(Matcher<? super T> ... m) {
        return new Builder<T>().and(m);
    }

    public static class Builder<T>
    extends ChainBuilder<T> {
        public Builder() {
            super(FACTORY);
        }

        public Builder(ChainFactory factory) {
            super(factory);
        }

        public Builder<T> and(Matcher<? super T> m) {
            return (Builder)this.add(m);
        }

        public Builder<T> and(Matcher<? super T> ... m) {
            return (Builder)this.add(m);
        }

        public Builder<T> and(Collection<? extends Matcher<? super T>> m) {
            return (Builder)this.add(m);
        }
    }
}

