/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.chain;

import java.util.Collection;
import org.cthul.matchers.chain.ChainBuilder;
import org.cthul.matchers.chain.ChainFactory;
import org.cthul.matchers.chain.MatcherChainBase;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;

public class NOrChainMatcher<T>
extends MatcherChainBase<T> {
    public static final ChainFactory FACTORY = new ChainFactory(){

        @Override
        public <T> Matcher<T> create(Collection<? extends Matcher<? super T>> chain) {
            return new NOrChainMatcher(chain);
        }
    };

    public NOrChainMatcher(Collection<? extends Matcher<? super T>> matchers) {
        super(matchers);
    }

    public NOrChainMatcher(Matcher<? super T> ... matchers) {
        super(matchers);
    }

    public void describeTo(Description description) {
        boolean first = true;
        for (Matcher m : this.matchers) {
            if (first) {
                first = false;
                if (this.matchers.length == 1) {
                    description.appendText("not ");
                } else {
                    description.appendText("neither ");
                }
            } else {
                description.appendText(" nor ");
            }
            this.nestedDescribe(description, (SelfDescribing)m);
        }
    }

    @Override
    public boolean matches(Object item) {
        for (Matcher m : this.matchers) {
            if (!m.matches(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(Object item, Description mismatch) {
        for (Matcher m : this.matchers) {
            if (!m.matches(item)) continue;
            m.describeTo(mismatch);
            return false;
        }
        return true;
    }

    @Override
    public void describeMismatch(Object item, Description description) {
        this.matches(item, description);
    }

    @Override
    public int getPrecedence() {
        return 8192;
    }

    @Factory
    public static <T> Matcher<T> nor(Matcher<? super T> ... matchers) {
        return new NOrChainMatcher<T>(matchers);
    }

    @Factory
    public static <T> Matcher<T> nor(Collection<? extends Matcher<? super T>> matchers) {
        return new NOrChainMatcher<T>(matchers);
    }

    @Factory
    public static <T> Builder<T> neither(Matcher<? super T> m) {
        return new Builder<T>().nor(m);
    }

    @Factory
    public static <T> Builder<T> neither(Matcher<? super T> ... m) {
        return new Builder<T>().nor(m);
    }

    public static class Builder<T>
    extends ChainBuilder<T> {
        public Builder() {
            super(FACTORY);
        }

        public Builder(ChainFactory factory) {
            super(factory);
        }

        public Builder<T> nor(Matcher<? super T> m) {
            return (Builder)this.add(m);
        }

        public Builder<T> nor(Matcher<? super T> ... m) {
            return (Builder)this.add(m);
        }

        public Builder<T> nor(Collection<? extends Matcher<? super T>> m) {
            return (Builder)this.add(m);
        }
    }
}

