/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.exceptions;

import org.cthul.matchers.diagnose.TypesafeQuickDiagnoseMatcherBase;
import org.cthul.matchers.exceptions.IsThrowable;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public class CausedBy
extends TypesafeQuickDiagnoseMatcherBase<Throwable> {
    private final boolean direct;
    private final Matcher<? super Throwable> throwableMatcher;

    public CausedBy(boolean direct, Matcher<? super Throwable> m) {
        super(Throwable.class);
        this.direct = direct;
        this.throwableMatcher = m;
    }

    @Override
    protected boolean matchesSafely(Throwable ex) {
        Throwable cause;
        if (this.direct) {
            return this.throwableMatcher.matches((Object)cause);
        }
        for (cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            if (!this.throwableMatcher.matches((Object)cause)) continue;
            return true;
        }
        return false;
    }

    public void describeTo(Description description) {
        if (this.direct) {
            description.appendText("directly ");
        }
        description.appendText("caused by ");
        this.throwableMatcher.describeTo(description);
    }

    @Override
    protected void describeMismatchSafely(Throwable ex, Description mismatch) {
        Throwable cause = ex.getCause();
        if (cause == null) {
            mismatch.appendText("no cause");
            return;
        }
        if (this.direct || cause.getCause() == null) {
            mismatch.appendText("cause ");
            this.throwableMatcher.describeMismatch((Object)cause, mismatch);
            return;
        }
        int i = 1;
        while (cause != null) {
            mismatch.appendText("cause ").appendText(String.valueOf(i)).appendText(" ");
            this.throwableMatcher.describeMismatch((Object)cause, mismatch);
            if ((cause = cause.getCause()) == null) continue;
            ++i;
            mismatch.appendText(", ");
        }
    }

    @Override
    protected boolean matchesSafely(Throwable ex, Description mismatch) {
        Throwable cause = ex.getCause();
        if (cause == null) {
            mismatch.appendText("no cause");
            return false;
        }
        if (this.direct || cause.getCause() == null) {
            return CausedBy.quickMatch(this.throwableMatcher, cause, mismatch, "cause $1");
        }
        while (cause != null) {
            if (this.throwableMatcher.matches((Object)cause)) {
                return true;
            }
            cause = cause.getCause();
        }
        cause = ex.getCause();
        int i = 1;
        while (cause != null) {
            mismatch.appendText("cause ").appendText(String.valueOf(i)).appendText(" ");
            this.throwableMatcher.describeMismatch((Object)cause, mismatch);
            if ((cause = cause.getCause()) == null) continue;
            ++i;
            mismatch.appendText(", ");
        }
        return false;
    }

    @Factory
    public static CausedBy causedBy(Matcher<? super Throwable> matcher) {
        return new CausedBy(false, matcher);
    }

    @Factory
    public static CausedBy causedBy(Class<? extends Throwable> clazz) {
        return CausedBy.causedBy(IsThrowable.throwable(clazz));
    }

    @Factory
    public static CausedBy causedBy(String message) {
        return CausedBy.causedBy(IsThrowable.throwable(message));
    }

    @Factory
    public static CausedBy causedBy(Class<? extends Throwable> clazz, String message) {
        return CausedBy.causedBy(IsThrowable.throwable(clazz, message));
    }

    @Factory
    public static CausedBy causedBy(Class<? extends Throwable> clazz, Matcher<? super Throwable> matcher) {
        return CausedBy.causedBy(IsThrowable.throwable(clazz, matcher));
    }

    @Factory
    public static CausedBy causedBy(Class<? extends Throwable> clazz, String message, Matcher<? super Throwable> matcher) {
        return CausedBy.causedBy(IsThrowable.throwable(clazz, message, matcher));
    }

    @Factory
    public static CausedBy directlyCausedBy(Matcher<? super Throwable> matcher) {
        return new CausedBy(true, matcher);
    }

    @Factory
    public static CausedBy directlyCausedBy(Class<? extends Throwable> clazz) {
        return CausedBy.directlyCausedBy(IsThrowable.throwable(clazz));
    }

    @Factory
    public static CausedBy directlyCausedBy(Class<? extends Throwable> clazz, String message) {
        return CausedBy.directlyCausedBy(IsThrowable.throwable(clazz, message));
    }

    @Factory
    public static CausedBy directlyCausedBy(Class<? extends Throwable> clazz, Matcher<? super Throwable> matcher) {
        return CausedBy.directlyCausedBy(IsThrowable.throwable(clazz, matcher));
    }

    @Factory
    public static CausedBy directlyCausedBy(Class<? extends Throwable> clazz, String message, Matcher<? super Throwable> matcher) {
        return CausedBy.directlyCausedBy(IsThrowable.throwable(clazz, message, matcher));
    }
}

