/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.proc;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.cthul.proc.PN;

public class ReflectiveProc
extends PN {
    public static final Class[] ANY_PARAMETERS = null;
    private static final Class[][] PARAM_COUNT = new Class[][]{new Class[0], new Class[1], new Class[2], new Class[3], new Class[4], new Class[5], new Class[6], new Class[7], new Class[8], new Class[9]};
    public static final Class[] NO_PARAMETERS = PARAM_COUNT[0];
    private final Object instance;
    private final Method method;
    private final Constructor constructor;
    private final int paramCount;
    private final Class varArgType;

    public static Class[] anyParameters(int count) {
        if (count < 0) {
            return ANY_PARAMETERS;
        }
        if (count == 0) {
            return NO_PARAMETERS;
        }
        return new Class[count];
    }

    static Class[] unsafeAnyParameters(int count) {
        if (count < 0) {
            return ANY_PARAMETERS;
        }
        if (count < PARAM_COUNT.length) {
            return PARAM_COUNT[count];
        }
        return new Class[count];
    }

    public static ReflectiveProc newInstance(Class<?> clazz, Class ... paramTypes) {
        Constructor<?> c = ReflectiveProc.selectConstructor(clazz, paramTypes);
        return new ReflectiveProc(c);
    }

    public static PN newInstanceWith(Class<?> clazz, Object ... args) {
        Class[] paramTypes = ReflectiveProc.argsToTypes(args);
        return (PN)ReflectiveProc.newInstance(clazz, paramTypes).call(args);
    }

    public static ReflectiveProc invoke(Class clazz, String name, Class ... paramTypes) {
        Method m = ReflectiveProc.selectMethod(clazz, name, paramTypes);
        return new ReflectiveProc(null, m);
    }

    public static ReflectiveProc invoke(Object object, String name, Class ... paramTypes) {
        Method m = ReflectiveProc.selectMethod(object.getClass(), name, paramTypes);
        return new ReflectiveProc(object, m);
    }

    public static PN invokeWith(Class clazz, String name, Object ... args) {
        Class[] paramTypes = ReflectiveProc.argsToTypes(args);
        return (PN)ReflectiveProc.invoke(clazz, name, paramTypes).call(args);
    }

    public static PN invokeWith(Object object, String name, Object ... args) {
        Class[] paramTypes = ReflectiveProc.argsToTypes(args);
        return (PN)ReflectiveProc.invoke(object, name, paramTypes).call(args);
    }

    private static Class[] argsToTypes(Object[] args) {
        if (args == null) {
            return null;
        }
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            types[i] = args[i] == null ? null : args[i].getClass();
        }
        return types;
    }

    private static Method selectMethod(Class clazz, String name, Class[] paramTypes) {
        Method m = ReflectiveProc.findMethod(clazz, name, paramTypes);
        if (m == null) {
            throw ReflectiveProc.notFound(clazz, name, paramTypes);
        }
        return m;
    }

    private static Constructor<?> selectConstructor(Class<?> clazz, Class[] paramTypes) {
        Constructor<?> m = ReflectiveProc.findConstructor(clazz, paramTypes);
        if (m == null) {
            throw ReflectiveProc.notFound(clazz, null, paramTypes);
        }
        return m;
    }

    private static IllegalArgumentException notFound(Class clazz, String name, Class[] paramTypes) {
        return new IllegalArgumentException("No match found for " + ReflectiveProc.describeMethod(clazz.getName(), name, paramTypes));
    }

    private static Method findMethod(Class clazz, String name, Class[] paramTypes) {
        return ReflectiveProc.findMethod(clazz, name, paramTypes, null);
    }

    private static Method findMethod(Class clazz, String name, Class[] paramTypes, Method assignableResult) {
        if (clazz == null) {
            return assignableResult;
        }
        Method exactResult = null;
        Method assignableAmbigous = null;
        block5: for (Method c : clazz.getDeclaredMethods()) {
            if (!c.getName().equals(name)) continue;
            switch (ReflectiveProc.paramsMatch(c, paramTypes)) {
                case EXACT: {
                    if (exactResult == null) {
                        exactResult = c;
                        continue block5;
                    }
                    if (paramTypes != null) continue block5;
                    throw ReflectiveProc.ambigous(clazz, "new", exactResult, c, paramTypes);
                }
                case ASSIGNABLE: {
                    if (assignableResult == null) {
                        assignableResult = c;
                        continue block5;
                    }
                    if (assignableAmbigous != null) continue block5;
                    assignableAmbigous = c;
                    continue block5;
                }
                case NONE: {
                    continue block5;
                }
                default: {
                    throw new AssertionError((Object)ReflectiveProc.paramsMatch(c, paramTypes));
                }
            }
        }
        if (exactResult != null) {
            return exactResult;
        }
        if (assignableAmbigous != null) {
            throw ReflectiveProc.ambigous(clazz, name, assignableResult, assignableAmbigous, paramTypes);
        }
        return ReflectiveProc.findMethod(clazz.getSuperclass(), name, paramTypes, assignableResult);
    }

    private static Constructor<?> findConstructor(Class<?> clazz, Class<?>[] paramTypes) {
        if (clazz == null) {
            return null;
        }
        Constructor<?> exactResult = null;
        Constructor<?> assignableResult = null;
        Constructor<?> assignableAmbigous = null;
        block5: for (Constructor<?> c : clazz.getConstructors()) {
            switch (ReflectiveProc.paramsMatch(c, (Class[])paramTypes)) {
                case EXACT: {
                    if (exactResult == null) {
                        exactResult = c;
                        continue block5;
                    }
                    if (paramTypes != null) continue block5;
                    throw ReflectiveProc.ambigous(clazz, null, exactResult, c, paramTypes);
                }
                case ASSIGNABLE: {
                    if (assignableResult == null) {
                        assignableResult = c;
                        continue block5;
                    }
                    if (assignableAmbigous != null) continue block5;
                    assignableAmbigous = c;
                    continue block5;
                }
                case NONE: {
                    continue block5;
                }
                default: {
                    throw new AssertionError((Object)ReflectiveProc.paramsMatch(c, (Class[])paramTypes));
                }
            }
        }
        if (exactResult != null) {
            return exactResult;
        }
        if (assignableAmbigous != null) {
            throw ReflectiveProc.ambigous(clazz, "new", assignableResult, assignableAmbigous, paramTypes);
        }
        return assignableResult;
    }

    private static Match paramsMatch(Method method, Class[] givenParamTypes) {
        if (givenParamTypes == null) {
            return Match.ASSIGNABLE;
        }
        return ReflectiveProc.paramsMatch(method.getParameterTypes(), givenParamTypes);
    }

    private static <T> Match paramsMatch(Constructor<T> constructor, Class[] givenParamTypes) {
        if (givenParamTypes == null) {
            return Match.ASSIGNABLE;
        }
        return ReflectiveProc.paramsMatch(constructor.getParameterTypes(), givenParamTypes);
    }

    private static Match paramsMatch(Class<?>[] methodParamTypes, Class<?>[] givenParamTypes) {
        if (methodParamTypes.length != givenParamTypes.length) {
            return Match.NONE;
        }
        boolean exactMatch = true;
        for (int i = 0; i < methodParamTypes.length; ++i) {
            Class<?> given = givenParamTypes[i];
            if (given == null) {
                exactMatch = false;
                continue;
            }
            Class<?> expected = methodParamTypes[i];
            if (given.equals(expected)) continue;
            if (ReflectiveProc.isAssignable(expected, given)) {
                exactMatch = false;
                continue;
            }
            return Match.NONE;
        }
        return exactMatch ? Match.EXACT : Match.ASSIGNABLE;
    }

    private static boolean isAssignable(Class<?> expected, Class<?> given) {
        if (expected.isAssignableFrom(given)) {
            return true;
        }
        if (!expected.isPrimitive()) {
            return false;
        }
        if (expected == Byte.TYPE) {
            return given == Byte.class;
        }
        if (expected == Character.TYPE) {
            return given == Character.class;
        }
        if (expected == Short.TYPE) {
            return given == Short.class;
        }
        if (expected == Integer.TYPE) {
            return given == Integer.class;
        }
        if (expected == Long.TYPE) {
            return given == Long.class;
        }
        if (expected == Float.TYPE) {
            return given == Float.class;
        }
        if (expected == Double.TYPE) {
            return given == Double.class;
        }
        return false;
    }

    private static IllegalArgumentException ambigous(Class clazz, String name, Object m1, Object m2, Class[] paramTypes) {
        String method = ReflectiveProc.describeMethod(clazz.getName(), name, paramTypes);
        return new IllegalArgumentException(String.format("Ambigous results for %s, found %s and %s.", method, m1, m2));
    }

    private static String describeMethod(String invokee, String method, Class[] paramTypes) {
        String paramString;
        if (paramTypes == null) {
            paramString = "<any args>";
        } else if (paramTypes.length == 0) {
            paramString = "";
        } else {
            StringBuilder sb = new StringBuilder();
            for (Class c : paramTypes) {
                sb.append(',');
                sb.append(c == null ? "<any>" : c.getName());
            }
            paramString = sb.substring(1);
        }
        String mName = String.format(method == null ? "new %s" : "%s#%s", invokee, method);
        return mName + "(" + paramString + ")";
    }

    public ReflectiveProc(Object instance, Method method) {
        super(ReflectiveProc.expectedArgCount(method, instance));
        this.name(ReflectiveProc.describeMethod(instance == null ? method.getDeclaringClass().getName() : instance.toString(), method.getName(), method.getParameterTypes()));
        if (instance == null && ReflectiveProc.isStatic(method)) {
            instance = method;
        }
        this.instance = instance;
        this.method = method;
        this.paramCount = method.getParameterTypes().length;
        this.varArgType = !method.isVarArgs() ? null : method.getParameterTypes()[this.paramCount - 1];
        this.constructor = null;
    }

    private static int expectedArgCount(Method method, Object instance) {
        if (method.isVarArgs()) {
            return -1;
        }
        return method.getParameterTypes().length + (instance != null || ReflectiveProc.isStatic(method) ? 0 : 1);
    }

    private static boolean isStatic(Method method) {
        return (method.getModifiers() & 8) != 0;
    }

    public ReflectiveProc(Constructor constructor) {
        super(ReflectiveProc.expectedArgCount(constructor));
        this.name(ReflectiveProc.describeMethod(constructor.getDeclaringClass().getName(), null, constructor.getParameterTypes()));
        this.instance = null;
        this.method = null;
        this.constructor = constructor;
        this.paramCount = constructor.getParameterTypes().length;
        this.varArgType = !constructor.isVarArgs() ? null : constructor.getParameterTypes()[this.paramCount - 1];
    }

    private static int expectedArgCount(Constructor constructor) {
        if (constructor.isVarArgs()) {
            return -1;
        }
        return constructor.getParameterTypes().length;
    }

    @Override
    protected Object runN(Object[] args) throws Throwable {
        if (this.constructor == null) {
            return this.invoke(args);
        }
        return this.newInstance(args);
    }

    private Object[] detectVarArgs(Object[] args) {
        int len = args.length;
        if (len == this.paramCount - 1) {
            args = Arrays.copyOf(args, this.paramCount);
            args[this.paramCount - 1] = Array.newInstance(this.varArgType.getComponentType(), 0);
        } else if (len > this.paramCount || len == this.paramCount && !this.varArgType.isInstance(args[this.paramCount - 1])) {
            Object varArgs = this.copyVarArgs(args, len);
            args = Arrays.copyOf(args, this.paramCount);
            args[this.paramCount - 1] = varArgs;
        }
        return args;
    }

    private Object copyVarArgs(Object[] args, int len) {
        Class<?> c = this.varArgType.getComponentType();
        if (c.isPrimitive()) {
            return this.copyPrimitiveVarArgs(args, c);
        }
        return this.copyObjectVarArgs(args, len);
    }

    protected Object copyPrimitiveVarArgs(Object[] args, Class<?> c) throws AssertionError {
        int vargC = args.length - this.paramCount + 1;
        if (c == Byte.TYPE) {
            byte[] vargs = new byte[vargC];
            for (int i = 0; i < vargC; ++i) {
                vargs[i] = (Byte)args[this.paramCount + i - 1];
            }
            return vargs;
        }
        if (c == Character.TYPE) {
            char[] vargs = new char[vargC];
            for (int i = 0; i < vargC; ++i) {
                vargs[i] = ((Character)args[this.paramCount + i - 1]).charValue();
            }
            return vargs;
        }
        if (c == Short.TYPE) {
            short[] vargs = new short[vargC];
            for (int i = 0; i < vargC; ++i) {
                vargs[i] = (Short)args[this.paramCount + i - 1];
            }
            return vargs;
        }
        if (c == Integer.TYPE) {
            int[] vargs = new int[vargC];
            for (int i = 0; i < vargC; ++i) {
                vargs[i] = (Integer)args[this.paramCount + i - 1];
            }
            return vargs;
        }
        if (c == Long.TYPE) {
            long[] vargs = new long[vargC];
            for (int i = 0; i < vargC; ++i) {
                vargs[i] = (Long)args[this.paramCount + i - 1];
            }
            return vargs;
        }
        if (c == Float.TYPE) {
            float[] vargs = new float[vargC];
            for (int i = 0; i < vargC; ++i) {
                vargs[i] = ((Float)args[this.paramCount + i - 1]).floatValue();
            }
            return vargs;
        }
        if (c == Double.TYPE) {
            double[] vargs = new double[vargC];
            for (int i = 0; i < vargC; ++i) {
                vargs[i] = (Double)args[this.paramCount + i - 1];
            }
            return vargs;
        }
        throw new AssertionError(c);
    }

    protected final Object copyObjectVarArgs(Object[] args, int len) {
        return Arrays.copyOfRange(args, this.paramCount - 1, len, this.varArgType);
    }

    private Object invoke(Object[] args) throws Throwable {
        Object result;
        boolean wasAccessible = this.method.isAccessible();
        if (!wasAccessible) {
            this.method.setAccessible(true);
        }
        try {
            Object obj;
            if (this.instance != null) {
                obj = this.instance;
            } else {
                obj = args[0];
                args = Arrays.copyOfRange(args, 1, args.length);
            }
            if (this.method.isVarArgs()) {
                args = this.detectVarArgs(args);
            }
            result = this.method.invoke(obj, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        finally {
            if (!wasAccessible) {
                this.method.setAccessible(false);
            }
        }
        return result;
    }

    private Object newInstance(Object[] args) throws Throwable {
        Object result;
        boolean wasAccessible = this.constructor.isAccessible();
        if (!wasAccessible) {
            this.constructor.setAccessible(true);
        }
        try {
            if (this.constructor.isVarArgs()) {
                args = this.detectVarArgs(args);
            }
            result = this.constructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        finally {
            if (!wasAccessible) {
                this.constructor.setAccessible(false);
            }
        }
        return result;
    }

    private static enum Match {
        NONE,
        ASSIGNABLE,
        EXACT;

    }
}

