/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.chain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cthul.matchers.chain.ChainBuilderBase;
import org.cthul.matchers.chain.ChainFactory;
import org.cthul.matchers.chain.ChainFactoryBase;
import org.cthul.matchers.chain.MatcherChainBase;
import org.cthul.matchers.diagnose.nested.Nested;
import org.cthul.matchers.diagnose.result.MatchResult;
import org.cthul.matchers.diagnose.result.MatchResultMismatch;
import org.cthul.matchers.diagnose.result.MatchResultSuccess;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;

public class NOrChainMatcher<T>
extends MatcherChainBase<T> {
    public static final ChainFactory FACTORY = new ChainFactoryBase(){

        @Override
        public <T> Matcher<T> create(Collection<? extends Matcher<? super T>> chain) {
            return new NOrChainMatcher(chain);
        }
    };

    public NOrChainMatcher(Collection<? extends Matcher<? super T>> matchers) {
        super(matchers);
    }

    public NOrChainMatcher(Matcher<? super T> ... matchers) {
        super(matchers);
    }

    @Override
    public int getDescriptionPrecedence() {
        return 12288;
    }

    public void describeTo(Description description) {
        switch (this.matchers.length) {
            case 0: {
                description.appendText("<anything>");
                return;
            }
            case 1: {
                description.appendText("not ");
                this.nestedDescribeTo((SelfDescribing)this.matchers[0], description);
                return;
            }
        }
        description.appendText("neither ");
        Nested.joinDescriptions(this.getDescriptionPrecedence(), this.matchersList(), description, " nor ");
    }

    @Override
    public boolean matches(Object item) {
        Matcher[] matcherArray = this.matchers;
        int n = this.matchers.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher m = matcherArray[n2];
            if (m.matches(item)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public <I> MatchResult<I> matchResult(I item) {
        ArrayList<MatchResult.Mismatch<I>> results = new ArrayList<MatchResult.Mismatch<I>>(this.matchers.length);
        Matcher[] matcherArray = this.matchers;
        int n = this.matchers.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher m = matcherArray[n2];
            MatchResult<I> mr = NOrChainMatcher.quickMatchResult(m, item);
            if (mr.matched()) {
                return this.failResult(item, mr.getMatch());
            }
            results.add(mr.getMismatch());
            ++n2;
        }
        return this.successResult(item, results);
    }

    private <I> MatchResult<I> failResult(I item, final MatchResult.Match<I> match) {
        return new MatchResultMismatch<I, Matcher<?>>(item, this){

            @Override
            public int getMismatchPrecedence() {
                return 0x100000;
            }

            @Override
            public void describeMismatch(Description description) {
                match.describeMatch(description);
            }
        };
    }

    private <I> MatchResult<I> successResult(I item, final List<MatchResult.Mismatch<I>> results) {
        return new MatchResultSuccess<I, Matcher<?>>(item, this){

            @Override
            public int getMatchPrecedence() {
                return Nested.pAtomicUnaryOr(24576, results.size());
            }

            @Override
            public void describeMatch(Description description) {
                if (results.isEmpty()) {
                    this.describeMatcher(description);
                } else {
                    Nested.joinMismatchDescriptions(this.getMatchPrecedence(), results, description, " and ");
                }
            }
        };
    }

    @Factory
    public static <T> Matcher<T> none(Matcher<? super T> ... matchers) {
        return new NOrChainMatcher<T>(matchers);
    }

    @Factory
    public static <T> Matcher<T> none(Collection<? extends Matcher<? super T>> matchers) {
        return new NOrChainMatcher<T>(matchers);
    }

    @Factory
    public static <T> Matcher<T> nor(Matcher<? super T> ... matchers) {
        return new NOrChainMatcher<T>(matchers);
    }

    @Factory
    public static <T> Matcher<T> nor(Collection<? extends Matcher<? super T>> matchers) {
        return new NOrChainMatcher<T>(matchers);
    }

    @Factory
    public static <T> Builder<T> neither(Matcher<? super T> m) {
        return new Builder().nor(m);
    }

    @Factory
    public static <T> Builder<T> neither(Matcher<? super T> ... m) {
        return new Builder().nor(m);
    }

    @Factory
    public static ChainFactory none() {
        return FACTORY;
    }

    public static class Builder<T>
    extends ChainBuilderBase<T> {
        @Override
        protected ChainFactory factory() {
            return FACTORY;
        }

        public <T2 extends T> Builder<T> nor(Matcher<? super T2> m) {
            return (Builder)this._add(m);
        }

        public <T2 extends T> Builder<T> nor(Matcher<? super T2> ... m) {
            return (Builder)this._add(m);
        }

        public <T2 extends T> Builder<T> nor(Collection<? extends Matcher<? super T2>> m) {
            return (Builder)this._add(m);
        }
    }
}

