/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.chain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cthul.matchers.chain.ChainBuilderBase;
import org.cthul.matchers.chain.ChainFactory;
import org.cthul.matchers.chain.ChainFactoryBase;
import org.cthul.matchers.chain.MatcherChainBase;
import org.cthul.matchers.chain.XOrChainMatcher;
import org.cthul.matchers.diagnose.nested.Nested;
import org.cthul.matchers.diagnose.nested.NestedResultMatcher;
import org.cthul.matchers.diagnose.result.MatchResult;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public class OrChainMatcher<T>
extends MatcherChainBase<T> {
    public static final ChainFactory FACTORY = new ChainFactoryBase(){

        @Override
        public <T> Matcher<T> create(Collection<? extends Matcher<? super T>> chain) {
            return new OrChainMatcher(chain);
        }
    };

    public OrChainMatcher(Collection<? extends Matcher<? super T>> matchers) {
        super(matchers);
    }

    public OrChainMatcher(Matcher<? super T> ... matchers) {
        super(matchers);
    }

    @Override
    public int getDescriptionPrecedence() {
        return Nested.pAtomicUnaryOr(12288, this.matchers.length);
    }

    public void describeTo(Description description) {
        if (this.matchers.length == 0) {
            description.appendText("<impossible>");
        } else {
            Nested.joinDescriptions(this.getDescriptionPrecedence(), this.matchersList(), description, " or ");
        }
    }

    @Override
    public boolean matches(Object item) {
        Matcher[] matcherArray = this.matchers;
        int n = this.matchers.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher m = matcherArray[n2];
            if (m.matches(item)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public <I> MatchResult<I> matchResult(I item) {
        ArrayList<MatchResult.Mismatch<I>> mismatches = new ArrayList<MatchResult.Mismatch<I>>(this.matchers.length);
        Matcher[] matcherArray = this.matchers;
        int n = this.matchers.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher m = matcherArray[n2];
            MatchResult<I> mr = OrChainMatcher.quickMatchResult(m, item);
            if (mr.matched()) {
                return this.successResult(item, mr.getMatch());
            }
            mismatches.add(mr.getMismatch());
            ++n2;
        }
        return this.failResult(item, mismatches);
    }

    private <I> MatchResult<I> successResult(I item, final MatchResult.Match<I> nested) {
        return new NestedResultMatcher.NestedMatch<I, OrChainMatcher<T>>(item, this){

            @Override
            public int getMatchPrecedence() {
                return 0x100000;
            }

            @Override
            public void describeMatch(Description d) {
                this.nestedDescribeMatch(nested, d);
            }
        };
    }

    private <I> MatchResult<I> failResult(I item, final List<MatchResult.Mismatch<I>> nested) {
        return new NestedResultMatcher.NestedMismatch<I, OrChainMatcher<T>>(item, this){

            @Override
            public void describeExpected(Description description) {
                if (nested.isEmpty()) {
                    this.describeMatcher(description);
                } else {
                    Nested.joinExpectedDescriptions(this.getExpectedPrecedence(), nested, description, " or ");
                }
            }

            @Override
            public int getMismatchPrecedence() {
                return 24576;
            }

            @Override
            public void describeMismatch(Description description) {
                Nested.joinMismatchDescriptions(this.getMismatchPrecedence(), nested, description, " and ");
            }
        };
    }

    @Factory
    public static <T> Matcher<T> any(Matcher<? super T> ... matchers) {
        return new OrChainMatcher<T>(matchers);
    }

    @Factory
    public static <T> Matcher<T> any(Collection<? extends Matcher<? super T>> matchers) {
        return new OrChainMatcher<T>(matchers);
    }

    @Factory
    public static <T> Matcher<T> or(Matcher<? super T> ... matchers) {
        return new OrChainMatcher<T>(matchers);
    }

    @Factory
    public static <T> Matcher<T> or(Collection<? extends Matcher<? super T>> matchers) {
        return new OrChainMatcher<T>(matchers);
    }

    @Factory
    public static <T> Builder<T> either(Matcher<? super T> m) {
        return new Builder()._or(m);
    }

    @Factory
    public static <T> Builder<T> either(Matcher<? super T> ... m) {
        return new Builder()._or(m);
    }

    @Factory
    public static ChainFactory any() {
        return FACTORY;
    }

    public static class Builder<T>
    extends ChainBuilderBase<T> {
        private Boolean xorEnabled = null;

        @Override
        protected ChainFactory factory() {
            if (this.xorEnabled != null && this.xorEnabled.booleanValue()) {
                return this.xorFactory();
            }
            return this.orFactory();
        }

        protected ChainFactory orFactory() {
            return FACTORY;
        }

        protected ChainFactory xorFactory() {
            return XOrChainMatcher.FACTORY;
        }

        protected void makeOR() {
            if (this.xorEnabled == Boolean.TRUE) {
                throw new IllegalStateException("Cannot switch between XOR and OR");
            }
            this.xorEnabled = Boolean.FALSE;
        }

        protected void makeXOR() {
            if (this.xorEnabled == Boolean.FALSE) {
                throw new IllegalStateException("Cannot switch between OR and XOR");
            }
            this.xorEnabled = Boolean.TRUE;
        }

        protected <T2 extends T> Builder<T> _or(Matcher<? super T2> m) {
            return (Builder)this._add(m);
        }

        protected <T2 extends T> Builder<T> _or(Matcher<? super T2> ... m) {
            return (Builder)this._add(m);
        }

        protected <T2 extends T> Builder<T> _or(Collection<? extends Matcher<? super T2>> m) {
            return (Builder)this._add(m);
        }

        public <T2 extends T> Builder<T> or(Matcher<? super T2> m) {
            this.makeOR();
            return this._or(m);
        }

        public <T2 extends T> Builder<T> or(Matcher<? super T> ... m) {
            this.makeOR();
            return this._or(m);
        }

        public <T2 extends T> Builder<T> or(Collection<? extends Matcher<? super T2>> m) {
            this.makeOR();
            return this._or(m);
        }

        public <T2 extends T> Builder<T> xor(Matcher<? super T2> m) {
            this.makeXOR();
            return this._or(m);
        }

        public <T2 extends T> Builder<T> xor(Matcher<? super T2> ... m) {
            this.makeXOR();
            return this._or(m);
        }

        public <T2 extends T> Builder<T> xor(Collection<? extends Matcher<? super T2>> m) {
            this.makeXOR();
            return this._or(m);
        }
    }
}

