/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.chain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cthul.matchers.chain.ChainBuilderBase;
import org.cthul.matchers.chain.ChainFactory;
import org.cthul.matchers.chain.ChainFactoryBase;
import org.cthul.matchers.chain.MatcherChainBase;
import org.cthul.matchers.diagnose.nested.Nested;
import org.cthul.matchers.diagnose.nested.NestedResultMatcher;
import org.cthul.matchers.diagnose.result.MatchResult;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.core.Is;

public class SomeOfChainMatcher<T>
extends MatcherChainBase<T> {
    private final Matcher<? super Integer> countMatcher;

    public SomeOfChainMatcher(Matcher<? super Integer> countMatcher, Matcher<? super T> ... matchers) {
        super(matchers);
        this.countMatcher = countMatcher;
    }

    public SomeOfChainMatcher(Matcher<? super Integer> countMatcher, Collection<? extends Matcher<? super T>> matchers) {
        super(matchers);
        this.countMatcher = countMatcher;
    }

    @Override
    public int getDescriptionPrecedence() {
        return 36864;
    }

    public void describeTo(Description description) {
        this.nestedDescribeTo((SelfDescribing)this.countMatcher, description);
        description.appendText(" of: ");
        this.describeMatchers(description);
    }

    private void describeMatchers(Description description) {
        Nested.joinDescriptions(this.getDescriptionPrecedence(), this.matchersList(), description, ", ", ", and ", " and ");
    }

    @Override
    public boolean matches(Object item) {
        int count = 0;
        Matcher[] matcherArray = this.matchers;
        int n = this.matchers.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher m = matcherArray[n2];
            if (m.matches(item)) {
                ++count;
            }
            ++n2;
        }
        return this.countMatcher.matches((Object)count);
    }

    @Override
    public <I> MatchResult<I> matchResult(I item) {
        ArrayList<MatchResult<I>> results = new ArrayList<MatchResult<I>>(this.matchers.length);
        int count = 0;
        Matcher[] matcherArray = this.matchers;
        int n = this.matchers.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher m = matcherArray[n2];
            if (m.matches(item)) {
                ++count;
            }
            ++n2;
        }
        MatchResult<Integer> countResult = SomeOfChainMatcher.quickMatchResult(this.countMatcher, count);
        return this.result(item, countResult, results);
    }

    private <I> MatchResult<I> result(I item, final MatchResult<Integer> countResult, final List<MatchResult<I>> results) {
        return new NestedResultMatcher.NestedResult<I, SomeOfChainMatcher<T>>(item, this, countResult.matched()){

            @Override
            public void describeTo(Description description) {
                description.appendText("matched ");
                this.nestedDescribeTo(this.getDescriptionPrecedence(), countResult, description);
                description.appendText(": ");
                Nested.listDescriptions(this.getDescriptionPrecedence(), results, description);
            }

            @Override
            public void describeMatch(Description description) {
                this.describeTo(description);
            }

            @Override
            public void describeExpected(Description description) {
                this.nestedDescribeTo(this.getExpectedPrecedence(), countResult.getMismatch().getExpectedDescription(), description);
                description.appendText(" of: ");
                SomeOfChainMatcher.this.describeMatchers(description);
            }

            @Override
            public void describeMismatch(Description description) {
                this.describeTo(description);
            }
        };
    }

    @Factory
    public static SomeOfChainFactory matches(int count) {
        return SomeOfChainMatcher.factory(count);
    }

    @Factory
    public static SomeOfChainFactory matches(Matcher<? super Integer> countMatcher) {
        return SomeOfChainMatcher.factory(countMatcher);
    }

    @Factory
    public static <T> Builder<T> matches(int count, Matcher<? super T> ... matchers) {
        return SomeOfChainMatcher.factory(count).of((Matcher[])matchers);
    }

    @Factory
    public static <T> Builder<T> matches(Matcher<? super Integer> countMatcher, Matcher<? super T> ... matchers) {
        return SomeOfChainMatcher.factory(countMatcher).of((Matcher[])matchers);
    }

    @Factory
    public <T> Builder<T> oneOf(Matcher<? super T> ... matchers) {
        return SomeOfChainMatcher.matches(1).of((Matcher[])matchers);
    }

    @Factory
    public <T> Builder<T> oneOf(Collection<? extends Matcher<? super T>> matcher) {
        return SomeOfChainMatcher.matches(1).of((Collection)matcher);
    }

    public static SomeOfChainFactory factory(int count) {
        return SomeOfChainMatcher.factory((Matcher<? super Integer>)Is.is((Object)count));
    }

    public static SomeOfChainFactory factory(Matcher<? super Integer> countMatcher) {
        return new SomeOfChainFactory(countMatcher);
    }

    public static class Builder<T>
    extends ChainBuilderBase<T> {
        private final ChainFactory factory;

        public Builder(ChainFactory factory) {
            this.factory = factory;
        }

        @Override
        protected ChainFactory factory() {
            return this.factory;
        }

        public <T2 extends T> Builder<T2> and(Matcher<? super T2> m) {
            return (Builder)this._add(m);
        }

        public <T2 extends T> Builder<T2> and(Matcher<? super T2> ... m) {
            return (Builder)this._add(m);
        }

        public <T2 extends T> Builder<T2> and(Collection<? extends Matcher<? super T2>> m) {
            return (Builder)this._add(m);
        }
    }

    public static class SomeOfChainFactory
    extends ChainFactoryBase {
        private final Matcher<? super Integer> countMatcher;

        public SomeOfChainFactory(Matcher<? super Integer> countMatcher) {
            this.countMatcher = countMatcher;
        }

        @Override
        public <T> Matcher<T> create(Collection<? extends Matcher<? super T>> chain) {
            return new SomeOfChainMatcher(this.countMatcher, chain);
        }

        public <T> Builder<T> of(Matcher<? super T> matcher) {
            return new Builder(this).and(matcher);
        }

        public <T> Builder<T> of(Matcher<? super T> ... matchers) {
            return new Builder(this).and(matchers);
        }

        public <T> Builder<T> of(Collection<? extends Matcher<? super T>> matcher) {
            return new Builder(this).and(matcher);
        }
    }
}

