/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.chain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cthul.matchers.chain.ChainFactory;
import org.cthul.matchers.chain.ChainFactoryBase;
import org.cthul.matchers.chain.MatcherChainBase;
import org.cthul.matchers.chain.OrChainMatcher;
import org.cthul.matchers.diagnose.nested.Nested;
import org.cthul.matchers.diagnose.nested.NestedResultMatcher;
import org.cthul.matchers.diagnose.result.MatchResult;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public class XOrChainMatcher<T>
extends MatcherChainBase<T> {
    public static final ChainFactory FACTORY = new ChainFactoryBase(){

        @Override
        public <T> Matcher<T> create(Collection<? extends Matcher<? super T>> chain) {
            return new XOrChainMatcher(chain);
        }
    };

    public XOrChainMatcher(Collection<? extends Matcher<? super T>> matchers) {
        super(matchers);
    }

    public XOrChainMatcher(Matcher<? super T> ... matchers) {
        super(matchers);
    }

    @Override
    public int getDescriptionPrecedence() {
        return 12288;
    }

    public void describeTo(Description description) {
        if (this.matchers.length == 0) {
            description.appendText("<impossible>");
        } else {
            Nested.joinDescriptions(this.getDescriptionPrecedence(), this.matchersList(), description, " xor ");
        }
    }

    @Override
    public boolean matches(Object item) {
        boolean match = false;
        Matcher[] matcherArray = this.matchers;
        int n = this.matchers.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher m = matcherArray[n2];
            match ^= m.matches(item);
            ++n2;
        }
        return match;
    }

    @Override
    public <I> MatchResult<I> matchResult(I item) {
        ArrayList<MatchResult<I>> results = new ArrayList<MatchResult<I>>(this.matchers.length);
        boolean match = false;
        Matcher[] matcherArray = this.matchers;
        int n = this.matchers.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher m = matcherArray[n2];
            MatchResult<I> mr = XOrChainMatcher.quickMatchResult(m, item);
            results.add(mr);
            match ^= mr.matched();
            ++n2;
        }
        return this.result(match, item, results);
    }

    private <I> MatchResult<I> result(boolean match, I item, final List<MatchResult<I>> results) {
        return new NestedResultMatcher.NestedResult<I, XOrChainMatcher<T>>(item, this, match){

            @Override
            public int getDescriptionPrecedence() {
                return 24576;
            }

            @Override
            public int getMatchPrecedence() {
                return 24576;
            }

            @Override
            public int getMismatchPrecedence() {
                return 24576;
            }

            @Override
            public void describeTo(Description d) {
                Nested.joinDescriptions(this.getDescriptionPrecedence(), results, d, " and ");
            }

            @Override
            public void describeMatch(Description d) {
                this.describeTo(d);
            }

            @Override
            public void describeMismatch(Description d) {
                this.describeTo(d);
            }
        };
    }

    @Factory
    public static <T> Matcher<T> xor(Matcher<? super T> ... matchers) {
        return new XOrChainMatcher<T>(matchers);
    }

    @Factory
    public static <T> Matcher<T> xor(Collection<? extends Matcher<? super T>> matchers) {
        return new XOrChainMatcher<T>(matchers);
    }

    public static <T> OrChainMatcher.Builder<T> either(Matcher<? super T> m) {
        return new Builder().xor(m);
    }

    public static <T> OrChainMatcher.Builder<T> either(Matcher<? super T> ... m) {
        return new Builder().xor(m);
    }

    public static class Builder<T>
    extends OrChainMatcher.Builder<T> {
        public Builder() {
            this.makeXOR();
        }
    }
}

