/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.diagnose.nested;

import java.util.Collection;
import java.util.Iterator;
import org.cthul.matchers.diagnose.QuickDiagnose;
import org.cthul.matchers.diagnose.nested.PrecedencedSelfDescribing;
import org.cthul.matchers.diagnose.nested.PrecedencedSelfDescribingBase;
import org.cthul.matchers.diagnose.result.AbstractMatchResult;
import org.cthul.matchers.diagnose.result.MatchResult;
import org.cthul.matchers.diagnose.result.MatchResultMismatch;
import org.cthul.matchers.diagnose.result.MatchResultSuccess;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;

public class Nested {
    public static int precedenceOf(Object o) {
        if (o instanceof PrecedencedSelfDescribing) {
            return ((PrecedencedSelfDescribing)o).getDescriptionPrecedence();
        }
        return 0x1000000;
    }

    public static int pAtomicUnaryOr(int p, int count) {
        switch (count) {
            case 0: {
                return 0x1000000;
            }
            case 1: {
                return 0x100000;
            }
        }
        return p;
    }

    public static void describeTo(PrecedencedSelfDescribing self, SelfDescribing nested, Description d) {
        boolean paren = Nested.useParen(self, (Object)nested);
        Nested.describeTo(paren, nested, d);
    }

    public static void describeTo(PrecedencedSelfDescribing self, SelfDescribing nested, Description d, String message) {
        boolean paren = Nested.useParen(self, (Object)nested);
        Nested.describeTo(paren, nested, d, message);
    }

    public static boolean matches(PrecedencedSelfDescribing self, Matcher<?> matcher, Object item, Description mismatch) {
        boolean paren = Nested.useParen(self, matcher);
        if (paren) {
            return QuickDiagnose.matches(matcher, item, mismatch, "($1)");
        }
        return QuickDiagnose.matches(matcher, item, mismatch);
    }

    public static boolean matches(PrecedencedSelfDescribing self, Matcher<?> matcher, Object item, Description mismatch, String message) {
        if (message == null) {
            return Nested.matches(self, matcher, item, mismatch);
        }
        boolean paren = Nested.useParen(self, matcher);
        if (paren) {
            message = message.replace("$1", "($1)");
        }
        return QuickDiagnose.matches(matcher, item, mismatch, message);
    }

    private static boolean useParen(PrecedencedSelfDescribing pm, Object nested) {
        return Nested.useParen(pm.getDescriptionPrecedence(), nested);
    }

    private static boolean useParen(int pSelf, Object nested) {
        if (pSelf == 0 || pSelf == 0x700000) {
            return false;
        }
        return Nested.useParentheses(pSelf, Nested.precedenceOf(nested));
    }

    public static boolean useParentheses(int pSelf, int pNested) {
        if (pSelf == 0 || pSelf == 0x700000) {
            return false;
        }
        if (pNested < 0x100000) {
            return pNested <= pSelf;
        }
        return pNested < pSelf;
    }

    public static void describeTo(boolean paren, SelfDescribing sd, Description d) {
        if (paren) {
            d.appendText("(");
        }
        d.appendDescriptionOf(sd);
        if (paren) {
            d.appendText(")");
        }
    }

    public static void describeTo(boolean paren, SelfDescribing sd, Description d, String message) {
        if (message == null) {
            Nested.describeTo(paren, sd, d);
            return;
        }
        if (message.contains("$1")) {
            StringDescription tmp = new StringDescription();
            if (paren) {
                tmp.appendText("(");
            }
            tmp.appendDescriptionOf(sd);
            if (paren) {
                tmp.appendText(")");
            }
            d.appendText(message.replace("$1", tmp.toString()));
        } else {
            if (paren) {
                d.appendText("(");
            }
            d.appendText(message);
            if (paren) {
                d.appendText(")");
            }
        }
    }

    public static void listDescriptions(int myPrecedence, Iterable<? extends SelfDescribing> nested, Description d) {
        Nested.joinDescriptions(myPrecedence, nested, d, ", ", ", and ", " and ");
    }

    public static void joinMatchDescriptions(int myPrecedence, Iterable<? extends MatchResult<?>> nested, Description d, String sep) {
        Nested.joinMatchDescriptions(myPrecedence, nested, d, sep, sep, sep);
    }

    public static void joinMatchDescriptions(int myPrecedence, Iterable<? extends MatchResult<?>> nested, Description d, String sep, String lastSep, String singleSep) {
        for (MatchResult<?> mr : Nested.collectDescriptions(nested, d, sep, lastSep, singleSep)) {
            mr.getMatch().describeMatch(d);
        }
    }

    public static void joinExpectedDescriptions(int myPrecedence, Iterable<? extends MatchResult<?>> nested, Description d, String sep) {
        Nested.joinExpectedDescriptions(myPrecedence, nested, d, sep, sep, sep);
    }

    public static void joinExpectedDescriptions(int myPrecedence, Iterable<? extends MatchResult<?>> nested, Description d, String sep, String lastSep, String singleSep) {
        for (MatchResult<?> mr : Nested.collectDescriptions(nested, d, sep, lastSep, singleSep)) {
            mr.getMismatch().describeExpected(d);
        }
    }

    public static void joinMismatchDescriptions(int myPrecedence, Iterable<? extends MatchResult<?>> nested, Description d, String sep) {
        Nested.joinMismatchDescriptions(myPrecedence, nested, d, sep, sep, sep);
    }

    public static void joinMismatchDescriptions(int myPrecedence, Iterable<? extends MatchResult<?>> nested, Description d, String sep, String lastSep, String singleSep) {
        for (MatchResult<?> mr : Nested.collectDescriptions(nested, d, sep, lastSep, singleSep)) {
            mr.getMismatch().describeMismatch(d);
        }
    }

    public static void joinDescriptions(int myPrecedence, Iterable<? extends SelfDescribing> nested, Description description, String sep) {
        Nested.joinDescriptions(myPrecedence, nested, description, sep, sep, sep);
    }

    public static void joinDescriptions(int myPrecedence, Iterable<? extends SelfDescribing> nested, Description description, String sep, String lastSep, String singleSep) {
        for (SelfDescribing selfDescribing : Nested.collectDescriptions(nested, description, sep, lastSep, singleSep)) {
            boolean paren = Nested.useParentheses(myPrecedence, Nested.precedenceOf(selfDescribing));
            Nested.describeTo(paren, selfDescribing, description);
        }
    }

    public static void joinDescriptions(Collection<? extends SelfDescribing> nested, Description description, String sep) {
        Nested.joinDescriptions(nested, description, sep, sep, sep);
    }

    public static void joinDescriptions(Collection<? extends SelfDescribing> nested, Description description, String sep, String lastSep, String singleSep) {
        Nested.joinDescriptions(0, nested, description, sep, lastSep, singleSep);
    }

    public static PrecedencedSelfDescribing joinDescriptions(int myPrecedence, Iterable<? extends SelfDescribing> nested, String sep) {
        return Nested.joinDescriptions(myPrecedence, nested, sep, sep, sep);
    }

    public static PrecedencedSelfDescribing joinDescriptions(final int myPrecedence, final Iterable<? extends SelfDescribing> nested, final String sep, final String lastSep, final String singleSep) {
        return new PrecedencedSelfDescribingBase(){

            @Override
            public int getDescriptionPrecedence() {
                return myPrecedence;
            }

            @Override
            public void describeTo(Description description) {
                Nested.joinDescriptions(myPrecedence, nested, description, sep, lastSep, singleSep);
            }
        };
    }

    public static <T> Iterable<T> collectDescriptions(Iterable<T> data, Description target, String sep, String lastSep, String singleSep) {
        return new CollectingIterable<T>(data, target, sep, lastSep, singleSep);
    }

    public static <T> Iterable<T> collectDescriptions(Iterable<T> data, Description target, String sep) {
        return new CollectingIterable<T>(data, target, sep);
    }

    private static class CollectingIterable<T>
    implements Iterable<T> {
        private final Iterable<T> data;
        private final Description target;
        private final String sep;
        private final String lastSep;
        private final String singleSep;

        public CollectingIterable(Iterable<T> data, Description target, String sep, String lastSep, String singleSep) {
            this.data = data;
            this.target = target;
            this.sep = sep;
            this.lastSep = lastSep;
            this.singleSep = singleSep;
        }

        public CollectingIterable(Iterable<T> data, Description target, String sep) {
            this.data = data;
            this.target = target;
            this.sep = sep;
            this.lastSep = sep;
            this.singleSep = sep;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(this){
                Iterator<T> it;
                int index;
                final /* synthetic */ CollectingIterable this$1;
                {
                    this.this$1 = collectingIterable;
                    this.it = CollectingIterable.access$0(collectingIterable).iterator();
                    this.index = 0;
                }

                public boolean hasNext() {
                    return this.it.hasNext();
                }

                public T next() {
                    T result = this.it.next();
                    if (this.index++ > 0) {
                        if (this.it.hasNext()) {
                            CollectingIterable.access$1(this.this$1).appendText(CollectingIterable.access$2(this.this$1));
                        } else {
                            CollectingIterable.access$1(this.this$1).appendText(this.index == 2 ? CollectingIterable.access$3(this.this$1) : CollectingIterable.access$4(this.this$1));
                        }
                    }
                    return result;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        static /* synthetic */ Iterable access$0(CollectingIterable collectingIterable) {
            return collectingIterable.data;
        }

        static /* synthetic */ Description access$1(CollectingIterable collectingIterable) {
            return collectingIterable.target;
        }

        static /* synthetic */ String access$2(CollectingIterable collectingIterable) {
            return collectingIterable.sep;
        }

        static /* synthetic */ String access$3(CollectingIterable collectingIterable) {
            return collectingIterable.singleSep;
        }

        static /* synthetic */ String access$4(CollectingIterable collectingIterable) {
            return collectingIterable.lastSep;
        }
    }

    public static class Match<T, M extends Matcher<?>>
    extends MatchResultSuccess<T, M> {
        public Match(T value, M matcher) {
            super(value, matcher);
        }

        protected void nestedDescribeTo(boolean paren, SelfDescribing sd, Description d) {
            Nested.describeTo(paren, sd, d);
        }

        protected void nestedDescribeTo(boolean paren, SelfDescribing sd, Description d, String message) {
            Nested.describeTo(paren, sd, d, message);
        }

        protected void nestedDescribeTo(int myPrecedence, PrecedencedSelfDescribing sd, Description d) {
            boolean paren = Nested.useParentheses(myPrecedence, sd.getDescriptionPrecedence());
            this.nestedDescribeTo(paren, (SelfDescribing)sd, d);
        }

        protected void nestedDescribeTo(int myPrecedence, PrecedencedSelfDescribing sd, Description d, String message) {
            boolean paren = Nested.useParentheses(myPrecedence, sd.getDescriptionPrecedence());
            this.nestedDescribeTo(paren, (SelfDescribing)sd, d, message);
        }

        protected void nestedDescribeMatcher(MatchResult<?> nested, Description d) {
            this.nestedDescribeMatcher(nested, d, null);
        }

        protected void nestedDescribeMatch(MatchResult.Match<?> nested, Description d) {
            this.nestedDescribeMatch(nested, d, null);
        }

        protected void nestedDescribeExpected(int myPrecedence, MatchResult.Mismatch<?> nested, Description d) {
            this.nestedDescribeExpected(myPrecedence, nested, d, null);
        }

        protected void nestedDescribeMismatch(int myPrecedence, MatchResult.Mismatch<?> nested, Description d) {
            this.nestedDescribeMismatch(myPrecedence, nested, d, null);
        }

        protected void nestedDescribeMatcher(MatchResult<?> nested, Description d, String message) {
            this.nestedDescribeTo(this.getMatcherPrecedence(), nested.getMatcherDescription(), d, message);
        }

        protected void nestedDescribeMatch(MatchResult.Match<?> nested, Description d, String message) {
            this.nestedDescribeTo(this.getMatchPrecedence(), nested.getMatchDescription(), d, message);
        }

        protected void nestedDescribeExpected(int myPrecedence, MatchResult.Mismatch<?> nested, Description d, String message) {
            this.nestedDescribeTo(myPrecedence, nested.getExpectedDescription(), d, message);
        }

        protected void nestedDescribeMismatch(int myPrecedence, MatchResult.Mismatch<?> nested, Description d, String message) {
            this.nestedDescribeTo(myPrecedence, nested.getMismatchDescription(), d, message);
        }
    }

    public static class Mismatch<T, M extends Matcher<?>>
    extends MatchResultMismatch<T, M> {
        public Mismatch(T value, M matcher) {
            super(value, matcher);
        }

        protected void nestedDescribeTo(boolean paren, SelfDescribing sd, Description d) {
            Nested.describeTo(paren, sd, d);
        }

        protected void nestedDescribeTo(boolean paren, SelfDescribing sd, Description d, String message) {
            Nested.describeTo(paren, sd, d, message);
        }

        protected void nestedDescribeTo(int myPrecedence, PrecedencedSelfDescribing sd, Description d) {
            boolean paren = Nested.useParentheses(myPrecedence, sd.getDescriptionPrecedence());
            this.nestedDescribeTo(paren, (SelfDescribing)sd, d);
        }

        protected void nestedDescribeTo(int myPrecedence, PrecedencedSelfDescribing sd, Description d, String message) {
            boolean paren = Nested.useParentheses(myPrecedence, sd.getDescriptionPrecedence());
            this.nestedDescribeTo(paren, (SelfDescribing)sd, d, message);
        }

        protected void nestedDescribeMatcher(MatchResult<?> nested, Description d) {
            this.nestedDescribeMatcher(nested, d, null);
        }

        protected void nestedDescribeExpected(MatchResult.Mismatch<?> nested, Description d) {
            this.nestedDescribeExpected(nested, d, null);
        }

        protected void nestedDescribeMismatch(MatchResult.Mismatch<?> nested, Description d) {
            this.nestedDescribeMismatch(nested, d, null);
        }

        protected void nestedDescribeMatch(int myPrecedence, MatchResult.Match<?> nested, Description d) {
            this.nestedDescribeMatch(myPrecedence, nested, d, null);
        }

        protected void nestedDescribeMatcher(MatchResult<?> nested, Description d, String message) {
            this.nestedDescribeTo(this.getMatcherPrecedence(), nested.getMatcherDescription(), d, message);
        }

        protected void nestedDescribeExpected(MatchResult.Mismatch<?> nested, Description d, String message) {
            this.nestedDescribeTo(this.getExpectedPrecedence(), nested.getExpectedDescription(), d, message);
        }

        protected void nestedDescribeMismatch(MatchResult.Mismatch<?> nested, Description d, String message) {
            this.nestedDescribeTo(this.getMismatchPrecedence(), nested.getMismatchDescription(), d, message);
        }

        protected void nestedDescribeMatch(int myPrecedence, MatchResult.Match<?> nested, Description d, String message) {
            this.nestedDescribeTo(myPrecedence, nested.getMatchDescription(), d, message);
        }
    }

    public static class Result<T, M extends Matcher<?>>
    extends AbstractMatchResult<T, M> {
        public Result(T value, M matcher) {
            super(value, matcher);
        }

        public Result(T value, M matcher, boolean success) {
            super(value, matcher, success);
        }

        protected void nestedDescribeTo(boolean paren, SelfDescribing sd, Description d) {
            Nested.describeTo(paren, sd, d);
        }

        protected void nestedDescribeTo(boolean paren, SelfDescribing sd, Description d, String message) {
            Nested.describeTo(paren, sd, d, message);
        }

        protected void nestedDescribeTo(int myPrecedence, PrecedencedSelfDescribing sd, Description d) {
            boolean paren = Nested.useParentheses(myPrecedence, sd.getDescriptionPrecedence());
            this.nestedDescribeTo(paren, (SelfDescribing)sd, d);
        }

        protected void nestedDescribeTo(int myPrecedence, PrecedencedSelfDescribing sd, Description d, String message) {
            boolean paren = Nested.useParentheses(myPrecedence, sd.getDescriptionPrecedence());
            this.nestedDescribeTo(paren, (SelfDescribing)sd, d, message);
        }
    }
}

