/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.hamcrest;

import org.cthul.matchers.diagnose.nested.NestedMatcher;
import org.cthul.matchers.diagnose.result.AbstractMatchResult;
import org.cthul.matchers.diagnose.result.MatchResult;
import org.cthul.matchers.diagnose.safe.TypesafeNestedResultMatcher;
import org.cthul.matchers.hamcrest.HasDescription;
import org.cthul.matchers.hamcrest.MatchResultExpected;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;

public class MatcherAccepts<T>
extends TypesafeNestedResultMatcher<Matcher<? super T>> {
    private final boolean match;
    private final T value;
    private final Matcher<? super MatchResult<T>> resultMatcher;

    @Factory
    public static <T> Matcher<Matcher<? super T>> accepts(T value) {
        return new MatcherAccepts<T>(value);
    }

    @Factory
    public static <T> Matcher<Matcher<? super T>> rejects(T value) {
        return new MatcherAccepts<T>(false, value);
    }

    @Factory
    public static <T> Matcher<Matcher<? super T>> accepts(T value, Matcher<? super MatchResult<T>> resultMatcher) {
        return new MatcherAccepts<T>(value, resultMatcher);
    }

    @Factory
    public static <T> Matcher<Matcher<? super T>> rejects(T value, Matcher<? super MatchResult<T>> resultMatcher) {
        return new MatcherAccepts<T>(false, value, resultMatcher);
    }

    @Factory
    public static <T> Matcher<Matcher<? super T>> acceptsWithMessage(T value, Matcher<? super String> messageMatcher) {
        return new MatcherAccepts<T>(value, HasDescription.message(messageMatcher));
    }

    @Factory
    public static <T> Matcher<Matcher<? super T>> rejectsWithMessage(T value, Matcher<? super String> messageMatcher) {
        return new MatcherAccepts<T>(false, value, HasDescription.message(messageMatcher));
    }

    @Factory
    public static <T> Matcher<Matcher<? super T>> rejectsWithExpectedMessage(T value, Matcher<? super String> messageMatcher) {
        return new MatcherAccepts<T>(false, value, MatchResultExpected.expectedMessage(messageMatcher));
    }

    @Factory
    public static <T> Matcher<Matcher<? super T>> acceptsWithMessage(T value, String messageMatcher) {
        return new MatcherAccepts<T>(value, HasDescription.message(messageMatcher));
    }

    @Factory
    public static <T> Matcher<Matcher<? super T>> rejectsWithMessage(T value, String messageMatcher) {
        return new MatcherAccepts<T>(false, value, HasDescription.message(messageMatcher));
    }

    @Factory
    public static <T> Matcher<Matcher<? super T>> rejectsWithExpectedMessage(T value, String messageMatcher) {
        return new MatcherAccepts<T>(false, value, MatchResultExpected.expectedMessage(messageMatcher));
    }

    @Factory
    public static <T> Matcher<Matcher<? super T>> accepts(T value, String messageMatcher) {
        return MatcherAccepts.acceptsWithMessage(value, messageMatcher);
    }

    @Factory
    public static <T> Matcher<Matcher<? super T>> rejects(T value, String messageMatcher) {
        return MatcherAccepts.rejectsWithMessage(value, messageMatcher);
    }

    @Factory
    public static <T> Matcher<Matcher<? super T>> expects(T value, String messageMatcher) {
        return MatcherAccepts.rejectsWithExpectedMessage(value, messageMatcher);
    }

    public MatcherAccepts(T value) {
        super(Matcher.class);
        this.match = true;
        this.value = value;
        this.resultMatcher = null;
    }

    public MatcherAccepts(T value, Matcher<? super MatchResult<T>> resultMatcher) {
        super(Matcher.class);
        this.match = true;
        this.value = value;
        this.resultMatcher = resultMatcher;
    }

    public MatcherAccepts(boolean match, T value) {
        super(Matcher.class);
        this.match = match;
        this.value = value;
        this.resultMatcher = null;
    }

    public MatcherAccepts(boolean match, T value, Matcher<? super MatchResult<T>> resultMatcher) {
        super(Matcher.class);
        this.match = match;
        this.value = value;
        this.resultMatcher = resultMatcher;
    }

    public void describeTo(Description description) {
        description.appendText("a matcher ").appendText(this.match ? "accepting " : "rejecting ").appendValue(this.value);
        if (this.resultMatcher != null) {
            description.appendText(" and ").appendText(this.match ? "match " : "mismatch ");
            this.nestedDescribeTo((SelfDescribing)this.resultMatcher, description);
        }
    }

    @Override
    public int getDescriptionPrecedence() {
        return this.resultMatcher == null ? 0x1000000 : 0x100000;
    }

    @Override
    protected boolean matchesSafely(Matcher<? super T> item) {
        if (item.matches(this.value) != this.match) {
            return false;
        }
        if (this.resultMatcher == null) {
            return true;
        }
        return this.resultMatcher.matches(MatcherAccepts.quickMatchResult(item, this.value));
    }

    @Override
    protected <I extends Matcher<? super T>> MatchResult<I> matchResultSafely(I item) {
        MatchResult<T> valueResult = MatcherAccepts.quickMatchResult(item, this.value);
        if (this.resultMatcher == null || valueResult.matched() != this.match) {
            return this.valueResult(item, valueResult);
        }
        MatchResult<MatchResult<T>> msgResult = MatcherAccepts.quickMatchResult(this.resultMatcher, valueResult);
        return this.messageResult(item, msgResult);
    }

    private <I extends Matcher<? super T>> MatchResult<I> valueResult(I item, final MatchResult<T> mr) {
        return new AbstractMatchResult<I, Matcher<?>>(item, this, mr.matched() == this.match){

            @Override
            public void describeMatch(Description d) {
                d.appendValue(this.getValue()).appendText(MatcherAccepts.this.match ? " accepted " : " rejected ").appendValue(MatcherAccepts.this.value).appendText(": '").appendValue((Object)mr).appendText("'");
            }

            @Override
            public void describeMismatch(Description d) {
                d.appendValue(this.getValue()).appendText(MatcherAccepts.this.match ? " rejected " : " accepted ").appendValue(MatcherAccepts.this.value).appendText(": '").appendValue((Object)mr).appendText("'");
            }
        };
    }

    private <I> MatchResult<I> messageResult(I item, final MatchResult<MatchResult<T>> mr) {
        return new NestedMatcher.NestedResult<I, Matcher<?>>(item, this, mr.matched()){

            @Override
            public void describeMatch(Description d) {
                d.appendValue(this.getValue());
                d.appendText(MatcherAccepts.this.match ? " match " : " mismatch ");
                this.nestedDescribeTo(this.getMatchPrecedence(), mr, d);
            }

            @Override
            public void describeMismatch(Description d) {
                d.appendValue(this.getValue());
                d.appendText(MatcherAccepts.this.match ? " match " : " mismatch ");
                this.nestedDescribeTo(this.getMismatchPrecedence(), mr, d);
            }
        };
    }
}

