/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.proc;

import org.cthul.matchers.diagnose.nested.NestedMatcher;
import org.cthul.matchers.diagnose.result.AtomicMismatch;
import org.cthul.matchers.diagnose.result.MatchResult;
import org.cthul.matchers.diagnose.safe.TypesafeNestedResultMatcher;
import org.cthul.matchers.exceptions.IsThrowable;
import org.cthul.proc.Proc;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;

public class Raises
extends TypesafeNestedResultMatcher<Proc> {
    private final Matcher<? super Throwable> exceptionMatcher;

    public Raises(Matcher<? super Throwable> matcher) {
        super(Proc.class);
        this.exceptionMatcher = matcher;
    }

    @Override
    public int getDescriptionPrecedence() {
        return 0x100000;
    }

    public void describeTo(Description description) {
        description.appendText("a call throwing ");
        this.nestedDescribeTo((SelfDescribing)this.exceptionMatcher, description);
    }

    @Override
    protected boolean matchesSafely(Proc proc) {
        if (proc.hasResult()) {
            return false;
        }
        return this.exceptionMatcher.matches((Object)proc.getException());
    }

    @Override
    protected <I extends Proc> MatchResult<I> matchResultSafely(I proc) {
        if (proc.hasResult()) {
            return new AtomicMismatch<I, Raises>(proc, this, "threw no exception");
        }
        final MatchResult<Throwable> nested = Raises.quickMatchResult(this.exceptionMatcher, proc.getException());
        return new NestedMatcher.NestedResult<I, Raises>(proc, this, nested.matched()){

            @Override
            public void describeTo(Description d) {
                d.appendText("threw ");
                this.nestedDescribeTo(this.getDescriptionPrecedence(), nested, d);
            }

            @Override
            public void describeMatch(Description d) {
                this.describeTo(d);
            }

            @Override
            public void describeExpected(Description d) {
                d.appendText("a call throwing ");
                this.nestedDescribeTo(this.getExpectedPrecedence(), nested.getMismatch().getExpectedDescription(), d);
            }

            @Override
            public void describeMismatch(Description d) {
                this.describeTo(d);
            }
        };
    }

    @Factory
    public static Matcher<Proc> raises(Matcher<? super Throwable> throwableMatcher) {
        return new Raises(throwableMatcher);
    }

    @Factory
    public static Matcher<Proc> raises(Class<? extends Throwable> clazz) {
        return Raises.raises(IsThrowable.throwable(clazz));
    }

    @Factory
    public static Matcher<Proc> raises(String regex) {
        return Raises.raises(IsThrowable.throwable(regex));
    }

    @Factory
    public static Matcher<Proc> raises(Class<? extends Throwable> clazz, String regex) {
        return Raises.raises(IsThrowable.throwable(clazz, regex));
    }

    @Factory
    public static Matcher<Proc> raises(Class<? extends Throwable> clazz, Matcher<? super Throwable> matcher) {
        return Raises.raises(IsThrowable.throwable(clazz, matcher));
    }

    @Factory
    public static Matcher<Proc> raisesException() {
        return Raises.raises(IsThrowable.exception());
    }

    @Factory
    public static Matcher<Proc> raisesException(Matcher<? super Exception> matcher) {
        return Raises.raises(IsThrowable.exception(matcher));
    }

    @Factory
    public static Matcher<Proc> raisesException(Class<? extends Exception> clazz) {
        return new Raises(IsThrowable.exception(clazz));
    }

    @Factory
    public static Matcher<Proc> raisesException(String regex) {
        return new Raises(IsThrowable.exception(regex));
    }

    @Factory
    public static Matcher<Proc> raisesException(Class<? extends Exception> clazz, String regex) {
        return new Raises(IsThrowable.exception(clazz, regex));
    }
}

