/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.diagnose.safe;

import org.cthul.matchers.diagnose.nested.NestedMatcher;
import org.cthul.matchers.diagnose.result.AtomicMismatch;
import org.cthul.matchers.diagnose.result.MatchResult;
import org.cthul.matchers.diagnose.safe.Typesafe;
import org.hamcrest.Description;
import org.hamcrest.StringDescription;
import org.hamcrest.internal.ReflectiveTypeFinder;

public abstract class TypesafeNestedMatcher<T>
extends NestedMatcher<T> {
    private static final ReflectiveTypeFinder TYPE_FINDER = new ReflectiveTypeFinder("matchesSafely", 2, 0);
    private final Class<?> expectedType;

    public TypesafeNestedMatcher(Class<?> expectedType) {
        this.expectedType = expectedType;
    }

    public TypesafeNestedMatcher(ReflectiveTypeFinder typeFinder) {
        this.expectedType = typeFinder.findExpectedType(this.getClass());
    }

    public TypesafeNestedMatcher() {
        this(TYPE_FINDER);
    }

    protected boolean matchesSafely(T item) {
        return this.matchesSafely(item, Description.NONE);
    }

    protected void describeMismatchSafely(T item, Description mismatch) {
        this.matchesSafely(item, mismatch);
    }

    protected abstract boolean matchesSafely(T var1, Description var2);

    protected <I extends T> MatchResult<I> matchResultSafely(I item) {
        return super.matchResult(item);
    }

    @Override
    public boolean matches(Object item) {
        return Typesafe.matches(item, this.expectedType) && this.matchesSafely(item);
    }

    @Override
    public final boolean matches(Object item, Description description) {
        if (!Typesafe.matches(item, this.expectedType, description)) {
            return false;
        }
        return this.matchesSafely(item, description);
    }

    @Override
    public void describeMismatch(Object item, Description description) {
        if (!Typesafe.matches(item, this.expectedType, description)) {
            return;
        }
        this.describeMismatchSafely(item, description);
    }

    @Override
    public <I> MatchResult<I> matchResult(I item) {
        if (!Typesafe.matches(item, this.expectedType)) {
            StringDescription sd = new StringDescription();
            Typesafe.matches(item, this.expectedType, (Description)sd);
            return new AtomicMismatch<I, TypesafeNestedMatcher>(item, this, sd.toString());
        }
        return this.matchResultSafely(item);
    }
}

