/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.objects.instance;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class UniqueValueCache<K, V> {
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private final ConcurrentMap<KeyRef, Reference<V>> cache = new ConcurrentHashMap<KeyRef, Reference<V>>();

    public V get(K key) {
        V value;
        this.cleanUp();
        Reference<Object> ref = (Reference<Object>)this.cache.get(new Key<K>(key));
        V v = value = ref != null ? (V)ref.get() : null;
        if (value == null) {
            V newValue = this.newValue(key);
            while (value == null) {
                KeyRef<Object> cr = new KeyRef<Object>(key, this.queue);
                ref = this.newReference(cr, newValue, this.queue);
                ((KeyRef)cr).instanceRef = ref;
                Reference<Object> r2 = this.cache.putIfAbsent(cr, ref);
                value = (V)(r2 == null ? newValue : r2.get());
            }
        }
        return value;
    }

    private void cleanUp() {
        Reference<Object> r;
        while ((r = this.queue.poll()) != null) {
            KeyRef cr = ((GetKeyRef)((Object)r)).getKeyRef();
            this.cache.remove(cr, cr.instanceRef);
        }
    }

    protected Reference<V> newReference(KeyRef keyRef, V value, ReferenceQueue<? super V> q) {
        return new WeakValueRef<V>(keyRef, value, q);
    }

    protected abstract V newValue(K var1);

    protected static interface GetKeyRef {
        public KeyRef getKeyRef();
    }

    private static class Key<K> {
        private K key;

        public Key(K key) {
            this.key = key;
        }

        public boolean equals(Object obj) {
            if (obj instanceof KeyRef) {
                obj = ((KeyRef)obj).get();
            } else if (obj instanceof Key) {
                obj = ((Key)obj).key;
            }
            return this.key.equals(obj);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    protected static class KeyRef<K>
    extends SoftReference<K>
    implements GetKeyRef {
        private final int hash;
        private Reference<?> instanceRef = null;

        public KeyRef(K referent, ReferenceQueue<? super K> q) {
            super(referent, q);
            this.hash = referent.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            Object k = this.get();
            if (k == null) {
                return obj == null;
            }
            if (obj instanceof KeyRef) {
                obj = ((KeyRef)obj).get();
            } else if (obj instanceof Key) {
                obj = ((Key)obj).key;
            }
            return k.equals(obj);
        }

        public int hashCode() {
            return this.hash;
        }

        @Override
        public KeyRef getKeyRef() {
            return this;
        }
    }

    protected static class SoftValueRef<T>
    extends SoftReference<T>
    implements GetKeyRef {
        private final KeyRef keyRef;

        public SoftValueRef(KeyRef keyRef, T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.keyRef = keyRef;
        }

        @Override
        public KeyRef getKeyRef() {
            return this.keyRef;
        }
    }

    protected static class WeakValueRef<T>
    extends WeakReference<T>
    implements GetKeyRef {
        private final KeyRef keyRef;

        public WeakValueRef(KeyRef keyRef, T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.keyRef = keyRef;
        }

        @Override
        public KeyRef getKeyRef() {
            return this.keyRef;
        }
    }
}

