/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.chain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cthul.matchers.chain.ChainBuilderBase;
import org.cthul.matchers.chain.ChainFactory;
import org.cthul.matchers.chain.ChainFactoryBase;
import org.cthul.matchers.chain.MatcherChainBase;
import org.cthul.matchers.diagnose.nested.Nested;
import org.cthul.matchers.diagnose.nested.NestedResultMatcher;
import org.cthul.matchers.diagnose.result.MatchResult;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public class AndChainMatcher<T>
extends MatcherChainBase<T> {
    public static final ChainFactory FACTORY = new ChainFactoryBase(){

        @Override
        public <T> Matcher<T> create(Collection<? extends Matcher<? super T>> chain) {
            return new AndChainMatcher(chain);
        }
    };

    public AndChainMatcher(Collection<? extends Matcher<? super T>> matchers) {
        super(matchers);
    }

    public AndChainMatcher(Matcher<? super T> ... matchers) {
        super(matchers);
    }

    @Override
    public int getDescriptionPrecedence() {
        return Nested.pAtomicUnaryOr(24576, this.matchers.length);
    }

    public void describeTo(Description description) {
        if (this.matchers.length == 0) {
            description.appendText("<anything>");
        } else {
            Nested.joinDescriptions(this.getDescriptionPrecedence(), this.matchersList(), description, " and ");
        }
    }

    @Override
    public boolean matches(Object item) {
        for (Matcher m : this.matchers) {
            if (m.matches(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <I> MatchResult<I> matchResult(I item) {
        ArrayList<MatchResult.Match<I>> results = new ArrayList<MatchResult.Match<I>>(this.matchers.length);
        for (Matcher m : this.matchers) {
            MatchResult<I> mr = AndChainMatcher.quickMatchResult(m, item);
            if (!mr.matched()) {
                return this.failResult(item, mr.getMismatch());
            }
            results.add(mr.getMatch());
        }
        return this.successResult(item, results);
    }

    private <I> MatchResult<I> successResult(I item, final List<MatchResult.Match<I>> results) {
        return new NestedResultMatcher.NestedMatch<I, AndChainMatcher<T>>(item, this){

            @Override
            public void describeMatch(Description description) {
                if (results.isEmpty()) {
                    this.describeMatcher(description);
                } else {
                    Nested.joinMatchDescriptions(this.getMatchPrecedence(), results, description, " and ");
                }
            }
        };
    }

    private <I> MatchResult<I> failResult(I item, final MatchResult.Mismatch<I> nested) {
        return new NestedResultMatcher.NestedMismatch<I, AndChainMatcher<T>>(item, this){

            @Override
            public int getExpectedPrecedence() {
                return 0x100000;
            }

            @Override
            public void describeExpected(Description d) {
                this.nestedDescribeExpected(nested, d);
            }

            @Override
            public int getMismatchPrecedence() {
                return 0x100000;
            }

            @Override
            public void describeMismatch(Description d) {
                this.nestedDescribeMismatch(nested, d);
            }
        };
    }

    @Factory
    public static <T> Matcher<T> and(Matcher<? super T> ... matchers) {
        return new AndChainMatcher<T>(matchers);
    }

    @Factory
    public static <T> Matcher<T> and(Collection<? extends Matcher<? super T>> matchers) {
        return new AndChainMatcher<T>(matchers);
    }

    @Factory
    public static <T> Builder<T> both(Matcher<? super T> m) {
        return new Builder().and(m);
    }

    @Factory
    public static <T> Builder<T> both(Matcher<? super T> ... m) {
        return new Builder().and(m);
    }

    @Factory
    public static <T> Builder<T> all(Matcher<? super T> m) {
        return new Builder().and(m);
    }

    @Factory
    public static <T> Builder<T> all(Matcher<? super T> ... m) {
        return new Builder().and(m);
    }

    @Factory
    public static ChainFactory all() {
        return FACTORY;
    }

    public static class Builder<T>
    extends ChainBuilderBase<T> {
        @Override
        protected ChainFactory factory() {
            return FACTORY;
        }

        public <T2 extends T> Builder<T2> and(Matcher<? super T2> m) {
            return (Builder)this._add(m);
        }

        public <T2 extends T> Builder<T2> and(Matcher<? super T2> ... m) {
            return (Builder)this._add(m);
        }

        public <T2 extends T> Builder<T2> and(Collection<? extends Matcher<? super T2>> m) {
            return (Builder)this._add(m);
        }
    }
}

