/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.exceptions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cthul.matchers.diagnose.nested.Nested;
import org.cthul.matchers.diagnose.nested.NestedMatcher;
import org.cthul.matchers.diagnose.result.AtomicMismatch;
import org.cthul.matchers.diagnose.result.MatchResult;
import org.cthul.matchers.diagnose.safe.TypesafeNestedResultMatcher;
import org.cthul.matchers.exceptions.IsThrowable;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;

public class CausedBy
extends TypesafeNestedResultMatcher<Throwable> {
    private final boolean direct;
    private final Matcher<? super Throwable> throwableMatcher;

    public CausedBy(boolean direct, Matcher<? super Throwable> m) {
        super(Throwable.class);
        this.direct = direct;
        this.throwableMatcher = m;
    }

    @Override
    public int getDescriptionPrecedence() {
        return 0x100000;
    }

    @Override
    protected boolean matchesSafely(Throwable ex) {
        Throwable cause;
        if (this.direct) {
            return this.throwableMatcher.matches((Object)cause);
        }
        for (cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            if (!this.throwableMatcher.matches((Object)cause)) continue;
            return true;
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("a throwable ");
        if (this.direct) {
            description.appendText("directly ");
        }
        description.appendText("caused by ");
        this.nestedDescribeTo((SelfDescribing)this.throwableMatcher, description);
    }

    @Override
    protected <I extends Throwable> MatchResult<I> matchResultSafely(I ex) {
        Throwable cause = ex.getCause();
        if (cause == null) {
            return new AtomicMismatch<I, CausedBy>(ex, this, "no cause");
        }
        if (this.direct || cause.getCause() == null) {
            MatchResult<Throwable> mr = CausedBy.quickMatchResult(this.throwableMatcher, cause);
            if (mr.matched()) {
                return this.successResult(ex, -1, mr.getMatch());
            }
            return this.failResult(ex, Arrays.asList(mr.getMismatch()));
        }
        ArrayList<MatchResult.Mismatch<Throwable>> mismatches = new ArrayList<MatchResult.Mismatch<Throwable>>();
        int i = 1;
        while (cause != null) {
            MatchResult<Throwable> mr = CausedBy.quickMatchResult(this.throwableMatcher, cause);
            if (mr.matched()) {
                return this.successResult(ex, i, mr.getMatch());
            }
            mismatches.add(mr.getMismatch());
            ++i;
            cause = cause.getCause();
        }
        return this.failResult(ex, mismatches);
    }

    private <I extends Throwable> MatchResult<I> successResult(I ex, final int index, final MatchResult.Match<Throwable> nested) {
        return new NestedMatcher.NestedMatch<I, CausedBy>(ex, this){

            @Override
            public void describeMatch(Description description) {
                description.appendText("cause ");
                if (index > 0) {
                    description.appendText(String.valueOf(index));
                    description.appendText(" ");
                }
                this.nestedDescribeMatch(nested, description);
            }
        };
    }

    private <I extends Throwable> MatchResult<I> failResult(I ex, final List<MatchResult.Mismatch<Throwable>> nested) {
        return new NestedMatcher.NestedMismatch<I, CausedBy>(ex, this){

            @Override
            public int getMismatchPrecedence() {
                return Nested.pAtomicUnaryOr(36864, nested.size());
            }

            @Override
            public void describeExpected(Description description) {
                if (nested.size() == 1) {
                    description.appendText("cause ");
                    this.nestedDescribeExpected((MatchResult.Mismatch)nested.get(0), description);
                } else {
                    this.describeMatcher(description);
                }
            }

            @Override
            public void describeMismatch(Description description) {
                if (nested.size() == 1) {
                    description.appendText("cause ");
                    this.nestedDescribeMismatch((MatchResult.Mismatch)nested.get(0), description);
                } else {
                    int i = 1;
                    for (MatchResult.Mismatch m : nested) {
                        if (i > 1) {
                            description.appendText(", ");
                        }
                        description.appendText("cause ");
                        description.appendText(String.valueOf(i++));
                        description.appendText(" ");
                        this.nestedDescribeMismatch(m, description);
                    }
                }
            }
        };
    }

    @Factory
    public static CausedBy causedBy(Matcher<? super Throwable> matcher) {
        return new CausedBy(false, matcher);
    }

    @Factory
    public static CausedBy causedBy(Class<? extends Throwable> clazz) {
        return CausedBy.causedBy(IsThrowable.throwable(clazz));
    }

    @Factory
    public static CausedBy causedBy(String message) {
        return CausedBy.causedBy(IsThrowable.throwable(message));
    }

    @Factory
    public static CausedBy causedBy(Class<? extends Throwable> clazz, String message) {
        return CausedBy.causedBy(IsThrowable.throwable(clazz, message));
    }

    @Factory
    public static CausedBy causedBy(Class<? extends Throwable> clazz, Matcher<? super Throwable> matcher) {
        return CausedBy.causedBy(IsThrowable.throwable(clazz, matcher));
    }

    @Factory
    public static CausedBy causedBy(Class<? extends Throwable> clazz, String message, Matcher<? super Throwable> matcher) {
        return CausedBy.causedBy(IsThrowable.throwable(clazz, message, matcher));
    }

    @Factory
    public static CausedBy directlyCausedBy(Matcher<? super Throwable> matcher) {
        return new CausedBy(true, matcher);
    }

    @Factory
    public static CausedBy directlyCausedBy(Class<? extends Throwable> clazz) {
        return CausedBy.directlyCausedBy(IsThrowable.throwable(clazz));
    }

    @Factory
    public static CausedBy directlyCausedBy(Class<? extends Throwable> clazz, String message) {
        return CausedBy.directlyCausedBy(IsThrowable.throwable(clazz, message));
    }

    @Factory
    public static CausedBy directlyCausedBy(Class<? extends Throwable> clazz, Matcher<? super Throwable> matcher) {
        return CausedBy.directlyCausedBy(IsThrowable.throwable(clazz, matcher));
    }

    @Factory
    public static CausedBy directlyCausedBy(Class<? extends Throwable> clazz, String message, Matcher<? super Throwable> matcher) {
        return CausedBy.directlyCausedBy(IsThrowable.throwable(clazz, message, matcher));
    }
}

