/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.exceptions;

import java.util.regex.Pattern;
import org.cthul.matchers.diagnose.nested.NestedMatcher;
import org.cthul.matchers.diagnose.result.MatchResult;
import org.cthul.matchers.diagnose.safe.TypesafeNestedResultMatcher;
import org.cthul.matchers.object.ContainsPattern;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.core.Is;

public class ExceptionMessage
extends TypesafeNestedResultMatcher<Throwable> {
    private Matcher<? super String> messageMatcher;

    public ExceptionMessage(Matcher<? super String> messageMatcher) {
        super(Throwable.class);
        this.messageMatcher = messageMatcher;
    }

    @Override
    public int getDescriptionPrecedence() {
        return 0x100000;
    }

    @Override
    protected boolean matchesSafely(Throwable ex) {
        return this.messageMatcher.matches((Object)ex.getMessage());
    }

    public void describeTo(Description description) {
        description.appendText("throwable message is ");
        this.nestedDescribeTo((SelfDescribing)this.messageMatcher, description);
    }

    @Override
    protected <I extends Throwable> MatchResult<I> matchResultSafely(I item) {
        final MatchResult<String> nested = ExceptionMessage.quickMatchResult(this.messageMatcher, item.getMessage());
        return new NestedMatcher.NestedResult<I, ExceptionMessage>(item, this, nested.matched()){

            @Override
            public void describeTo(Description d) {
                d.appendText("message ");
                this.nestedDescribeTo(this.getDescriptionPrecedence(), nested, d);
            }

            @Override
            public void describeMatch(Description d) {
                this.describeTo(d);
            }

            @Override
            public void describeExpected(Description d) {
                d.appendText("message ");
                this.nestedDescribeTo(this.getExpectedPrecedence(), nested.getMismatch().getExpectedDescription(), d);
            }

            @Override
            public void describeMismatch(Description d) {
                this.describeTo(d);
            }
        };
    }

    @Factory
    public static ExceptionMessage messageIs(String message) {
        return new ExceptionMessage((Matcher<? super String>)Is.is((Object)message));
    }

    @Factory
    public static ExceptionMessage messageContains(String regex) {
        return new ExceptionMessage(new ContainsPattern(regex, false));
    }

    @Factory
    public static ExceptionMessage messageMatches(String regex) {
        return new ExceptionMessage(new ContainsPattern(regex, true));
    }

    @Factory
    public static ExceptionMessage messageContains(Pattern pattern) {
        return new ExceptionMessage(new ContainsPattern(pattern, false));
    }

    @Factory
    public static ExceptionMessage messageMatches(Pattern pattern) {
        return new ExceptionMessage(new ContainsPattern(pattern, true));
    }

    @Factory
    public static ExceptionMessage message(Matcher<? super String> messageMatcher) {
        return new ExceptionMessage(messageMatcher);
    }
}

