/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.object;

import java.util.regex.Pattern;
import org.cthul.matchers.diagnose.safe.TypesafeQuickMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public class ContainsPattern
extends TypesafeQuickMatcher<CharSequence> {
    private final Pattern p;
    private final boolean match;

    public ContainsPattern(Pattern p, boolean match) {
        super(String.class);
        this.p = p;
        this.match = match;
    }

    public ContainsPattern(Pattern p) {
        this(p, false);
    }

    public ContainsPattern(String regex, boolean match) {
        this(Pattern.compile(regex), match);
    }

    public ContainsPattern(String regex) {
        this(Pattern.compile(regex));
    }

    public void describeTo(Description description) {
        description.appendText("a string ").appendText(this.match ? "matching" : "containing").appendText(" /").appendText(this.p.pattern()).appendText("/");
    }

    @Override
    protected boolean matchesSafely(CharSequence item) {
        return this.match ? this.p.matcher(item).matches() : this.p.matcher(item).find();
    }

    @Override
    protected void describeMismatchSafely(CharSequence item, Description mismatch) {
        mismatch.appendValue((Object)item).appendText(" did not ").appendText(this.match ? "match" : "contain").appendText(" /").appendText(this.p.pattern()).appendText("/");
    }

    @Factory
    public static Matcher<CharSequence> containsPattern(String regex) {
        return new ContainsPattern(regex, false);
    }

    @Factory
    public static Matcher<CharSequence> containsPattern(Pattern p) {
        return new ContainsPattern(p, false);
    }

    @Factory
    public static Matcher<CharSequence> matchesPattern(String regex) {
        return new ContainsPattern(regex, true);
    }

    @Factory
    public static Matcher<CharSequence> matchesPattern(Pattern p) {
        return new ContainsPattern(p, true);
    }
}

