package org.cthul.fixsure;

public class Fixsure {

    /**
     * Converts a supplier into a generator.
     *
     * @param <T>
     * @param supplier
     * @return generator
     * @see org.cthul.fixsure.Generator#generate(java.util.function.Supplier)
     */
    static <T> org.cthul.fixsure.fluents.FlGenerator<T> generate(java.util.function.Supplier<T> supplier) {
        return org.cthul.fixsure.Generator.generate(supplier);
    }

    /**
     * Converts a supplier into a typed generator.
     *
     * @param <T>
     * @param clazz
     * @param supplier
     * @return generator
     * @see org.cthul.fixsure.Generator#generate(java.lang.Class,java.util.function.Supplier)
     */
    static <T> org.cthul.fixsure.fluents.FlGenerator<T> generate(java.lang.Class<T> clazz, java.util.function.Supplier<T> supplier) {
        return org.cthul.fixsure.Generator.generate(clazz, supplier);
    }

    /**
     * Returns a template.
     * This method does nothing, it is for convenience when using lambda expression.
     *
     * @param <T>
     * @param template
     * @return template
     * @see org.cthul.fixsure.Template#template(org.cthul.fixsure.fluents.FlTemplate)
     */
    static <T> org.cthul.fixsure.fluents.FlTemplate<T> template(org.cthul.fixsure.fluents.FlTemplate<T> template) {
        return org.cthul.fixsure.Template.template(template);
    }

    /**
     * Converts a function into an unbounded sequence.
     *
     * @param <T>
     * @param function
     * @return sequence
     * @see org.cthul.fixsure.Sequence#sequence(java.util.function.LongFunction)
     */
    static <T> org.cthul.fixsure.fluents.FlSequence<T> sequence(java.util.function.LongFunction<T> function) {
        return org.cthul.fixsure.Sequence.sequence(function);
    }

    /**
     * Converts a function into a bounded sequence.
     *
     * @param <T>
     * @param length
     * @param function
     * @return sequence
     * @see org.cthul.fixsure.Sequence#sequence(long,java.util.function.LongFunction)
     */
    static <T> org.cthul.fixsure.fluents.FlSequence<T> sequence(long length, java.util.function.LongFunction<T> function) {
        return org.cthul.fixsure.Sequence.sequence(length, function);
    }

    /**
     * Converts a function into a typed, bounded sequence
     *
     * @param <T>
     * @param clazz
     * @param length
     * @param function
     * @return sequence
     * @see org.cthul.fixsure.Sequence#sequence(java.lang.Class,long,java.util.function.LongFunction)
     */
    static <T> org.cthul.fixsure.fluents.FlSequence<T> sequence(java.lang.Class<T> clazz, long length, java.util.function.LongFunction<T> function) {
        return org.cthul.fixsure.Sequence.sequence(clazz, length, function);
    }

    /**
     * Generates random booleans
     *
     * @return random booleans
     * @see org.cthul.fixsure.generators.primitives.BooleansGenerator#booleans()
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.Boolean> booleans() {
        return org.cthul.fixsure.generators.primitives.BooleansGenerator.booleans();
    }

    /**
     * Generates random booleans.
     *
     * @param ratio ratio of true values
     * @return random booleans
     * @see org.cthul.fixsure.generators.primitives.BooleansGenerator#booleans(double)
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.Boolean> booleans(double ratio) {
        return org.cthul.fixsure.generators.primitives.BooleansGenerator.booleans(ratio);
    }

    /**
     * Generates random booleans
     *
     * @param distribution
     * @return random booleans
     * @see org.cthul.fixsure.generators.primitives.BooleansGenerator#booleans(org.cthul.fixsure.Distribution)
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.Boolean> booleans(org.cthul.fixsure.Distribution distribution) {
        return org.cthul.fixsure.generators.primitives.BooleansGenerator.booleans(distribution);
    }

    /**
     * @see org.cthul.fixsure.generators.primitives.BooleansGenerator#booleans(double,org.cthul.fixsure.Distribution,long)
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.Boolean> booleans(double threshold, org.cthul.fixsure.Distribution distribution, long seedHint) {
        return org.cthul.fixsure.generators.primitives.BooleansGenerator.booleans(threshold, distribution, seedHint);
    }

    /**
     * Generates random characters from space ({@code ' '} to tilde ({@code '~'}).
     *
     * @return random characters
     * @see org.cthul.fixsure.generators.primitives.CharactersGenerator#characters()
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.Character> characters() {
        return org.cthul.fixsure.generators.primitives.CharactersGenerator.characters();
    }

    /**
     * Generates random characters from a string.
     *
     * @param source
     * @return random characters
     * @see org.cthul.fixsure.generators.primitives.CharactersGenerator#characters(java.lang.String)
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.Character> characters(java.lang.String source) {
        return org.cthul.fixsure.generators.primitives.CharactersGenerator.characters(source);
    }

    /**
     * Generates random characters from a string.
     *
     * @param source
     * @param distribution
     * @return random characters
     * @see org.cthul.fixsure.generators.primitives.CharactersGenerator#characters(java.lang.String,org.cthul.fixsure.Distribution)
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.Character> characters(java.lang.String source, org.cthul.fixsure.Distribution distribution) {
        return org.cthul.fixsure.generators.primitives.CharactersGenerator.characters(source, distribution);
    }

    /**
     * Generates random characters with in the given range, inclusive.
     *
     * @param min
     * @param max
     * @return random characters
     * @see org.cthul.fixsure.generators.primitives.CharactersGenerator#characters(char,char)
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.Character> characters(char min, char max) {
        return org.cthul.fixsure.generators.primitives.CharactersGenerator.characters(min, max);
    }

    /**
     * Generates random characters with in the given range, inclusive.
     *
     * @param min
     * @param max
     * @param distribution
     * @return random characters
     * @see org.cthul.fixsure.generators.primitives.CharactersGenerator#characters(char,char,org.cthul.fixsure.Distribution)
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.Character> characters(char min, char max, org.cthul.fixsure.Distribution distribution) {
        return org.cthul.fixsure.generators.primitives.CharactersGenerator.characters(min, max, distribution);
    }

    /**
     * Generates consecutive integers.
     *
     * @return consecutive integers
     * @see org.cthul.fixsure.generators.primitives.ConsecutiveIntegersSequence#consecutiveIntegers()
     */
    public static org.cthul.fixsure.generators.primitives.ConsecutiveIntegersSequence consecutiveIntegers() {
        return org.cthul.fixsure.generators.primitives.ConsecutiveIntegersSequence.consecutiveIntegers();
    }

    /**
     * Generates consecutive integers.
     *
     * @param first
     * @return consecutive integers
     * @see org.cthul.fixsure.generators.primitives.ConsecutiveIntegersSequence#consecutiveIntegers(int)
     */
    public static org.cthul.fixsure.generators.primitives.ConsecutiveIntegersSequence consecutiveIntegers(int first) {
        return org.cthul.fixsure.generators.primitives.ConsecutiveIntegersSequence.consecutiveIntegers(first);
    }

    /**
     * Generates consecutive integers.
     *
     * @param first
     * @param step
     * @return consecutive integers
     * @see org.cthul.fixsure.generators.primitives.ConsecutiveIntegersSequence#consecutiveIntegers(int,int)
     */
    public static org.cthul.fixsure.generators.primitives.ConsecutiveIntegersSequence consecutiveIntegers(int first, int step) {
        return org.cthul.fixsure.generators.primitives.ConsecutiveIntegersSequence.consecutiveIntegers(first, step);
    }

    /**
     * Generates consecutive integers.
     *
     * @param first
     * @param step
     * @param end
     * @return consecutive integers
     * @see org.cthul.fixsure.generators.primitives.ConsecutiveIntegersSequence#consecutiveIntegers(int,int,int)
     */
    public static org.cthul.fixsure.generators.primitives.ConsecutiveIntegersSequence consecutiveIntegers(int first, int step, int end) {
        return org.cthul.fixsure.generators.primitives.ConsecutiveIntegersSequence.consecutiveIntegers(first, step, end);
    }

    /**
     * Generates random doubles.
     *
     * @return random doubles
     * @see org.cthul.fixsure.generators.primitives.DoublesGenerator#doubles()
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.Double> doubles() {
        return org.cthul.fixsure.generators.primitives.DoublesGenerator.doubles();
    }

    /**
     * Generates random doubles.
     *
     * @param high
     * @return random doubles
     * @see org.cthul.fixsure.generators.primitives.DoublesGenerator#doubles(int)
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.Double> doubles(int high) {
        return org.cthul.fixsure.generators.primitives.DoublesGenerator.doubles(high);
    }

    /**
     * Generates random doubles.
     *
     * @return random doubles
     * @see org.cthul.fixsure.generators.primitives.DoublesGenerator#doubles(int,org.cthul.fixsure.Distribution)
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.Double> doubles(int high, org.cthul.fixsure.Distribution distribution) {
        return org.cthul.fixsure.generators.primitives.DoublesGenerator.doubles(high, distribution);
    }

    /**
     * Generates random doubles.
     *
     * @param low
     * @param high
     * @return random doubles
     * @see org.cthul.fixsure.generators.primitives.DoublesGenerator#doubles(int,int)
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.Double> doubles(int low, int high) {
        return org.cthul.fixsure.generators.primitives.DoublesGenerator.doubles(low, high);
    }

    /**
     * Generates random doubles.
     *
     * @param low
     * @param high
     * @param distribution
     * @return random doubles
     * @see org.cthul.fixsure.generators.primitives.DoublesGenerator#doubles(int,int,org.cthul.fixsure.Distribution)
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.Double> doubles(int low, int high, org.cthul.fixsure.Distribution distribution) {
        return org.cthul.fixsure.generators.primitives.DoublesGenerator.doubles(low, high, distribution);
    }

    /**
     * Generates random integers.
     *
     * @return random integers
     * @see org.cthul.fixsure.generators.primitives.RandomIntegersGenerator#integers()
     */
    public static org.cthul.fixsure.generators.primitives.RandomIntegersGenerator.Template integers() {
        return org.cthul.fixsure.generators.primitives.RandomIntegersGenerator.integers();
    }

    /**
     * Generates random integers.
     *
     * @param end upper bound, exclusive
     * @return random integers
     * @see org.cthul.fixsure.generators.primitives.RandomIntegersGenerator#integers(int)
     */
    public static org.cthul.fixsure.generators.primitives.RandomIntegersGenerator.Template integers(int end) {
        return org.cthul.fixsure.generators.primitives.RandomIntegersGenerator.integers(end);
    }

    /**
     * Generates random integers.
     *
     * @param end upper bound, exclusive
     * @param distribution
     * @return random integers
     * @see org.cthul.fixsure.generators.primitives.RandomIntegersGenerator#integers(int,org.cthul.fixsure.Distribution)
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.Integer> integers(int end, org.cthul.fixsure.Distribution distribution) {
        return org.cthul.fixsure.generators.primitives.RandomIntegersGenerator.integers(end, distribution);
    }

    /**
     * Generates random integers.
     *
     * @param start
     * @param end upper bound, exclusive
     * @return random integers
     * @see org.cthul.fixsure.generators.primitives.RandomIntegersGenerator#integers(int,int)
     */
    public static org.cthul.fixsure.generators.primitives.RandomIntegersGenerator.Template integers(int start, int end) {
        return org.cthul.fixsure.generators.primitives.RandomIntegersGenerator.integers(start, end);
    }

    /**
     * Generates random integers.
     *
     * @param start
     * @param end upper bound, exclusive
     * @param distribution
     * @return random integers
     * @see org.cthul.fixsure.generators.primitives.RandomIntegersGenerator#integers(int,int,org.cthul.fixsure.Distribution)
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.Integer> integers(int start, int end, org.cthul.fixsure.Distribution distribution) {
        return org.cthul.fixsure.generators.primitives.RandomIntegersGenerator.integers(start, end, distribution);
    }

    /**
     * Generates random strings.
     *
     * @return random strings
     * @see org.cthul.fixsure.generators.primitives.StringsGenerator#strings()
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.String> strings() {
        return org.cthul.fixsure.generators.primitives.StringsGenerator.strings();
    }

    /**
     * Generates random strings.
     *
     * @param length
     * @return random strings
     * @see org.cthul.fixsure.generators.primitives.StringsGenerator#strings(int)
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.String> strings(int length) {
        return org.cthul.fixsure.generators.primitives.StringsGenerator.strings(length);
    }

    /**
     * Generates random strings.
     *
     * @param characters
     * @return random strings
     * @see org.cthul.fixsure.generators.primitives.StringsGenerator#strings(org.cthul.fixsure.DataSource)
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.String> strings(org.cthul.fixsure.DataSource<java.lang.Character> characters) {
        return org.cthul.fixsure.generators.primitives.StringsGenerator.strings(characters);
    }

    /**
     * Generates random strings.
     *
     * @param characters
     * @param length
     * @return random strings
     * @see org.cthul.fixsure.generators.primitives.StringsGenerator#strings(org.cthul.fixsure.DataSource,int)
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.String> strings(org.cthul.fixsure.DataSource<java.lang.Character> characters, int length) {
        return org.cthul.fixsure.generators.primitives.StringsGenerator.strings(characters, length);
    }

    /**
     * Generates random strings.
     *
     * @param characters
     * @param length
     * @return random strings
     * @see org.cthul.fixsure.generators.primitives.StringsGenerator#strings(org.cthul.fixsure.DataSource,org.cthul.fixsure.DataSource)
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.String> strings(org.cthul.fixsure.DataSource<java.lang.Character> characters, org.cthul.fixsure.DataSource<java.lang.Integer> length) {
        return org.cthul.fixsure.generators.primitives.StringsGenerator.strings(characters, length);
    }

    /**
     * Generates random strings.
     *
     * @param min
     * @param max
     * @return random strings
     * @see org.cthul.fixsure.generators.primitives.StringsGenerator#strings(char,char)
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.String> strings(char min, char max) {
        return org.cthul.fixsure.generators.primitives.StringsGenerator.strings(min, max);
    }

    /**
     * Generates random strings.
     *
     * @param min
     * @param max
     * @param length
     * @return random strings
     * @see org.cthul.fixsure.generators.primitives.StringsGenerator#strings(char,char,int)
     */
    public static org.cthul.fixsure.fluents.FlTemplate<java.lang.String> strings(char min, char max, int length) {
        return org.cthul.fixsure.generators.primitives.StringsGenerator.strings(min, max, length);
    }

    /**
     * Creates an unbounded sequence of only one value.
     *
     * @param <T>
     * @param value
     * @return constant value sequence
     * @see org.cthul.fixsure.generators.value.ConstantValue#constant(java.lang.Object)
     */
    public static <T> org.cthul.fixsure.generators.value.ConstantValue<T> constant(T value) {
        return org.cthul.fixsure.generators.value.ConstantValue.constant(value);
    }

    /**
     * @see org.cthul.fixsure.generators.value.ConstantValue#constant(java.util.function.Supplier)
     */
    public static <T> org.cthul.fixsure.fluents.FlTemplate<T> constant(java.util.function.Supplier<? extends T> valueSupplier) {
        return org.cthul.fixsure.generators.value.ConstantValue.constant(valueSupplier);
    }

    /**
     * Returns an unbounded sequence of {@code null} values
     *
     * @param <T>
     * @return sequence of {@code null} values
     * @see org.cthul.fixsure.generators.value.ConstantValue#nullValues()
     */
    public static <T> org.cthul.fixsure.generators.value.ConstantValue<T> nullValues() {
        return org.cthul.fixsure.generators.value.ConstantValue.nullValues();
    }

    /**
     * Returns a sequence with length zero.
     *
     * @param <T>
     * @return empty sequence
     * @see org.cthul.fixsure.generators.value.EmptySequence#noValues()
     */
    public static <T> org.cthul.fixsure.generators.value.EmptySequence<T> noValues() {
        return org.cthul.fixsure.generators.value.EmptySequence.noValues();
    }

    /**
     * Converts an array into a sequence.
     *
     * @param <T>
     * @param data
     * @return sequence
     * @see org.cthul.fixsure.generators.value.ItemsSequence#sequence(java.lang.Object...)
     */
    public static <T> org.cthul.fixsure.generators.value.ItemsSequence<T> sequence(T... data) {
        return org.cthul.fixsure.generators.value.ItemsSequence.sequence(data);
    }

    /**
     * Converts a collection into a sequence.
     *
     * @param <T>
     * @param data
     * @return sequence
     * @see org.cthul.fixsure.generators.value.ItemsSequence#sequence(java.util.Collection)
     */
    public static <T> org.cthul.fixsure.generators.value.ItemsSequence<T> sequence(java.util.Collection<T> data) {
        return org.cthul.fixsure.generators.value.ItemsSequence.sequence(data);
    }

    /**
     * Converts a collection into a sequence.
     *
     * @param <T>
     * @param valueType
     * @param data
     * @return sequence
     * @see org.cthul.fixsure.generators.value.ItemsSequence#sequence(java.lang.Class,java.util.Collection)
     */
    public static <T> org.cthul.fixsure.generators.value.ItemsSequence<T> sequence(java.lang.Class<T> valueType, java.util.Collection<T> data) {
        return org.cthul.fixsure.generators.value.ItemsSequence.sequence(valueType, data);
    }

    /**
     * Generates permutations of an array
     *
     * @param <T>
     * @param array
     * @return permutations generator
     * @see org.cthul.fixsure.generators.value.PermutationsGenerator#permutations(java.lang.Object...)
     */
    public static <T> org.cthul.fixsure.fluents.FlTemplate<T[]> permutations(T... array) {
        return org.cthul.fixsure.generators.value.PermutationsGenerator.permutations(array);
    }

    /**
     * Returns a uniform distribution with default seed.
     *
     * @return uniform distribution
     * @see org.cthul.fixsure.distributions.UniformDistribution#uniformDistribution()
     */
    public static org.cthul.fixsure.distributions.UniformDistribution uniformDistribution() {
        return org.cthul.fixsure.distributions.UniformDistribution.uniformDistribution();
    }

    /**
     * Returns a uniform distribution with default seed.
     *
     * @return uniform distribution
     * @see org.cthul.fixsure.distributions.UniformDistribution#uniform()
     */
    public static org.cthul.fixsure.distributions.UniformDistribution uniform() {
        return org.cthul.fixsure.distributions.UniformDistribution.uniform();
    }

    /**
     * Returns a uniform distribution with the specified seed.
     *
     * @param seed
     * @return uniform distribution
     * @see org.cthul.fixsure.distributions.UniformDistribution#uniformDistribution(long)
     */
    public static org.cthul.fixsure.distributions.UniformDistribution uniformDistribution(long seed) {
        return org.cthul.fixsure.distributions.UniformDistribution.uniformDistribution(seed);
    }

    /**
     * Returns a uniform distribution with the specified seed.
     *
     * @param seed
     * @return uniform distribution
     * @see org.cthul.fixsure.distributions.UniformDistribution#uniform(long)
     */
    public static org.cthul.fixsure.distributions.UniformDistribution uniform(long seed) {
        return org.cthul.fixsure.distributions.UniformDistribution.uniform(seed);
    }

    /**
     * Returns a normal or Gaussian distribution with default seed.
     *
     * @return normal distribution
     * @see org.cthul.fixsure.distributions.GaussianDistribution#normalDistribution()
     */
    public static org.cthul.fixsure.distributions.GaussianDistribution normalDistribution() {
        return org.cthul.fixsure.distributions.GaussianDistribution.normalDistribution();
    }

    /**
     * Returns a normal or Gaussian distribution with default seed.
     *
     * @return normal distribution
     * @see org.cthul.fixsure.distributions.GaussianDistribution#normal()
     */
    public static org.cthul.fixsure.distributions.GaussianDistribution normal() {
        return org.cthul.fixsure.distributions.GaussianDistribution.normal();
    }

    /**
     * Returns a normal or Gaussian distribution with the specified seed.
     *
     * @param seed
     * @return normal distribution
     * @see org.cthul.fixsure.distributions.GaussianDistribution#normalDistribution(long)
     */
    public static org.cthul.fixsure.distributions.GaussianDistribution normalDistribution(long seed) {
        return org.cthul.fixsure.distributions.GaussianDistribution.normalDistribution(seed);
    }

    /**
     * Returns a normal or Gaussian distribution with the specified seed.
     *
     * @param seed
     * @return normal distribution
     * @see org.cthul.fixsure.distributions.GaussianDistribution#normal(long)
     */
    public static org.cthul.fixsure.distributions.GaussianDistribution normal(long seed) {
        return org.cthul.fixsure.distributions.GaussianDistribution.normal(seed);
    }

    /**
     * @see org.cthul.fixsure.factory.DefaultFactories#newFactoriesSetup()
     */
    public static org.cthul.fixsure.factory.FactoriesSetup newFactoriesSetup() {
        return org.cthul.fixsure.factory.DefaultFactories.newFactoriesSetup();
    }

}
