/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure;

import org.cthul.fixsure.Generator;
import org.cthul.fixsure.api.Stringify;
import org.cthul.fixsure.fluents.FlDataSource;

@FunctionalInterface
public interface DataSource<T>
extends Stringify {
    public Generator<T> toGenerator();

    default public FlDataSource<T> fluentData() {
        return () -> this.toGenerator().fluentData();
    }

    @SafeVarargs
    public static <T> Generator<T>[] toGenerators(DataSource<T> ... sources) {
        Generator[] result = new Generator[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            result[i] = sources[i].toGenerator();
        }
        return result;
    }

    @SafeVarargs
    public static <T> Generator<T>[] toGenerators(DataSource<T> first, DataSource<T> ... more) {
        Generator[] result = new Generator[more.length + 1];
        result[0] = first.toGenerator();
        for (int i = 0; i < more.length; ++i) {
            result[i + 1] = more[i].toGenerator();
        }
        return result;
    }
}

