/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure;

import java.util.function.Supplier;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Typed;
import org.cthul.fixsure.api.Factory;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.fluents.FlGenerator;
import org.cthul.fixsure.generators.CopyableGenerator;
import org.cthul.fixsure.generators.GeneratorTools;

@FunctionalInterface
public interface Generator<T>
extends Supplier<T>,
DataSource<T> {
    public T next();

    @Override
    @Deprecated
    default public T get() {
        return this.next();
    }

    @Override
    @Deprecated
    default public Generator<T> toGenerator() {
        return this;
    }

    @Override
    default public FlGenerator<T> fluentData() {
        return Generator.generate(this);
    }

    @Factory
    public static <T> FlGenerator<T> generate(Supplier<T> supplier) {
        if (supplier instanceof FlGenerator) {
            return (FlGenerator)supplier;
        }
        if (supplier instanceof Typed) {
            return Generator.generate(((Typed)((Object)supplier)).getValueType(), supplier);
        }
        return supplier::get;
    }

    @Factory
    public static <T> FlGenerator<T> generate(final Class<T> clazz, final Supplier<T> supplier) {
        final Generator actual = supplier instanceof Generator && clazz == Typed.typeOf(supplier) ? (Generator)supplier : null;
        class TypedGenerator
        implements CopyableGenerator<T>,
        Typed<T> {
            TypedGenerator() {
            }

            @Override
            public T next() {
                return supplier.get();
            }

            @Override
            public Class<T> getValueType() {
                return clazz;
            }

            @Override
            public CopyableGenerator<T> copy() {
                return (CopyableGenerator)Generator.generate(clazz, GeneratorTools.copyGenerator(supplier));
            }

            @Override
            @Deprecated
            public Generator<T> toGenerator() {
                return actual != null ? actual : this;
            }

            @Override
            public long randomSeedHint() {
                return DistributionRandomizer.toSeed(clazz) ^ 0x1337CAFEL;
            }
        }
        return new TypedGenerator();
    }
}

