/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure;

import java.util.function.LongFunction;
import org.cthul.fixsure.GeneratorException;
import org.cthul.fixsure.SequenceLength;
import org.cthul.fixsure.Template;
import org.cthul.fixsure.Typed;
import org.cthul.fixsure.api.AbstractStringify;
import org.cthul.fixsure.api.Factory;
import org.cthul.fixsure.fluents.FlGenerator;
import org.cthul.fixsure.fluents.FlSequence;
import org.cthul.fixsure.generators.AnonymousSequence;
import org.cthul.fixsure.generators.CopyableGenerator;
import org.cthul.fixsure.generators.GeneratorTools;

public interface Sequence<T>
extends Template<T>,
SequenceLength {
    public T value(long var1);

    @Override
    default public FlGenerator<T> newGenerator() {
        class SequenceElements
        extends AbstractStringify
        implements CopyableGenerator<T> {
            private final Class<T> type;
            private long index;

            SequenceElements() {
                this.type = Typed.typeOf(Sequence.this);
                this.index = 0L;
            }

            @Override
            public T next() {
                if (Sequence.this.isUnbounded()) {
                    if (this.index < 0L && !Sequence.this.negativeIndices()) {
                        this.index = 0L;
                    }
                } else if (this.index >= Sequence.this.length()) {
                    throw new GeneratorException(new IndexOutOfBoundsException("" + this.index));
                }
                return Sequence.this.value(this.index++);
            }

            @Override
            public Class<T> getValueType() {
                return this.type;
            }

            @Override
            public CopyableGenerator<T> copy() {
                SequenceElements copy = new SequenceElements();
                copy.index = this.index;
                return copy;
            }

            @Override
            public long randomSeedHint() {
                return GeneratorTools.getRandomSeedHint(Sequence.this);
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                return Sequence.this.toString(sb).append('[').append(this.index).append(']');
            }
        }
        return new SequenceElements();
    }

    @Override
    default public FlSequence<T> fluentData() {
        return Sequence.sequence(this, this::value);
    }

    public static <T> FlSequence<T> sequence(SequenceLength length, LongFunction<T> function) {
        return Sequence.sequence(SequenceLength.toLong(length), function);
    }

    @Factory
    public static <T> FlSequence<T> sequence(LongFunction<T> function) {
        return Sequence.sequence(-1L, function);
    }

    @Factory
    public static <T> FlSequence<T> sequence(long length, LongFunction<T> function) {
        Class clazz = Typed.typeOf(function);
        return Sequence.sequence(clazz, length, function);
    }

    @Factory
    public static <T> FlSequence<T> sequence(final Class<T> clazz, final long length, final LongFunction<T> function) {
        class TypedSequence
        extends AnonymousSequence<T> {
            public TypedSequence() {
                super(l);
            }

            @Override
            public T value(long n) {
                this.assertInRange(n);
                return function.apply(n);
            }

            @Override
            public Class<T> getValueType() {
                return clazz;
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                return GeneratorTools.lambdaToString(function, sb);
            }
        }
        return new TypedSequence();
    }
}

