/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure;

public interface SequenceLength {
    public static final long L_UNBOUNDED = -1L;
    public static final long L_NEGATIVE_INDICES = -2L;
    public static final SequenceLength UNBOUNDED = () -> -1L;
    public static final SequenceLength NEGATIVE_INDICES = () -> -2L;

    public long length();

    default public boolean isUnbounded() {
        return this.length() <= -1L;
    }

    default public boolean negativeIndices() {
        return this.length() <= -2L;
    }

    public static boolean isInRange(long index, SequenceLength length) {
        if (index < 0L) {
            return length.negativeIndices();
        }
        if (length.isUnbounded()) {
            return true;
        }
        return index < length.length();
    }

    public static long toLong(SequenceLength length) {
        if (length.isUnbounded()) {
            return length.negativeIndices() ? -2L : -1L;
        }
        return length.length();
    }

    public static SequenceLength min(SequenceLength a, SequenceLength b) {
        if (a.isUnbounded()) {
            if (b.negativeIndices()) {
                return a;
            }
            return b;
        }
        if (b.isUnbounded()) {
            return a;
        }
        return a.length() < b.length() ? a : b;
    }
}

