/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.distributions;

import java.util.Random;
import java.util.function.LongSupplier;
import org.cthul.fixsure.api.Factory;
import org.cthul.fixsure.distributions.AbstractDistribution;
import org.cthul.fixsure.distributions.AbstractDistributionRandom;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.fluents.FlDistribution;

public class GaussianDistribution
extends AbstractDistribution {
    private static final GaussianDistribution INSTANCE = new GaussianDistribution(DistributionRandomizer.toSeed(GaussianDistribution.class), DistributionRandomizer.getGlobal().getSeedSupplier());

    @Factory
    public static GaussianDistribution normalDistribution() {
        return INSTANCE;
    }

    @Factory
    public static GaussianDistribution normal() {
        return INSTANCE;
    }

    @Factory
    public static GaussianDistribution normalDistribution(long seed) {
        return new GaussianDistribution(seed);
    }

    @Factory
    public static GaussianDistribution normal(long seed) {
        return new GaussianDistribution(seed);
    }

    public GaussianDistribution(LongSupplier seedSupplier) {
        super(seedSupplier);
    }

    public GaussianDistribution(long seed) {
        super(seed);
    }

    public GaussianDistribution(long seed, LongSupplier seedSupplier) {
        super(seed, seedSupplier);
    }

    protected GaussianDistribution(AbstractDistribution source) {
        super(source);
    }

    @Override
    protected FlDistribution.FlRandom newRandom(long seed) {
        return new GDRandom(seed);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        return super.toString(sb.append("Normal "));
    }

    protected static class GDRandom
    extends AbstractDistributionRandom {
        public GDRandom(long seed) {
            super(seed);
        }

        @Override
        protected double nextValue(Random rnd) {
            double d = 0.5 + rnd.nextGaussian() / 4.0;
            if (d < 0.0) {
                return 0.0;
            }
            if (d >= 1.0) {
                return Math.nextDown(1.0);
            }
            return d;
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            return super.toString(sb.append("Normal "));
        }
    }
}

