/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.distributions;

import java.util.Random;
import java.util.function.LongSupplier;
import org.cthul.fixsure.api.Factory;
import org.cthul.fixsure.distributions.AbstractDistribution;
import org.cthul.fixsure.distributions.AbstractDistributionRandom;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.fluents.FlDistribution;

public class UniformDistribution
extends AbstractDistribution {
    private static final UniformDistribution INSTANCE = new UniformDistribution(DistributionRandomizer.toSeed(UniformDistribution.class), DistributionRandomizer.getGlobal().getSeedSupplier());

    @Factory
    public static UniformDistribution uniformDistribution() {
        return INSTANCE;
    }

    @Factory
    public static UniformDistribution uniform() {
        return INSTANCE;
    }

    @Factory
    public static UniformDistribution uniformDistribution(long seed) {
        return new UniformDistribution(seed);
    }

    @Factory
    public static UniformDistribution uniform(long seed) {
        return new UniformDistribution(seed);
    }

    public UniformDistribution(LongSupplier seedSupplier) {
        super(seedSupplier);
    }

    public UniformDistribution(long seed) {
        super(seed);
    }

    public UniformDistribution(long seed, LongSupplier seedSupplier) {
        super(seed, seedSupplier);
    }

    protected UniformDistribution(AbstractDistribution source) {
        super(source);
    }

    @Override
    protected FlDistribution.FlRandom newRandom(long seed) {
        return new UDRandom(seed);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        return super.toString(sb.append("Uniform "));
    }

    protected static class UDRandom
    extends AbstractDistributionRandom {
        public UDRandom(long seed) {
            super(seed);
        }

        @Override
        protected double nextValue(Random rnd) {
            return rnd.nextDouble();
        }

        @Override
        public int nextInt() {
            return this.rnd().nextInt();
        }

        @Override
        public int nextPositiveInt() {
            return this.rnd().nextInt() >>> 1;
        }

        @Override
        public int nextInt(int n) {
            return this.rnd().nextInt(n);
        }

        @Override
        public long nextLong() {
            return this.rnd().nextLong();
        }

        @Override
        public long nextPositiveLong() {
            return this.rnd().nextLong() >>> 1;
        }

        @Override
        public long nextLong(long n) {
            return this.nextPositiveLong() % n;
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            return super.toString(sb.append("Uniform "));
        }
    }
}

