/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.factory;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.factory.DefaultNewFactory;
import org.cthul.fixsure.factory.Factories;
import org.cthul.fixsure.factory.FactoriesSetup;
import org.cthul.fixsure.factory.Factory;
import org.cthul.fixsure.factory.FactoryParent;
import org.cthul.fixsure.factory.ValueGenerator;
import org.cthul.fixsure.factory.ValueSource;
import org.cthul.fixsure.fluents.FlGenerator;

public class DefaultFactories
implements Factories,
FactoryParent {
    private final Map<String, DataSource<?>> sources = new HashMap();
    private final Map<String, Factory<?>> factories = new HashMap();
    private final Map<String, FlGenerator<?>> generators = new HashMap();
    private static final AtomicLong UNIQUE = new AtomicLong(0L);

    @org.cthul.fixsure.api.Factory
    public static FactoriesSetup newFactoriesSetup() {
        return new Setup();
    }

    @Override
    public <T> FlGenerator<T> generator(String key) {
        FlGenerator gen = this.generators.computeIfAbsent(key, this::newGenerator);
        if (gen != null) {
            return gen;
        }
        throw new IllegalArgumentException(key);
    }

    protected FlGenerator<?> newGenerator(String key) {
        DataSource<?> src = this.sources.get(key);
        if (src == null) {
            return null;
        }
        return src.toGenerator().fluentData();
    }

    @Override
    public <T> Factory<T> factory(String key) {
        Factory<?> fac = this.factories.get(key);
        if (fac != null) {
            return fac;
        }
        throw new IllegalArgumentException(key);
    }

    @Override
    public <T> ValueGenerator<T> peekGenerator(String key) {
        Factory<?> factory = this.factories.get(key);
        if (factory != null) {
            return factory.generate().asValueGenerator();
        }
        FlGenerator gen = this.generators.computeIfAbsent(key, this::newGenerator);
        if (gen != null) {
            return ValueGenerator.fromGenerator(gen);
        }
        return null;
    }

    @Override
    public <T> ValueSource<T> peekSource(String key, boolean useDefault) {
        if (!useDefault) {
            return null;
        }
        if (this.peekGenerator(key) == null) {
            return null;
        }
        return f -> this.peekGenerator(key);
    }

    @Override
    public Map<String, String> getDescriptionForChild() {
        return new HashMap<String, String>();
    }

    @Override
    public void reset() {
        this.generators.clear();
        this.factories.values().forEach(Factory::reset);
    }

    static long uniqueId() {
        return UNIQUE.getAndIncrement();
    }

    static String uniqueIdStr() {
        return Long.toHexString(DefaultFactories.uniqueId());
    }

    static String anonymousKey() {
        return "<anonymous>@" + DefaultFactories.uniqueIdStr();
    }

    protected static <T> BiConsumer<Object, T> defaultSetter(Class<?> clazz, String key) {
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.getName().equals(key)) continue;
            return DefaultFactories.fieldSetter(f);
        }
        Class<?> sup = clazz.getSuperclass();
        if (sup != null) {
            return DefaultFactories.defaultSetter(sup, key);
        }
        throw new IllegalArgumentException(key);
    }

    private static <T> BiConsumer<Object, T> fieldSetter(Field f) {
        return (object, value) -> {
            try {
                f.setAccessible(true);
                f.set(object, value);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static class Setup
    implements FactoriesSetup {
        private final DefaultFactories factories = new DefaultFactories();

        @Override
        public FactoriesSetup add(String key, DataSource<?> dataSource) {
            this.factories.sources.put(key, dataSource);
            return this;
        }

        @Override
        public FactoriesSetup add(String key, Factory<?> factory) {
            this.factories.sources.put(key, factory);
            this.factories.factories.put(key, factory);
            return this;
        }

        @Override
        public <T> FactoriesSetup.NewFactory<T> newFactory(String key, Class<T> clazz) {
            return new DefaultNewFactory<T>(this, key, clazz);
        }

        @Override
        public DefaultFactories toFactories() {
            return this.factories;
        }
    }
}

