/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.factory.FactoriesSetup;
import org.cthul.fixsure.factory.Factory;
import org.cthul.fixsure.factory.FactoryBase;
import org.cthul.fixsure.factory.FactoryParent;
import org.cthul.fixsure.factory.ValueGenerator;
import org.cthul.fixsure.factory.ValueSource;
import org.cthul.fixsure.fluents.FlGenerator;

public class DefaultFactory<V>
extends FactoryBase
implements Factory<V>,
Factory.FactoryGenerator<V> {
    private final Set<String> recursionGuard = new LinkedHashSet<String>();
    private final VM vm = new VM(this);
    private final String key;
    private final Class<V> clazz;
    private final List<BiFunction<? super V, ? super ValueGenerator.ValueMap, ? extends V>> steps;

    public DefaultFactory(FactoryParent parent, String key, Class<V> clazz) {
        super(parent);
        this.key = key;
        this.clazz = clazz;
        this.steps = new ArrayList<BiFunction<? super V, ? super ValueGenerator.ValueMap, ? extends V>>();
    }

    protected DefaultFactory(DefaultFactory parent) {
        super(parent);
        this.key = parent.key;
        this.clazz = parent.clazz;
        this.steps = parent.steps;
    }

    @Override
    public V create() {
        return this.next();
    }

    @Override
    public Class<V> getValueType() {
        return this.clazz;
    }

    @Override
    public DefaultFactory<V> generate() {
        this.initialize();
        DefaultFactory<V> generator = new DefaultFactory<V>(this);
        generator.initialize();
        return generator;
    }

    protected DefaultFactory<V> copy(ValueSource.FactoryMap factoryMap) {
        return this.generate();
    }

    @Override
    protected ValueSource.FactoryMap getFactoryMap() {
        return this.vm;
    }

    protected void addStep(BiFunction<? super V, ? super ValueGenerator.ValueMap, ? extends V> step) {
        this.steps.add(step);
    }

    @Override
    public String toString() {
        return this.key + "(" + super.toString() + ")";
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        return sb.append(this.key).append("(").append(super.toString()).append(")");
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public V next() {
        return this.next(new VM(this));
    }

    protected V next(ValueGenerator.ValueMap valueMap) {
        this.initialize();
        Object value = null;
        for (BiFunction<V, ValueGenerator.ValueMap, V> step : this.steps) {
            value = step.apply(value, valueMap);
        }
        return (V)value;
    }

    @Override
    public Factory.Include<V> asInclude() {
        return new Factory.Include<V>(){

            @Override
            public void reset() {
                DefaultFactory.this.reset();
            }

            @Override
            public ValueSource<?> attributeSource(String key, boolean useDefault) {
                return DefaultFactory.this.peekSource(key, useDefault);
            }

            @Override
            public ValueGenerator<? extends V> generate(ValueSource.FactoryMap factoryMap) {
                return ((DefaultFactory)DefaultFactory.this.generate()).asIncludedGenerator();
            }

            @Override
            public Class<V> getValueType() {
                return DefaultFactory.this.getValueType();
            }

            public String toString() {
                return DefaultFactory.this.toString();
            }
        };
    }

    @Override
    public ValueGenerator<V> asValueGenerator() {
        return new ValueGenerator<V>(){

            @Override
            public V next(ValueGenerator.ValueMap valueMap) {
                return DefaultFactory.this.next();
            }

            @Override
            public V next(ValueGenerator.ValueMap valueMap, Function<ValueGenerator.ValueMap, ValueGenerator.ValueMap> transform) {
                return DefaultFactory.this.next(transform.apply(new VM(DefaultFactory.this)));
            }

            @Override
            public ValueGenerator<V> link(ValueSource.FactoryMap factoryMap) {
                return DefaultFactory.this.copy(factoryMap).asValueGenerator();
            }

            @Override
            public <V, B> FactoriesSetup.ValueDeclaration<V, B> set(String key, B builder) {
                return DefaultFactory.this.set(key, builder);
            }

            @Override
            public Class<V> getValueType() {
                return DefaultFactory.this.getValueType();
            }

            public String toString() {
                return DefaultFactory.this.toString();
            }
        };
    }

    public ValueGenerator<V> asIncludedGenerator() {
        return new ValueGenerator<V>(){

            @Override
            public V next(ValueGenerator.ValueMap valueMap) {
                return DefaultFactory.this.next(valueMap);
            }

            @Override
            public ValueGenerator<V> link(ValueSource.FactoryMap factoryMap) {
                return DefaultFactory.this.copy(factoryMap).asIncludedGenerator();
            }

            @Override
            public <V, B> FactoriesSetup.ValueDeclaration<V, B> set(String key, B builder) {
                return DefaultFactory.this.set(key, builder);
            }

            @Override
            public Class<V> getValueType() {
                return DefaultFactory.this.getValueType();
            }

            public String toString() {
                return DefaultFactory.this.toString();
            }
        };
    }

    @Override
    public Factory.FactoryGenerator<V> set(Object ... keyValues) {
        int i = 0;
        while (i + 1 < keyValues.length) {
            String key = String.valueOf(keyValues[i]);
            Object val = keyValues[i + 1];
            if (val instanceof DataSource) {
                this.set(key).to((DataSource)val);
            } else {
                this.set(key).to(val);
            }
            i += 2;
        }
        return this;
    }

    @Override
    public <T> FactoriesSetup.ValueDeclaration<T, Factory.FactoryGenerator<V>> set(String key) {
        return this.set(key, this);
    }

    public static class Setup<V>
    implements FactoriesSetup.FactorySetup<V> {
        private final FactoriesSetup factoriesSetup;
        private final DefaultFactory<V> factory;

        public Setup(FactoriesSetup factoriesSetup, FactoryParent factories, String key, Class<V> clazz) {
            this.factoriesSetup = factoriesSetup;
            this.factory = new DefaultFactory<V>(factories, key, clazz);
            factoriesSetup.add(key, (Factory<?>)this.factory);
        }

        public Setup(FactoryParent factories, String key, Class<V> clazz) {
            this.factoriesSetup = null;
            this.factory = new DefaultFactory<V>(factories, key, clazz);
        }

        public DefaultFactory<V> getFactory() {
            return this.factory;
        }

        @Override
        public FactoriesSetup factoriesSetup() {
            return this.factoriesSetup;
        }

        @Override
        public Class<V> getValueType() {
            return this.factory.getValueType();
        }

        @Override
        public FactoriesSetup.FactorySetup<V> applyValues(BiFunction<? super V, ? super ValueGenerator.ValueMap, ? extends V> function) {
            ((DefaultFactory)this.factory).steps.add(function);
            return this;
        }

        @Override
        public FactoriesSetup.FactorySetup<V> assignValues(String key, ValueSource<?> valueSource) {
            this.factory.putValueSource(key, valueSource);
            return this;
        }

        @Override
        public FactoriesSetup.FactorySetup<V> include(String key, Factory.Include<?> include) {
            this.factory.addInclude(key, include);
            return this;
        }

        public String toString() {
            return this.factory.toString();
        }
    }

    protected static class VM
    implements ValueGenerator.ValueMap,
    ValueSource.FactoryMap {
        private final DefaultFactory owner;
        private final Map<String, Object> values = new HashMap<String, Object>();

        public VM(DefaultFactory owner) {
            this.owner = owner;
        }

        public void clear() {
            this.values.clear();
        }

        @Override
        public <T> T get(String key) {
            Object v = this.values.get(key);
            if (v == null) {
                v = this.computeValue(key);
                this.values.put(key, v);
            }
            return (T)v;
        }

        protected Set<String> recursionGuard() {
            return this.owner.recursionGuard;
        }

        protected Object computeValue(String key) {
            if (!this.recursionGuard().add(key)) {
                throw new IllegalArgumentException("recursion: " + key + " --> " + this.owner.recursionGuard);
            }
            try {
                Object t = this.peekOwnerValueGenerator(key).next(this);
                return t;
            }
            finally {
                this.recursionGuard().remove(key);
            }
        }

        @Override
        public <T> FlGenerator<T> generator(String key) {
            return ValueGenerator.toGenerator(this.valueGenerator(key), this);
        }

        @Override
        public <T> Factory<T> factory(String key) {
            ValueGenerator gen = this.valueGenerator(key);
            DefaultFactory<T> fac = new DefaultFactory<T>(this.owner, key, gen.getValueType());
            ((DefaultFactory)fac).steps.add((v, vm) -> gen.next((ValueGenerator.ValueMap)vm));
            return fac;
        }

        @Override
        public <T> ValueGenerator<T> valueGenerator(String key) {
            return ValueGenerator.ValueMap.super.valueGenerator(key);
        }

        @Override
        public <T> ValueGenerator<T> peekValueGenerator(String key) {
            if (!this.recursionGuard().add(key)) {
                ValueGenerator gen = this.owner.peekParentGenerator(key);
                if (gen != null) {
                    return gen;
                }
                throw new IllegalArgumentException("recursion: " + key + " --> " + this.recursionGuard());
            }
            try {
                ValueGenerator<T> valueGenerator = this.peekOwnerValueGenerator(key);
                return valueGenerator;
            }
            finally {
                this.recursionGuard().remove(key);
            }
        }

        protected <T> ValueGenerator<T> peekOwnerValueGenerator(String key) {
            return this.owner.internPeekGenerator(key);
        }

        @Override
        public void reset() {
            throw new IllegalStateException("Cannot reset internal Factories");
        }
    }
}

