/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.factory;

import java.lang.reflect.Constructor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.cthul.fixsure.factory.DefaultFactories;
import org.cthul.fixsure.factory.DefaultFactory;
import org.cthul.fixsure.factory.FactoriesSetup;
import org.cthul.fixsure.factory.Factory;
import org.cthul.fixsure.factory.ValueGenerator;
import org.cthul.fixsure.factory.ValueSource;

public class DefaultNewFactory<R>
implements FactoriesSetup.NewFactory<R> {
    private final DefaultFactories.Setup factories;
    private final DefaultFactory.Setup<R> factorySetup;

    public DefaultNewFactory(DefaultFactories.Setup setup, String key, Class<R> clazz) {
        this.factories = setup;
        this.factorySetup = new DefaultFactory.Setup<R>(this.factories, this.factories.toFactories(), key, clazz);
    }

    @Override
    public FactoriesSetup factoriesSetup() {
        return this.factories;
    }

    @Override
    public Class<R> getValueType() {
        return this.factorySetup.getValueType();
    }

    @Override
    public FactoriesSetup.NewFactory<R> assignValues(String key, ValueSource<?> valueSource) {
        this.factorySetup.assignValues(key, (ValueSource)valueSource);
        return this;
    }

    @Override
    public FactoriesSetup.NewFactory<R> include(String key, Factory.Include<?> include) {
        this.factorySetup.include(key, (Factory.Include)include);
        return this;
    }

    @Override
    public <B> FactoriesSetup.BuilderSetup<B, R> builder(Function<? super ValueGenerator.ValueMap, ? extends B> newBuilder) {
        String key = this.factorySetup.toString() + "/builder@" + DefaultFactories.uniqueIdStr();
        return new Builder<B>(key, newBuilder);
    }

    @Override
    public FactoriesSetup.FactorySetup<R> build(Supplier<? extends R> builder) {
        this.factorySetup.applyValues((T v, U vm) -> builder.get());
        return this.factorySetup;
    }

    @Override
    public FactoriesSetup.FactorySetup<R> build(Function<? super ValueGenerator.ValueMap, ? extends R> builder) {
        this.factorySetup.applyValues((T v, U vm) -> builder.apply((ValueGenerator.ValueMap)vm));
        return this.factorySetup;
    }

    @Override
    public FactoriesSetup.FactorySetup<R> extend(Factory<R> factory) {
        return this.extend("@extend", factory);
    }

    @Override
    public FactoriesSetup.FactorySetup<R> extend(String key) {
        Factory f = this.factories.toFactories().factory(key);
        return this.extend("@extend/" + key, f);
    }

    public FactoriesSetup.FactorySetup<R> extend(String key, Factory<?> factory) {
        String uniqKey = key + "@" + DefaultFactories.uniqueIdStr();
        this.factorySetup.assign(uniqKey).include(factory);
        this.factorySetup.applyValues((T v, U vm) -> vm.get(uniqKey));
        return this.factorySetup;
    }

    protected static class NewInstance<T>
    implements Supplier<T> {
        private final Constructor<T> constructor;

        public NewInstance(Class<T> clazz) {
            try {
                this.constructor = clazz.getConstructor(new Class[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public T get() {
            try {
                return this.constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    class Builder<B>
    implements FactoriesSetup.BuilderSetup<B, R> {
        private final String key;
        private final DefaultFactory.Setup<B> builderSetup;

        public Builder(String key, Function<? super ValueGenerator.ValueMap, ? extends B> newBuilder) {
            this.key = key;
            this.builderSetup = new DefaultFactory.Setup(DefaultNewFactory.this.factories.toFactories(), key, null);
            this.builderSetup.applyValues((T v, U vm) -> newBuilder.apply((ValueGenerator.ValueMap)vm));
        }

        @Override
        public FactoriesSetup.FactorySetup<R> build(BiFunction<? super B, ? super ValueGenerator.ValueMap, ? extends R> buildFunction) {
            String theKey = this.key;
            DefaultNewFactory.this.factorySetup.include(theKey, this.builderSetup.getFactory());
            DefaultNewFactory.this.factorySetup.applyValues((T v, U vm) -> buildFunction.apply((Object)vm.get(theKey), (ValueGenerator.ValueMap)vm));
            return DefaultNewFactory.this.factorySetup;
        }

        @Override
        public Class<B> getValueType() {
            return this.builderSetup.getValueType();
        }

        @Override
        public FactoriesSetup.BuilderSetup<B, R> applyValues(BiFunction<? super B, ? super ValueGenerator.ValueMap, ? extends B> function) {
            this.builderSetup.applyValues(function);
            return this;
        }

        @Override
        public FactoriesSetup.BuilderSetup<B, R> assignValues(String key, ValueSource<?> valueSource) {
            this.builderSetup.assignValues(key, (ValueSource)valueSource);
            return this;
        }

        @Override
        public FactoriesSetup.BuilderSetup<B, R> include(String key, Factory.Include<?> include) {
            this.builderSetup.include(key, (Factory.Include)include);
            return this;
        }
    }
}

