/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.factory;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.Supplier;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.Sequence;
import org.cthul.fixsure.Typed;
import org.cthul.fixsure.factory.DefaultFactories;
import org.cthul.fixsure.factory.DefaultNewFactory;
import org.cthul.fixsure.factory.Factories;
import org.cthul.fixsure.factory.Factory;
import org.cthul.fixsure.factory.ValueGenerator;
import org.cthul.fixsure.factory.ValueSource;
import org.cthul.fixsure.fluents.BiDataSource;

public interface FactoriesSetup {
    public FactoriesSetup add(String var1, DataSource<?> var2);

    default public FactoriesSetup add(String key, Supplier<? extends DataSource<?>> dataSupplier) {
        DataSource ds = () -> ((DataSource)dataSupplier.get()).toGenerator();
        return this.add(key, ds);
    }

    default public <T> FactoriesSetup add(Typed<T> token, DataSource<? extends T> dataSource) {
        return this.add(token.toString(), dataSource);
    }

    default public <T> FactoriesSetup add(Typed<T> token, Supplier<? extends DataSource<? extends T>> dataSupplier) {
        return this.add(token.toString(), dataSupplier);
    }

    public FactoriesSetup add(String var1, Factory<?> var2);

    default public <T> FactoriesSetup add(Class<T> key, Factory<T> factory) {
        return this.add(key.getName(), factory);
    }

    default public <T> FactoriesSetup add(Typed<T> key, Factory<T> factory) {
        return this.add(key.toString(), factory);
    }

    public <T> NewFactory<T> newFactory(String var1, Class<T> var2);

    default public <T> NewFactory<T> newFactory(Class<T> clazz) {
        return this.newFactory(clazz.getName(), clazz);
    }

    default public <T> NewFactory<T> newFactory(Typed<T> token, Class<T> clazz) {
        return this.newFactory(token.toString(), clazz);
    }

    default public <T> NewFactory<T> newFactory(Typed<T> token) {
        return this.newFactory(token.toString(), token.getValueType());
    }

    default public <T> NewBuilder<T> newFactory(String key) {
        return this.newFactory(key, (Class)null);
    }

    public Factories toFactories();

    public static interface FactoryValueSetup<R, T>
    extends ValueDeclaration<T, FactorySetup<R>>,
    FactorySetup<R> {
        public FactorySetup<R> factorySetup();

        @Override
        default public FactoriesSetup factoriesSetup() {
            return this.factorySetup().factoriesSetup();
        }

        @Override
        default public <T> ValueDeclaration<T, ? extends FactorySetup<R>> assign(String key) {
            return this.factorySetup().assign(key);
        }

        @Override
        default public FactorySetup<R> applyValues(BiFunction<? super R, ? super ValueGenerator.ValueMap, ? extends R> function) {
            return (FactorySetup)this.factorySetup().applyValues(function);
        }

        @Override
        default public Class<R> getValueType() {
            return this.factorySetup().getValueType();
        }

        @Override
        default public FactorySetup<R> assignValues(String key, ValueSource<?> valueSource) {
            return (FactorySetup)this.factorySetup().assignValues(key, (ValueSource)valueSource);
        }

        @Override
        default public FactorySetup<R> include(String key, Factory.Include<?> include) {
            return (FactorySetup)this.factorySetup().include(key, (Factory.Include)include);
        }
    }

    public static interface BuilderValueSetup<B, R, T>
    extends ValueDeclaration<T, BuilderSetup<B, R>>,
    BuilderSetup<B, R> {
        public BuilderSetup<B, R> builderSetup();

        @Override
        default public FactorySetup<R> build(BiFunction<? super B, ? super ValueGenerator.ValueMap, ? extends R> buildFunction) {
            return this.builderSetup().build(buildFunction);
        }

        @Override
        default public BuilderSetup<B, R> applyValues(BiFunction<? super B, ? super ValueGenerator.ValueMap, ? extends B> function) {
            return (BuilderSetup)this.builderSetup().applyValues(function);
        }

        @Override
        default public BuilderSetup<B, R> assignValues(String key, ValueSource<?> valueSource) {
            return (BuilderSetup)this.builderSetup().assignValues(key, (ValueSource)valueSource);
        }

        @Override
        default public BuilderSetup<B, R> include(String key, Factory.Include<?> include) {
            return (BuilderSetup)this.builderSetup().include(key, (Factory.Include)include);
        }

        @Override
        default public Class<B> getValueType() {
            return this.builderSetup().getValueType();
        }
    }

    public static interface ValueDeclaration<T, BuilderSetup> {
        public BuilderSetup toValuesOf(ValueSource<? extends T> var1);

        default public BuilderSetup toValues(ValueGenerator<? extends T> valueGenerator) {
            return this.toValuesOf(ValueSource.fromGenerator(valueGenerator));
        }

        default public BuilderSetup to(Function<? super ValueGenerator.ValueMap, ? extends T> valueFunction) {
            return this.toValuesOf(ValueSource.fromFunction(valueFunction));
        }

        default public BuilderSetup to(DataSource<? extends T> dataSource) {
            return this.toValuesOf(ValueSource.fromDataSource(dataSource));
        }

        default public BuilderSetup to(Supplier<? extends DataSource<? extends T>> dataSupplier) {
            return this.toValuesOf(ValueSource.fromDataSupply(dataSupplier));
        }

        default public BuilderSetup to(T value) {
            return this.toValuesOf(ValueSource.constant(value));
        }

        default public BuilderSetup toNext(String key) {
            return this.toValuesOf(ValueSource.nextKey(key));
        }

        default public BuilderSetup toNext(Class<?> clazz) {
            return this.toNext(clazz.getName());
        }

        default public BuilderSetup toNext(Generator<? extends T> generator) {
            return this.to((T)generator);
        }

        default public BuilderSetup toNext(LongFunction<? extends T> sequence) {
            return this.to((T)Sequence.sequence(-1L, sequence));
        }

        default public BuilderSetup toValueOf(String key) {
            return this.toValuesOf(ValueSource.getKey(key));
        }

        public BuilderSetup include(Factory.Include<? extends T> var1);

        default public BuilderSetup include(Factory<? extends T> factory) {
            return this.include(factory.generate().asInclude());
        }

        default public BuilderSetup include(String key) {
            return this.include((Factory.Include)null);
        }
    }

    public static interface NewFactory<R>
    extends FactorySetup<R>,
    NewBuilder<R> {
        @Override
        default public FactoriesSetup factoriesSetup() {
            return this.useDefaultConstructor().factoriesSetup();
        }

        default public FactorySetup<R> useDefaultConstructor() {
            return this.build(new DefaultNewFactory.NewInstance(this.getValueType()));
        }

        @Override
        default public FactorySetup<R> applyValues(BiFunction<? super R, ? super ValueGenerator.ValueMap, ? extends R> function) {
            return (FactorySetup)this.useDefaultConstructor().applyValues(function);
        }

        @Override
        default public <T> ValueDeclaration<T, NewFactory<R>> assign(String key) {
            return FactorySetup.super.assign(key);
        }

        @Override
        default public <T> ValueDeclaration<T, NewFactory<R>> assign(Typed<T> token) {
            return FactorySetup.super.assign(token);
        }

        @Override
        default public ValueDeclaration<BiDataSource.Pair<?, ?>, NewFactory<R>> assign(String id1, String id2) {
            return FactorySetup.super.assign(id1, id2);
        }

        @Override
        public NewFactory<R> assignValues(String var1, ValueSource<?> var2);

        @Override
        default public NewFactory<R> assign(String id1, String id2, BiDataSource<?, ?> dataSource) {
            return (NewFactory)FactorySetup.super.assign(id1, id2, (BiDataSource)dataSource);
        }

        @Override
        default public <T, U> ValueDeclaration<BiDataSource.Pair<T, U>, NewFactory<R>> assign(Typed<T> token1, Typed<U> token2) {
            return this.assign(token1.toString(), token2.toString());
        }

        @Override
        default public <T, U> NewFactory<R> assign(Typed<T> token1, Typed<U> token2, BiDataSource<? extends T, ? extends U> dataSource) {
            return this.assign(token1.toString(), token2.toString(), (BiDataSource)dataSource);
        }

        @Override
        public NewFactory<R> include(String var1, Factory.Include<?> var2);

        @Override
        default public NewFactory<R> include(String key, Factory<?> factory) {
            return (NewFactory)FactorySetup.super.include(key, (Factory)factory);
        }

        @Override
        default public NewFactory<R> include(String key, String factoryKey) {
            return (NewFactory)FactorySetup.super.include(key, factoryKey);
        }
    }

    public static interface NewBuilder<R>
    extends ValueSetupBase<R> {
        default public FactorySetup<R> build(Supplier<? extends R> builder) {
            return this.build((? super ValueGenerator.ValueMap vm) -> builder.get());
        }

        default public <B> BuilderSetup<B, R> with(Supplier<? extends B> newBuilder) {
            return this.builder(vm -> newBuilder.get());
        }

        default public FactorySetup<R> build(Function<? super ValueGenerator.ValueMap, ? extends R> builder) {
            return this.builder(builder).build(Function.identity());
        }

        public <B> BuilderSetup<B, R> builder(Function<? super ValueGenerator.ValueMap, ? extends B> var1);

        public FactorySetup<R> extend(Factory<R> var1);

        public FactorySetup<R> extend(String var1);

        default public FactorySetup<R> extend(Class<R> clazz) {
            return this.extend(clazz.getName());
        }

        @Override
        default public <T> ValueDeclaration<T, ? extends NewBuilder<R>> assign(String key) {
            return ValueSetupBase.super.assign(key);
        }

        @Override
        default public <T> ValueDeclaration<T, ? extends NewBuilder<R>> assign(Typed<T> token) {
            return ValueSetupBase.super.assign(token);
        }

        @Override
        default public ValueDeclaration<BiDataSource.Pair<?, ?>, ? extends NewBuilder<R>> assign(String id1, String id2) {
            return ValueSetupBase.super.assign(id1, id2);
        }

        @Override
        public NewBuilder<R> assignValues(String var1, ValueSource<?> var2);

        @Override
        default public NewBuilder<R> assign(String id1, String id2, BiDataSource<?, ?> dataSource) {
            return (NewBuilder)ValueSetupBase.super.assign(id1, id2, dataSource);
        }

        @Override
        default public <T, U> ValueDeclaration<BiDataSource.Pair<T, U>, ? extends NewBuilder<R>> assign(Typed<T> token1, Typed<U> token2) {
            return this.assign(token1.toString(), token2.toString());
        }

        @Override
        default public <T, U> NewBuilder<R> assign(Typed<T> token1, Typed<U> token2, BiDataSource<? extends T, ? extends U> dataSource) {
            return this.assign(token1.toString(), token2.toString(), (BiDataSource)dataSource);
        }

        @Override
        public NewBuilder<R> include(String var1, Factory.Include<?> var2);

        @Override
        default public NewBuilder<R> include(String key, Factory<?> factory) {
            return (NewBuilder)ValueSetupBase.super.include(key, factory);
        }

        @Override
        default public NewBuilder<R> include(String key, String factoryKey) {
            return (NewBuilder)ValueSetupBase.super.include(key, factoryKey);
        }
    }

    public static interface FactorySetup<R>
    extends BuilderSetupBase<R, FactorySetup<R>>,
    FactoriesSetup {
        public FactoriesSetup factoriesSetup();

        @Override
        default public FactoriesSetup add(String key, DataSource<?> dataSource) {
            return this.factoriesSetup().add(key, dataSource);
        }

        @Override
        default public FactoriesSetup add(String key, Factory<?> factory) {
            return this.factoriesSetup().add(key, factory);
        }

        @Override
        default public <T> NewFactory<T> newFactory(String key, Class<T> clazz) {
            return this.factoriesSetup().newFactory(key, clazz);
        }

        @Override
        default public Factories toFactories() {
            return this.factoriesSetup().toFactories();
        }

        @Override
        default public <T> ValueDeclaration<T, ? extends FactorySetup<R>> assign(final String key) {
            return new FactoryValueSetup<R, T>(){

                @Override
                public FactorySetup<R> factorySetup() {
                    return this;
                }

                @Override
                public FactorySetup<R> toValuesOf(ValueSource<? extends T> valueSource) {
                    return (FactorySetup)this.assignValues(key, valueSource);
                }

                @Override
                public FactorySetup<R> include(Factory.Include<? extends T> include) {
                    return (FactorySetup)this.include(key, include);
                }
            };
        }

        @Override
        default public FactoryValueSetup<R, Object> set(String key) {
            return (FactoryValueSetup)BuilderSetupBase.super.set(key);
        }

        @Override
        default public <T> FactoryValueSetup<R, T> set(String key, BiConsumer<? super R, ? super T> setter) {
            return (FactoryValueSetup)BuilderSetupBase.super.set(key, setter);
        }

        @Override
        default public <T> FactoryValueSetup<R, T> set(Typed<T> token) {
            return (FactoryValueSetup)BuilderSetupBase.super.set(token);
        }

        @Override
        default public <T> FactoryValueSetup<R, T> set(Typed<T> token, BiConsumer<? super R, ? super T> setter) {
            return (FactoryValueSetup)BuilderSetupBase.super.set(token, setter);
        }

        @Override
        default public <T> FactoryValueSetup<R, T> apply(String key, BiFunction<? super R, T, ? extends R> setter) {
            return (FactoryValueSetup)BuilderSetupBase.super.apply(key, setter);
        }

        @Override
        default public <T> FactoryValueSetup<R, T> apply(Typed<T> token, BiFunction<? super R, T, ? extends R> setter) {
            return (FactoryValueSetup)BuilderSetupBase.super.apply(token, setter);
        }
    }

    public static interface BuilderSetup<B, R>
    extends BuilderSetupBase<B, BuilderSetup<B, R>> {
        default public FactorySetup<R> build(Function<? super B, ? extends R> buildFunction) {
            return this.build((? super B b, ? super ValueGenerator.ValueMap vm) -> buildFunction.apply((Object)b));
        }

        public FactorySetup<R> build(BiFunction<? super B, ? super ValueGenerator.ValueMap, ? extends R> var1);

        default public <T> BuilderValueSetup<B, R, T> assign(final String key) {
            return new BuilderValueSetup<B, R, T>(){

                @Override
                public BuilderSetup<B, R> builderSetup() {
                    return this;
                }

                @Override
                public BuilderSetup<B, R> toValuesOf(ValueSource<? extends T> valueSource) {
                    return (BuilderSetup)this.assignValues(key, valueSource);
                }

                @Override
                public BuilderSetup<B, R> include(Factory.Include<? extends T> include) {
                    return (BuilderSetup)this.include(key, include);
                }
            };
        }

        default public BuilderValueSetup<B, R, Object> set(String key) {
            return (BuilderValueSetup)BuilderSetupBase.super.set(key);
        }

        default public <T> BuilderValueSetup<B, R, T> set(String key, BiConsumer<? super B, ? super T> setter) {
            return (BuilderValueSetup)BuilderSetupBase.super.set(key, setter);
        }

        default public <T> BuilderValueSetup<B, R, T> apply(String key, BiFunction<? super B, T, ? extends B> setter) {
            return (BuilderValueSetup)BuilderSetupBase.super.apply(key, setter);
        }

        default public <T> BuilderValueSetup<B, R, T> set(Typed<T> token) {
            return (BuilderValueSetup)BuilderSetupBase.super.set(token);
        }

        default public <T> BuilderValueSetup<B, R, T> set(Typed<T> token, BiConsumer<? super B, ? super T> setter) {
            return (BuilderValueSetup)BuilderSetupBase.super.set(token, setter);
        }

        default public <T> BuilderValueSetup<B, R, T> apply(Typed<T> token, BiFunction<? super B, T, ? extends B> setter) {
            return (BuilderValueSetup)BuilderSetupBase.super.apply(token, setter);
        }
    }

    public static interface BuilderSetupBase<B, This extends BuilderSetupBase<B, This>>
    extends ValueSetupBase<B> {
        public This applyValues(BiFunction<? super B, ? super ValueGenerator.ValueMap, ? extends B> var1);

        @Override
        default public <T> ValueDeclaration<T, ? extends This> assign(String key) {
            return ValueSetupBase.super.assign(key);
        }

        @Override
        default public <T> ValueDeclaration<T, ? extends This> assign(Typed<T> token) {
            return ValueSetupBase.super.assign(token);
        }

        @Override
        default public ValueDeclaration<BiDataSource.Pair<?, ?>, ? extends This> assign(String id1, String id2) {
            return ValueSetupBase.super.assign(id1, id2);
        }

        public This assignValues(String var1, ValueSource<?> var2);

        default public This assign(String id1, String id2, BiDataSource<?, ?> dataSource) {
            return (This)((BuilderSetupBase)ValueSetupBase.super.assign(id1, id2, dataSource));
        }

        @Override
        default public <T, U> ValueDeclaration<BiDataSource.Pair<T, U>, ? extends This> assign(Typed<T> token1, Typed<U> token2) {
            return ValueSetupBase.super.assign(token1, token2);
        }

        default public <T, U> This assign(Typed<T> token1, Typed<U> token2, BiDataSource<? extends T, ? extends U> dataSource) {
            return (This)((BuilderSetupBase)ValueSetupBase.super.assign(token1, token2, dataSource));
        }

        public This include(String var1, Factory.Include<?> var2);

        default public This include(String key, Factory<?> factory) {
            return (This)((BuilderSetupBase)ValueSetupBase.super.include(key, factory));
        }

        default public This include(String key, String factoryKey) {
            return (This)((BuilderSetupBase)ValueSetupBase.super.include(key, factoryKey));
        }

        default public ValueDeclaration<Object, This> set(String key) {
            ValueDeclaration decl = this.set(key, DefaultFactories.defaultSetter(this.getValueType(), key));
            decl.toValuesOf(ValueSource.forField(this.getValueType(), key));
            return decl;
        }

        default public <T> ValueDeclaration<T, This> set(String key, BiConsumer<? super B, ? super T> setter) {
            This self = this.applyValues((b, v) -> {
                setter.accept((Object)b, (Object)v.get(key));
                return b;
            });
            return self.assign(key);
        }

        default public <T> ValueDeclaration<T, This> set(Typed<T> token) {
            return this.set(token.toString());
        }

        default public <T> ValueDeclaration<T, This> set(Typed<T> token, BiConsumer<? super B, ? super T> setter) {
            return this.set(token.toString(), setter);
        }

        default public <T> ValueDeclaration<T, This> apply(String key, BiFunction<? super B, T, ? extends B> function) {
            This self = this.applyValues((b, v) -> function.apply((Object)b, v.get(key)));
            return self.assign(key);
        }

        default public <T> ValueDeclaration<T, This> apply(Typed<T> token, BiFunction<? super B, T, ? extends B> function) {
            return this.apply(token.toString(), function);
        }

        default public <T> ValueDeclaration<T, This> set(BiConsumer<? super B, T> setter) {
            return this.set(DefaultFactories.anonymousKey(), setter);
        }

        default public <T> ValueDeclaration<T, This> apply(BiFunction<? super B, T, ? extends B> setter) {
            return this.apply(DefaultFactories.anonymousKey(), setter);
        }

        default public This then(Consumer<? super B> action) {
            return this.applyValues((b, v) -> {
                action.accept((Object)b);
                return b;
            });
        }

        default public This then(BiConsumer<? super B, ? super ValueGenerator.ValueMap> action) {
            return this.applyValues((b, v) -> {
                action.accept((Object)b, (ValueGenerator.ValueMap)v);
                return b;
            });
        }

        default public This thenApply(Function<? super B, ? extends B> action) {
            return this.applyValues((b, v) -> action.apply((Object)b));
        }

        default public This thenApply(BiFunction<? super B, ? super ValueGenerator.ValueMap, ? extends B> action) {
            return this.applyValues(action);
        }
    }

    public static interface ValueSetupBase<B>
    extends Typed<B> {
        default public <T> ValueDeclaration<T, ? extends ValueSetupBase<B>> assign(final String key) {
            return new ValueDeclaration<T, ValueSetupBase<B>>(){

                @Override
                public ValueSetupBase<B> toValuesOf(ValueSource<? extends T> valueSource) {
                    return this.assignValues(key, valueSource);
                }

                @Override
                public ValueSetupBase<B> include(Factory.Include<? extends T> include) {
                    return this.include(key, include);
                }
            };
        }

        default public ValueSetupBase<B> assign(String id1, String id2, BiDataSource<?, ?> dataSource) {
            return this.assign(id1, id2).to((BiDataSource.Pair<?, ?>)((Object)dataSource.pairs()));
        }

        default public ValueDeclaration<BiDataSource.Pair<?, ?>, ? extends ValueSetupBase<B>> assign(String id1, String id2) {
            String pairId = "(" + id1 + ";" + id2 + ")@" + DefaultFactories.uniqueIdStr();
            return this.assign(id1).to(vm -> ((BiDataSource.Pair)vm.get(pairId)).v1()).assign(id2).to(vm -> ((BiDataSource.Pair)vm.get(pairId)).v2()).assign(pairId);
        }

        default public <T> ValueDeclaration<T, ? extends ValueSetupBase<B>> assign(Typed<T> token) {
            return this.assign(token.toString());
        }

        default public <T, U> ValueSetupBase<B> assign(Typed<T> token1, Typed<U> token2, BiDataSource<? extends T, ? extends U> dataSource) {
            return this.assign(token1.toString(), token2.toString(), dataSource);
        }

        default public <T, U> ValueDeclaration<BiDataSource.Pair<T, U>, ? extends ValueSetupBase<B>> assign(Typed<T> token1, Typed<U> token2) {
            return this.assign(token1.toString(), token2.toString());
        }

        public ValueSetupBase<B> assignValues(String var1, ValueSource<?> var2);

        public ValueSetupBase<B> include(String var1, Factory.Include<?> var2);

        default public ValueSetupBase<B> include(String key, Factory<?> factory) {
            return this.include(key, factory.generate().asInclude());
        }

        default public ValueSetupBase<B> include(String key, String factoryKey) {
            return this.include(key, (Factory.Include)null);
        }
    }
}

