/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cthul.fixsure.factory.FactoriesSetup;
import org.cthul.fixsure.factory.Factory;
import org.cthul.fixsure.factory.FactoryParent;
import org.cthul.fixsure.factory.ValueGenerator;
import org.cthul.fixsure.factory.ValueSource;

public abstract class FactoryBase
implements FactoryParent {
    private final FactoryParent parent;
    private final Map<String, ValueSource<?>> sources = new HashMap();
    private final Map<String, ValueGenerator<?>> generators = new HashMap();
    private final List<Factory.Include<?>> includes = new ArrayList();
    private boolean resetting = false;
    private Map<String, ValueSource<?>> nestedSources = null;
    private Map<String, Factory.Include<?>> nestedIncludes = null;
    private boolean initialized = false;
    protected static final ValueGenerator<?> NO_VALUE = ValueGenerator.constant(null);

    public FactoryBase() {
        this.parent = null;
    }

    public FactoryBase(FactoryParent parent) {
        this.parent = parent;
    }

    protected abstract ValueSource.FactoryMap getFactoryMap();

    protected void reset() {
        if (this.resetting) {
            return;
        }
        this.resetting = true;
        try {
            this.initialized = false;
            this.doReset();
        }
        finally {
            this.resetting = false;
        }
    }

    protected void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.nestedSources != null) {
            this.nestedSources.forEach((key, vs) -> this.applyNestedSet((String)key, null).toValuesOf((ValueSource)vs));
        }
        if (this.nestedIncludes != null) {
            this.nestedIncludes.forEach((key, inc) -> this.applyNestedSet((String)key, null).include((Factory.Include)inc));
        }
    }

    protected void doReset() {
        this.generators.clear();
        this.includes.forEach(Factory.Include::reset);
    }

    protected void putValueSource(String key, ValueSource<?> valueSource) {
        if (key.contains(".")) {
            this.nestedSet(key, null).toValuesOf(valueSource);
        }
        this.sources.put(key, valueSource);
        this.generators.remove(key);
    }

    protected void addInclude(String key, Factory.Include<?> include) {
        if (key.contains(".")) {
            this.nestedSet(key, null).include(include);
        }
        this.putValueSource(key, include);
        this.includes.add(include);
    }

    @Override
    public Map<String, String> getDescriptionForChild() {
        return this.getDescription();
    }

    protected Map<String, String> getDescription() {
        HashMap<String, String> map = this.parent == null ? new HashMap() : this.parent.getDescriptionForChild();
        this.generators.forEach((key, gen) -> map.put((String)key, gen.toString()));
        this.sources.forEach((key, src) -> map.putIfAbsent((String)key, src.toString()));
        return map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Map<String, String> map = this.getDescription();
        map.forEach((key, val) -> {
            if (!key.startsWith("@")) {
                sb.append((String)key).append("=").append((String)val).append(",");
            }
        });
        if (sb.length() == 0) {
            return "";
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    protected <T> ValueGenerator<T> valueGenerator(String key) {
        ValueGenerator<T> gen = this.internPeekGenerator(key);
        if (gen != null) {
            return gen;
        }
        throw new IllegalArgumentException(key);
    }

    @Override
    public <T> ValueGenerator<T> peekGenerator(String key) {
        ValueGenerator gen = this.generators.computeIfAbsent(key, this::newGenerator);
        if (gen == NO_VALUE) {
            return null;
        }
        return gen;
    }

    protected <T> ValueGenerator<T> internPeekGenerator(String key) {
        return this.peekGenerator(key);
    }

    protected ValueGenerator<?> newGenerator(String key) {
        ValueGenerator gen;
        ValueSource<?> src = this.sources.get(key);
        if (src != null) {
            return src.generate(this.getFactoryMap());
        }
        src = this.getSourceFromInclude(key);
        if (src != null) {
            return src.generate(this.getFactoryMap());
        }
        if (this.parent != null && (gen = this.parent.peekGenerator(key)) != null) {
            return gen.link(this.getFactoryMap());
        }
        for (Factory.Include<?> inc : this.includes) {
            src = inc.attributeSource(key, true);
            if (src == null) continue;
            this.sources.put(key, src);
            return src.generate(this.getFactoryMap());
        }
        return NO_VALUE;
    }

    protected ValueSource<?> getSourceFromInclude(String key) {
        for (Factory.Include<?> inc : this.includes) {
            ValueSource<?> src = inc.attributeSource(key, false);
            if (src == null) continue;
            this.sources.put(key, src);
            return src;
        }
        return null;
    }

    protected <T> ValueGenerator<T> peekParentGenerator(String key) {
        if (this.parent == null) {
            return null;
        }
        return this.parent.peekGenerator(key);
    }

    @Override
    public <T> ValueSource<T> peekSource(String key, boolean useDefault) {
        ValueSource<Object> src = this.sources.get(key);
        if (src != null) {
            return src;
        }
        src = this.getSourceFromInclude(key);
        if (src != null) {
            return src;
        }
        if (this.parent != null && (src = this.parent.peekSource(key, useDefault)) != null) {
            return src;
        }
        return null;
    }

    protected <T, B> FactoriesSetup.ValueDeclaration<T, B> set(final String key, final B builder) {
        if (key.contains(".")) {
            return this.nestedSet(key, builder);
        }
        return new FactoriesSetup.ValueDeclaration<T, B>(){

            @Override
            public B toValuesOf(ValueSource<? extends T> valueSource) {
                FactoryBase.this.putValueSource(key, valueSource);
                return builder;
            }

            @Override
            public B include(Factory.Include<? extends T> include) {
                FactoryBase.this.addInclude(key, include);
                return builder;
            }
        };
    }

    protected <T, B> FactoriesSetup.ValueDeclaration<T, B> nestedSet(final String key, final B builder) {
        if (this.initialized) {
            return this.applyNestedSet(key, builder);
        }
        return new FactoriesSetup.ValueDeclaration<T, B>(){

            @Override
            public B toValuesOf(ValueSource<? extends T> valueSource) {
                if (FactoryBase.this.nestedSources == null) {
                    FactoryBase.this.nestedSources = new HashMap();
                }
                FactoryBase.this.nestedSources.put(key, valueSource);
                return builder;
            }

            @Override
            public B include(Factory.Include<? extends T> include) {
                if (FactoryBase.this.nestedIncludes == null) {
                    FactoryBase.this.nestedIncludes = new HashMap();
                }
                FactoryBase.this.nestedIncludes.put(key, include);
                return builder;
            }
        };
    }

    protected <T, B> FactoriesSetup.ValueDeclaration<T, B> applyNestedSet(String key, B builder) {
        int i = key.indexOf(46);
        return this.valueGenerator(key.substring(0, i)).set(key.substring(i + 1), builder);
    }
}

