/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.factory;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.Typed;
import org.cthul.fixsure.factory.DefaultFactory;
import org.cthul.fixsure.factory.Factories;
import org.cthul.fixsure.factory.FactoriesSetup;
import org.cthul.fixsure.factory.Factory;
import org.cthul.fixsure.factory.ValueSource;
import org.cthul.fixsure.fluents.FlGenerator;
import org.cthul.fixsure.generators.AnonymousGenerator;
import org.cthul.fixsure.generators.GeneratorTools;

public interface ValueGenerator<T>
extends Typed<T> {
    public T next(ValueMap var1);

    default public ValueGenerator<T> link(ValueSource.FactoryMap factoryMap) {
        return this;
    }

    default public T next(ValueMap valueMap, Function<ValueMap, ValueMap> transform) {
        return this.next(valueMap);
    }

    default public <V, B> FactoriesSetup.ValueDeclaration<V, B> set(String key, B builder) {
        throw new IllegalArgumentException(key);
    }

    @Override
    default public Class<T> getValueType() {
        return null;
    }

    public static <T> Src<T> fromFunction(final Function<? super ValueMap, ? extends T> function) {
        return new Src<T>(){

            @Override
            public T next(ValueMap valueMap) {
                return function.apply(valueMap);
            }

            @Override
            public Class<T> getValueType() {
                return null;
            }

            public String toString() {
                return GeneratorTools.lambdaToString(function, new StringBuilder()).toString();
            }
        };
    }

    public static <T> ValueGenerator<T> fromGenerator(Generator<? extends T> generator) {
        if (generator instanceof VG2G) {
            return ((VG2G)generator).gen;
        }
        return new G2VG<T>(generator);
    }

    public static <T> FlGenerator<T> toGenerator(ValueGenerator<T> generator, ValueMap valueMap) {
        if (generator instanceof G2VG) {
            return ((G2VG)generator).generator.fluentData();
        }
        return new VG2G<T>(generator, valueMap);
    }

    public static <T> Src<T> constant(final T value) {
        return new Src<T>(){

            @Override
            public T next(ValueMap valueMap) {
                return value;
            }

            @Override
            public Class<T> getValueType() {
                return value == null ? null : value.getClass();
            }

            public String toString() {
                return String.valueOf(value);
            }
        };
    }

    public static <T> ValueGenerator<T> nextKey(ValueSource.FactoryMap factoryMap, String key) {
        class Next<T>
        extends DefaultFactory<T> {
            final ValueSource.FactoryMap factoryMap;
            final ValueGenerator<T> actual;
            ValueMap overridingValues;
            ValueMap overriddenValues;
            final /* synthetic */ String val$key;

            public Next(ValueSource.FactoryMap factoryMap2) {
                this.val$key = factoryMap2;
                super(null, (String)((Object)factoryMap2), null);
                this.factoryMap = factoryMap;
                this.actual = factoryMap.valueGenerator(this.val$key);
            }

            public Next(ValueSource.FactoryMap parent, DefaultFactory defaultFactory) {
                this.val$key = defaultFactory;
                super((DefaultFactory)((Object)parent));
                this.factoryMap = factoryMap;
                this.actual = factoryMap.valueGenerator(this.val$key);
            }

            @Override
            protected DefaultFactory<T> copy(ValueSource.FactoryMap factoryMap) {
                return new Next(factoryMap, (DefaultFactory)this, this.val$key);
            }

            @Override
            public T next() {
                return this.next((ValueMap)null);
            }

            @Override
            protected T next(ValueMap valueMap) {
                this.overridingValues = valueMap;
                1Next.VM2 vm = new 1Next.VM2();
                return this.actual.next(vm, vm2 -> {
                    this.overriddenValues = vm2;
                    return vm;
                });
            }

            @Override
            public <T> ValueGenerator<T> peekGenerator(String key) {
                ValueGenerator gen = super.peekGenerator(key);
                if (gen != null) {
                    return gen;
                }
                if (this.overriddenValues != null) {
                    return this.overriddenValues.peekValueGenerator(key);
                }
                return this.factoryMap.peekValueGenerator(key);
            }

            protected void superSet(String key, ValueSource<?> source) {
                super.set(key, null).toValuesOf(source);
            }

            protected void superInclude(String key, Factory.Include<?> include) {
                super.set(key, null).include(include);
            }

            class 1Next.VM2
            extends DefaultFactory.VM {
                private final Set<String> recursionGuard;

                public 1Next.VM2() {
                    super(this);
                    this.recursionGuard = new HashSet<String>();
                }

                @Override
                protected <T> ValueGenerator<T> peekOwnerValueGenerator(String key) {
                    this.initialize();
                    if (overridingValues != null) {
                        return overridingValues.peekValueGenerator(key);
                    }
                    return super.peekOwnerValueGenerator(key);
                }

                @Override
                protected Set<String> recursionGuard() {
                    return this.recursionGuard;
                }
            }
        }
        return new Next(factoryMap, key).asValueGenerator();
    }

    public static <T> Src<T> getKey(final String key) {
        return new Src<T>(){

            @Override
            public T next(ValueMap valueMap) {
                return valueMap.get(key);
            }

            @Override
            public Class<T> getValueType() {
                return null;
            }
        };
    }

    public static interface ValueMap
    extends Factories {
        default public <T> ValueGenerator<T> valueGenerator(String key) {
            ValueGenerator<T> gen = this.peekValueGenerator(key);
            if (gen != null) {
                return gen;
            }
            throw new IllegalArgumentException(key);
        }

        public <T> ValueGenerator<T> peekValueGenerator(String var1);

        public <T> T get(String var1);

        default public int getInt(String key) {
            return this.i(key);
        }

        default public String getStr(String key) {
            return this.str(key);
        }

        default public boolean getBool(String key) {
            return this.x(key);
        }

        default public <T> T get(Typed<T> token) {
            return this.get(token.toString());
        }

        default public int getInt(Typed<? extends Number> token) {
            return this.getInt(token.toString());
        }

        default public String getStr(Typed<?> token) {
            return this.getStr(token.toString());
        }

        default public boolean getBool(Typed<Boolean> token) {
            return this.getBool(token.toString());
        }

        default public byte b(String key) {
            return ((Number)this.get(key)).byteValue();
        }

        default public char c(String key) {
            return ((Character)this.get(key)).charValue();
        }

        default public double d(String key) {
            return ((Number)this.get(key)).doubleValue();
        }

        default public double f(String key) {
            return ((Number)this.get(key)).floatValue();
        }

        default public long l(String key) {
            return ((Number)this.get(key)).longValue();
        }

        default public int i(String key) {
            return ((Number)this.get(key)).intValue();
        }

        default public boolean x(String key) {
            return (Boolean)this.get(key);
        }

        default public String str(String key) {
            return Objects.toString(this.get(key), null);
        }

        default public Object[] values(String ... keys) {
            return this.values(new Object[keys.length], keys);
        }

        default public <T> T[] values(T[] array, String ... keys) {
            return this.values(array, 0, keys);
        }

        default public <T> T[] values(T[] array, int index, String ... keys) {
            if (array.length < keys.length + index) {
                array = Arrays.copyOf(array, keys.length + index);
            }
            for (int i = 0; i < keys.length; ++i) {
                array[i + index] = this.get(keys[i]);
            }
            return array;
        }
    }

    public static class VG2G<T>
    extends AnonymousGenerator<T> {
        private final ValueGenerator<T> gen;
        private final ValueMap vm;

        public VG2G(ValueGenerator<T> gen, ValueMap vm) {
            this.gen = gen;
            this.vm = vm;
        }

        @Override
        public T next() {
            return this.gen.next(this.vm);
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            return sb.append(this.gen);
        }
    }

    public static class G2VG<T>
    implements Src {
        final Generator<? extends T> generator;

        public G2VG(Generator<? extends T> generator) {
            this.generator = generator;
        }

        @Override
        public T next(ValueMap valueMap) {
            return this.generator.next();
        }

        @Override
        public Class<T> getValueType() {
            return GeneratorTools.typeOf(this.generator);
        }

        public String toString() {
            return GeneratorTools.lambdaToString(this.generator, new StringBuilder()).toString();
        }
    }

    public static interface Src<T>
    extends ValueGenerator<T>,
    ValueSource<T> {
        @Override
        default public ValueGenerator<? extends T> generate(ValueSource.FactoryMap factoryMap) {
            return this;
        }

        @Override
        default public Class<T> getValueType() {
            return null;
        }
    }
}

