/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.factory;

import java.lang.reflect.Field;
import java.util.function.Function;
import java.util.function.Supplier;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Typed;
import org.cthul.fixsure.factory.ValueGenerator;
import org.cthul.fixsure.generators.GeneratorTools;

public interface ValueSource<T>
extends Typed<T> {
    public ValueGenerator<? extends T> generate(FactoryMap var1);

    @Override
    default public Class<T> getValueType() {
        return null;
    }

    public static <T> ValueSource<T> fromGenerator(final ValueGenerator<? extends T> gen) {
        if (gen instanceof ValueSource) {
            return (ValueSource)((Object)gen);
        }
        return new ValueSource<T>(){

            @Override
            public ValueGenerator<? extends T> generate(FactoryMap factoryMap) {
                return gen;
            }

            @Override
            public Class<T> getValueType() {
                return gen.getValueType();
            }

            public String toString() {
                return gen.toString();
            }
        };
    }

    public static <T> ValueSource<T> fromFunction(Function<? super ValueGenerator.ValueMap, ? extends T> function) {
        return ValueGenerator.fromFunction(function);
    }

    public static <T> ValueSource<T> fromDataSource(final DataSource<? extends T> source) {
        return new ValueSource<T>(){

            @Override
            public ValueGenerator<? extends T> generate(FactoryMap factoryMap) {
                return ValueGenerator.fromGenerator(source.toGenerator());
            }

            @Override
            public Class<T> getValueType() {
                return GeneratorTools.typeOf(source);
            }

            public String toString() {
                return GeneratorTools.lambdaToString(source, new StringBuilder()).toString();
            }
        };
    }

    public static <T> ValueSource<T> fromDataSupply(final Supplier<? extends DataSource<? extends T>> source) {
        return new ValueSource<T>(){

            @Override
            public ValueGenerator<? extends T> generate(FactoryMap factoryMap) {
                return ValueGenerator.fromGenerator(((DataSource)source.get()).toGenerator());
            }

            @Override
            public Class<T> getValueType() {
                return GeneratorTools.typeOf(source);
            }

            public String toString() {
                return GeneratorTools.lambdaToString(source, new StringBuilder()).toString();
            }
        };
    }

    public static <T> ValueSource<T> constant(T value) {
        return ValueGenerator.constant(value);
    }

    public static <T> ValueSource<T> nextKey(final String key) {
        return new ValueSource<T>(){

            @Override
            public ValueGenerator<? extends T> generate(FactoryMap factoryMap) {
                return ValueGenerator.nextKey(factoryMap, key);
            }

            public String toString() {
                return "next " + key;
            }
        };
    }

    public static <T> ValueSource<T> getKey(String key) {
        return ValueGenerator.getKey(key);
    }

    public static <T> ValueSource<T> forField(final Class<?> clazz, final String name) {
        return new ValueSource<T>(){
            Field field;

            @Override
            public ValueGenerator<? extends T> generate(FactoryMap factoryMap) {
                try {
                    ValueGenerator src = factoryMap.peekValueGenerator(name);
                    if (src != null) {
                        return ValueGenerator.nextKey(factoryMap, name);
                    }
                }
                catch (RuntimeException src) {
                    // empty catch block
                }
                String type = this.getField().getType().getName();
                return ValueGenerator.nextKey(factoryMap, type);
            }

            @Override
            public Class<T> getValueType() {
                return null;
            }

            private Field getField() {
                if (this.field != null) {
                    return this.field;
                }
                for (Class c = clazz; c != null; c = c.getSuperclass()) {
                    for (Field f : c.getDeclaredFields()) {
                        if (!f.getName().equals(name)) continue;
                        this.field = f;
                        return this.field;
                    }
                }
                throw new IllegalArgumentException("No field " + name + " in " + clazz);
            }
        };
    }

    public static interface FactoryMap {
        default public <T> ValueGenerator<T> valueGenerator(String key) {
            ValueGenerator gen = this.peekValueGenerator(key);
            if (gen != null) {
                return gen;
            }
            throw new IllegalArgumentException(key);
        }

        public <T> ValueGenerator peekValueGenerator(String var1);
    }
}

