/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.fetchers;

import org.cthul.fixsure.Cardinality;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Distribution;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.distributions.UniformDistribution;
import org.cthul.fixsure.fetchers.EagerFetcher;
import org.cthul.fixsure.fetchers.LazyFetcher;

public class Fetchers {
    private static final int FEW_LOW = 3;
    private static final int FEW_HIGH = 5;
    private static final int SOME_LOW = 5;
    private static final int SOME_HIGH = 8;
    private static final int SEVERAL_LOW = 8;
    private static final int SEVERAL_HIGH = 16;
    private static final int MANY_LOW = 96;
    private static final int MANY_HIGH = 128;

    private Fetchers() {
    }

    public static EagerFetcher all() {
        return Instances.ALL;
    }

    public static LazyFetcher cache() {
        return Instances.UNBOUND;
    }

    public static EagerFetcher next(int length) {
        return new EagerFetcher(length);
    }

    public static EagerFetcher.Template next(int min, int max) {
        return () -> new EagerFetcher(min, max);
    }

    public static EagerFetcher.Template next(int min, int max, Distribution distribution) {
        return () -> new EagerFetcher(min, max, distribution);
    }

    public static EagerFetcher.Template next(int min, int max, long seed) {
        return Fetchers.next(min, max, UniformDistribution.uniform(seed));
    }

    public static Cardinality cardinality(DataSource<Integer> lengthGenerator) {
        if (lengthGenerator instanceof Cardinality) {
            return (Cardinality)lengthGenerator;
        }
        return () -> new EagerFetcher(lengthGenerator);
    }

    public static Cardinality.Fetcher fetcher(DataSource<Integer> lengthGenerator) {
        if (lengthGenerator instanceof Cardinality) {
            return ((Cardinality)lengthGenerator).toFetcher();
        }
        return new EagerFetcher(lengthGenerator);
    }

    public static EagerFetcher.Template next(DataSource<Integer> lengthGenerator) {
        return () -> new EagerFetcher(lengthGenerator);
    }

    public static EagerFetcher next(Generator<Integer> lengthGenerator) {
        return new EagerFetcher(lengthGenerator);
    }

    public static EagerFetcher first(int length) {
        return new EagerFetcher(length);
    }

    public static EagerFetcher.Template first(int min, int max) {
        return () -> new EagerFetcher(min, max);
    }

    public static EagerFetcher.Template first(DataSource<Integer> lengthGenerator) {
        return () -> new EagerFetcher(lengthGenerator);
    }

    public static EagerFetcher one() {
        return Instances.ONE;
    }

    public static EagerFetcher two() {
        return Instances.TWO;
    }

    public static EagerFetcher three() {
        return Instances.THREE;
    }

    public static EagerFetcher.Template few() {
        return Instances.FEW;
    }

    public static EagerFetcher.Template some() {
        return Instances.SOME;
    }

    public static EagerFetcher.Template several() {
        return Instances.SEVERAL;
    }

    public static EagerFetcher.Template many() {
        return Instances.MANY;
    }

    public static EagerFetcher.Template few(Distribution distribution) {
        return Fetchers.next(3, 5, distribution);
    }

    public static EagerFetcher.Template some(Distribution distribution) {
        return Fetchers.next(5, 8, distribution);
    }

    public static EagerFetcher.Template several(Distribution distribution) {
        return Fetchers.next(8, 16, distribution);
    }

    public static EagerFetcher.Template many(Distribution distribution) {
        return Fetchers.next(96, 128, distribution);
    }

    public static EagerFetcher.Template few(long seed) {
        return Fetchers.few(UniformDistribution.uniform(seed));
    }

    public static EagerFetcher.Template some(long seed) {
        return Fetchers.some(UniformDistribution.uniform(seed));
    }

    public static EagerFetcher.Template several(long seed) {
        return Fetchers.several(UniformDistribution.uniform(seed));
    }

    public static EagerFetcher.Template many(long seed) {
        return Fetchers.many(UniformDistribution.uniform(seed));
    }

    public static LazyFetcher any(DataSource<Integer> lengthGenerator) {
        return new LazyFetcher(lengthGenerator);
    }

    private static class Instances {
        private static final EagerFetcher ALL = new EagerFetcher(-1);
        private static final LazyFetcher UNBOUND = new LazyFetcher(-1);
        private static final EagerFetcher ONE = new EagerFetcher(1);
        private static final EagerFetcher TWO = new EagerFetcher(2);
        private static final EagerFetcher THREE = new EagerFetcher(3);
        private static final EagerFetcher.Template FEW = Fetchers.next(3, 5);
        private static final EagerFetcher.Template SOME = Fetchers.next(5, 8);
        private static final EagerFetcher.Template SEVERAL = Fetchers.next(8, 16);
        private static final EagerFetcher.Template MANY = Fetchers.next(96, 128);

        private Instances() {
        }
    }
}

