/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.fluents;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.cthul.fixsure.api.AbstractStringify;
import org.cthul.fixsure.fluents.BiDataSource;
import org.cthul.fixsure.fluents.FlGenerator;
import org.cthul.fixsure.generators.AnonymousGenerator;
import org.cthul.fixsure.generators.GeneratorTools;

@FunctionalInterface
public interface BiGenerator<T, U>
extends BiDataSource<T, U> {
    public void next(BiConsumer<? super T, ? super U> var1);

    @Override
    default public FlGenerator<T> onlyFirst() {
        return this.map((T t, U u) -> t);
    }

    @Override
    default public FlGenerator<U> onlySecond() {
        return this.map((T t, U u) -> u);
    }

    @Override
    default public FlGenerator<BiDataSource.Pair<T, U>> pairs() {
        return this.map(BiDataSource.Pair::new);
    }

    @Override
    default public BiGenerator<T, U> filter(final BiPredicate<? super T, ? super U> predicate) {
        final Bag bag = new Bag();
        return new Anonymous<T, U>(){

            @Override
            public void next(BiConsumer<? super T, ? super U> bag2) {
                do {
                    this.next(bag);
                } while (!predicate.test(bag.get1(), bag.get2()));
                bag2.accept(bag.get1(), bag.get2());
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                BiGenerator.this.toString(sb).append(".filter(");
                GeneratorTools.lambdaToString(predicate, sb);
                return sb.append(')');
            }
        };
    }

    @Override
    default public BiGenerator<T, U> filter1(Predicate<? super T> predicate) {
        return this.filter((T t, U u) -> predicate.test(t));
    }

    @Override
    default public BiGenerator<T, U> filter2(Predicate<? super U> predicate) {
        return this.filter((T t, U u) -> predicate.test((Object)u));
    }

    @Override
    default public <R> FlGenerator<R> map(final BiFunction<? super T, ? super U, ? extends R> function) {
        final Bag bag = new Bag();
        return new AnonymousGenerator<R>(){

            @Override
            public R next() {
                BiGenerator.this.next(bag);
                return function.apply(bag.get1(), bag.get2());
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                BiGenerator.this.toString(sb).append(".map(");
                GeneratorTools.lambdaToString(function, sb);
                return sb.append(')');
            }
        };
    }

    @Override
    default public <R> BiGenerator<R, U> map1(final Function<? super T, ? extends R> function) {
        final Bag bag = new Bag();
        return new Anonymous<R, U>(){

            @Override
            public void next(BiConsumer<? super R, ? super U> bag2) {
                BiGenerator.this.next(bag);
                Object t = bag.get1();
                Object u = bag.get2();
                bag2.accept(function.apply(t), u);
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                BiGenerator.this.toString(sb).append(".map1(");
                GeneratorTools.lambdaToString(function, sb);
                return sb.append(')');
            }
        };
    }

    @Override
    default public <R> BiGenerator<T, R> map2(final Function<? super U, ? extends R> function) {
        final Bag bag = new Bag();
        return new Anonymous<T, R>(){

            @Override
            public void next(BiConsumer<? super T, ? super R> bag2) {
                BiGenerator.this.next(bag);
                Object t = bag.get1();
                Object u = bag.get2();
                bag2.accept(t, function.apply(u));
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                BiGenerator.this.toString(sb).append(".map2(");
                GeneratorTools.lambdaToString(function, sb);
                return sb.append(')');
            }
        };
    }

    @Override
    default public BiGenerator<T, U> toBiGenerator() {
        return this;
    }

    public static abstract class Anonymous<T, U>
    extends AbstractStringify
    implements BiGenerator<T, U> {
    }

    public static class Bag<T, U>
    implements BiConsumer<T, U> {
        private T t;
        private U u;

        @Override
        public void accept(T t, U u) {
            this.t = t;
            this.u = u;
        }

        public T get1() {
            return this.t;
        }

        public U get2() {
            return this.u;
        }
    }
}

