/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.fluents;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.cthul.fixsure.SequenceLength;
import org.cthul.fixsure.api.AbstractStringify;
import org.cthul.fixsure.fluents.BiDataSource;
import org.cthul.fixsure.fluents.BiGenerator;
import org.cthul.fixsure.fluents.BiTemplate;
import org.cthul.fixsure.fluents.FlSequence;
import org.cthul.fixsure.generators.AnonymousSequence;
import org.cthul.fixsure.generators.GeneratorTools;

public interface BiSequence<T, U>
extends BiTemplate<T, U>,
SequenceLength {
    public void value(long var1, BiConsumer<? super T, ? super U> var3);

    @Override
    default public FlSequence<T> onlyFirst() {
        final BiGenerator.Bag bag = new BiGenerator.Bag();
        return new AnonymousSequence<T>(this){

            @Override
            public T value(long n) {
                BiSequence.this.value(n, bag);
                return bag.get1();
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                return BiSequence.this.toString(sb).append(".first()");
            }
        };
    }

    @Override
    default public FlSequence<U> onlySecond() {
        final BiGenerator.Bag bag = new BiGenerator.Bag();
        return new AnonymousSequence<U>(this){

            @Override
            public U value(long n) {
                BiSequence.this.value(n, bag);
                return bag.get2();
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                return BiSequence.this.toString(sb).append(".second()");
            }
        };
    }

    @Override
    default public FlSequence<BiDataSource.Pair<T, U>> pairs() {
        return this.map(BiDataSource.Pair::new);
    }

    @Override
    default public <R> FlSequence<R> map(final BiFunction<? super T, ? super U, ? extends R> function) {
        return new AnonymousSequence<R>(this){
            BiGenerator.Bag<T, U> bag;
            {
                super(length);
                this.bag = new BiGenerator.Bag();
            }

            @Override
            public Class<R> getValueType() {
                return null;
            }

            @Override
            public R value(long n) {
                BiSequence.this.value(n, this.bag);
                return function.apply(this.bag.get1(), this.bag.get2());
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                BiSequence.this.toString(sb).append(".map(");
                return GeneratorTools.lambdaToString(function, sb).append(')');
            }
        };
    }

    @Override
    default public <R> BiSequence<R, U> map1(final Function<? super T, ? extends R> function) {
        final BiGenerator.Bag bag = new BiGenerator.Bag();
        return new Anonymous<R, U>(this){

            @Override
            public void value(long index, BiConsumer<? super R, ? super U> bag2) {
                BiSequence.this.value(index, bag);
                Object t = bag.get1();
                Object u = bag.get2();
                bag2.accept(function.apply(t), u);
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                BiSequence.this.toString(sb).append(".map1(");
                return GeneratorTools.lambdaToString(function, sb).append(')');
            }
        };
    }

    @Override
    default public <R> BiSequence<T, R> map2(final Function<? super U, ? extends R> function) {
        final BiGenerator.Bag bag = new BiGenerator.Bag();
        return new Anonymous<T, R>(this){

            @Override
            public void value(long index, BiConsumer<? super T, ? super R> bag2) {
                BiSequence.this.value(index, bag);
                Object t = bag.get1();
                Object u = bag.get2();
                bag2.accept(t, function.apply(u));
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                BiSequence.this.toString(sb).append(".map2(");
                return GeneratorTools.lambdaToString(function, sb).append(')');
            }
        };
    }

    @Override
    default public BiGenerator<T, U> newBiGenerator() {
        return new BiGenerator.Anonymous<T, U>(){
            long index = 0L;

            @Override
            public void next(BiConsumer<? super T, ? super U> bag) {
                SequenceLength.isInRange(this.index, BiSequence.this);
                BiSequence.this.value(this.index++, bag);
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                return BiSequence.this.toString(sb).append('[').append(this.index).append(']');
            }
        };
    }

    default public BiSequence<T, U> repeat() {
        if (this.isUnbounded()) {
            if (this.negativeIndices()) {
                return this;
            }
            return new Anonymous<T, U>(SequenceLength.NEGATIVE_INDICES){

                @Override
                public void value(long index, BiConsumer<? super T, ? super U> bag) {
                    BiSequence.this.value(index & Long.MAX_VALUE, bag);
                }

                @Override
                public StringBuilder toString(StringBuilder sb) {
                    return BiSequence.this.toString(sb);
                }
            };
        }
        return new Anonymous<T, U>(SequenceLength.NEGATIVE_INDICES){

            @Override
            public void value(long index, BiConsumer<? super T, ? super U> bag) {
                BiSequence.this.value((index & Long.MAX_VALUE) % this.length(), bag);
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                return BiSequence.this.toString(sb);
            }
        };
    }

    public static abstract class Anonymous<T, U>
    extends AbstractStringify
    implements BiSequence<T, U> {
        private final long length;

        public Anonymous(long length) {
            this.length = length;
        }

        public Anonymous(SequenceLength length) {
            this.length = SequenceLength.toLong(length);
        }

        @Override
        public long length() {
            return this.length;
        }
    }
}

