/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.fluents;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.cthul.fixsure.Cardinality;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.Typed;
import org.cthul.fixsure.Values;
import org.cthul.fixsure.fetchers.Fetchers;
import org.cthul.fixsure.fluents.BiDataSource;
import org.cthul.fixsure.fluents.FlGenerator;
import org.cthul.fixsure.fluents.FlTemplate;
import org.cthul.fixsure.fluents.FlValues;
import org.cthul.fixsure.generators.AnonymousTemplate;
import org.cthul.fixsure.generators.composite.RepeatingGenerator;
import org.cthul.fixsure.values.EagerValues;
import org.cthul.fixsure.values.LazyValues;

public interface FlDataSource<T>
extends DataSource<T>,
Typed<T> {
    @Override
    public Generator<T> toGenerator();

    @Override
    default public Class<T> getValueType() {
        return null;
    }

    default public FlValues<T> fetch(Cardinality cardinality) {
        return cardinality.toFetcher().of(this).fluentData();
    }

    default public LazyValues<T> cached() {
        return Fetchers.cache().of((DataSource)this);
    }

    default public EagerValues<T> all() {
        return Fetchers.all().of((DataSource)this);
    }

    default public EagerValues<T> one() {
        return Fetchers.one().of((DataSource)this);
    }

    default public EagerValues<T> two() {
        return Fetchers.two().of((DataSource)this);
    }

    default public EagerValues<T> three() {
        return Fetchers.three().of((DataSource)this);
    }

    public EagerValues<T> few();

    public EagerValues<T> some();

    public EagerValues<T> several();

    public EagerValues<T> many();

    public FlDataSource<T> distinct();

    public FlDataSource<T> filter(Predicate<? super T> var1);

    public <R> FlDataSource<R> flatMap(Function<? super T, ? extends DataSource<R>> var1);

    public <R> FlDataSource<R> map(Function<? super T, ? extends R> var1);

    public <U, R> FlDataSource<R> map(DataSource<U> var1, BiFunction<? super T, ? super U, ? extends R> var2);

    public FlDataSource<T> peek(Consumer<? super T> var1);

    public FlDataSource<T> then(DataSource<? extends T> ... var1);

    public FlDataSource<Values<T>> aggregate(int var1);

    public FlDataSource<Values<T>> aggregate(DataSource<Integer> var1);

    default public FlTemplate<T> repeat() {
        return new AnonymousTemplate<T>(){

            @Override
            public FlGenerator<T> newGenerator() {
                return RepeatingGenerator.repeat(FlDataSource.this);
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                return FlDataSource.this.toString(sb).append(".repeat()");
            }
        };
    }

    public FlDataSource<T> shuffle();

    public FlDataSource<T> shuffle(long var1);

    public FlDataSource<T> mixWith(DataSource<? extends T> ... var1);

    public FlDataSource<T> alternateWith(DataSource<? extends T> ... var1);

    public FlTemplate<T> snapshot();

    public <U> BiDataSource<T, U> split(Function<? super T, ? extends U> var1);

    public <U, V> BiDataSource<U, V> split(BiConsumer<? super T, ? super BiConsumer<? super U, ? super V>> var1);

    public <U> BiDataSource<T, U> with(DataSource<U> var1);

    default public Stream<T> stream() {
        return this.toGenerator().fluentData().stream();
    }

    default public <R> R transformSource(Function<? super FlDataSource<? extends T>, ? extends R> function) {
        return function.apply(this);
    }
}

