/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.fluents;

import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.cthul.fixsure.Cardinality;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.GeneratorException;
import org.cthul.fixsure.Values;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.fetchers.Fetchers;
import org.cthul.fixsure.fluents.BiGenerator;
import org.cthul.fixsure.fluents.FlDataSource;
import org.cthul.fixsure.fluents.FlTemplate;
import org.cthul.fixsure.fluents.FlValues;
import org.cthul.fixsure.generators.AnonymousGenerator;
import org.cthul.fixsure.generators.GeneratorTools;
import org.cthul.fixsure.generators.composite.DistinctGenerator;
import org.cthul.fixsure.generators.composite.FilteringGenerator;
import org.cthul.fixsure.generators.composite.FlatMappingGenerator;
import org.cthul.fixsure.generators.composite.GeneratorQueue;
import org.cthul.fixsure.generators.composite.MappingGenerator;
import org.cthul.fixsure.generators.composite.MixingGenerator;
import org.cthul.fixsure.generators.composite.RoundRobinGenerator;
import org.cthul.fixsure.generators.composite.ShufflingGenerator;
import org.cthul.fixsure.values.EagerValues;
import org.cthul.fixsure.values.LazyValues;

@FunctionalInterface
public interface FlGenerator<T>
extends FlDataSource<T>,
Generator<T> {
    public static final long LAMBDA_SEED_HINT = DistributionRandomizer.toSeed(FlGenerator.class);

    @Override
    @Deprecated
    default public Generator<T> toGenerator() {
        return this;
    }

    @Override
    default public FlGenerator<T> fluentData() {
        return this;
    }

    default public long randomSeedHint() {
        return LAMBDA_SEED_HINT;
    }

    default public LazyValues<T> any(int length) {
        return LazyValues.any(length, this);
    }

    default public LazyValues<T> any(Generator<Integer> length) {
        return LazyValues.any(length, this);
    }

    default public EagerValues<T> next(int length) {
        return EagerValues.next(length, this);
    }

    default public EagerValues<T> next(DataSource<Integer> length) {
        return EagerValues.next(length.toGenerator(), this);
    }

    default public FlValues<T> next(Cardinality fetcher) {
        return fetcher.toFetcher().of(this).fluentData();
    }

    @Override
    default public FlValues<T> fetch(Cardinality fetcher) {
        return fetcher.toFetcher().of(this).fluentData();
    }

    @Override
    default public LazyValues<T> cached() {
        return Fetchers.cache().of((DataSource)this);
    }

    @Override
    default public EagerValues<T> all() {
        return Fetchers.all().of((DataSource)this);
    }

    @Override
    default public EagerValues<T> one() {
        return Fetchers.one().of((DataSource)this);
    }

    @Override
    default public EagerValues<T> two() {
        return Fetchers.two().of((DataSource)this);
    }

    @Override
    default public EagerValues<T> three() {
        return Fetchers.three().of((DataSource)this);
    }

    @Override
    default public EagerValues<T> few() {
        return GeneratorTools.cacheConsumers(this).getFew().of((DataSource)this);
    }

    @Override
    default public EagerValues<T> some() {
        return GeneratorTools.cacheConsumers(this).getSome().of((DataSource)this);
    }

    @Override
    default public EagerValues<T> several() {
        return GeneratorTools.cacheConsumers(this).getSeveral().of((DataSource)this);
    }

    @Override
    default public EagerValues<T> many() {
        return GeneratorTools.cacheConsumers(this).getMany().of((DataSource)this);
    }

    @Override
    default public FlGenerator<T> distinct() {
        return DistinctGenerator.distinct(this);
    }

    @Override
    default public FlGenerator<T> filter(Predicate<? super T> predicate) {
        return FilteringGenerator.filter(this, predicate);
    }

    @Override
    default public <R> FlGenerator<R> flatMap(Function<? super T, ? extends DataSource<R>> function) {
        return FlatMappingGenerator.map(this, function);
    }

    @Override
    default public <R> FlGenerator<R> map(Function<? super T, ? extends R> function) {
        return MappingGenerator.map(this, function);
    }

    @Override
    default public <U, R> FlGenerator<R> map(DataSource<U> other, BiFunction<? super T, ? super U, ? extends R> function) {
        return this.with((DataSource)other).map((BiFunction)function);
    }

    @Override
    default public FlGenerator<T> peek(Consumer<? super T> consumer) {
        return this.map((T e) -> {
            consumer.accept(e);
            return e;
        });
    }

    @Override
    default public FlGenerator<T> then(DataSource<? extends T> ... more) {
        return GeneratorQueue.beginWith(this).thenAll(more);
    }

    @Override
    default public FlGenerator<Values<T>> aggregate(final int length) {
        return new AnonymousGenerator<Values<T>>(){

            @Override
            public Values<T> next() {
                return FlGenerator.this.next(length);
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                return FlGenerator.this.toString(sb).append(".aggregate(").append(length).append(")");
            }
        };
    }

    @Override
    default public FlGenerator<Values<T>> aggregate(DataSource<Integer> length) {
        final Cardinality.Fetcher fetcher = Fetchers.fetcher(length);
        return new AnonymousGenerator<Values<T>>(){

            @Override
            public Values<T> next() {
                return FlGenerator.this.fetch(fetcher);
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                FlGenerator.this.toString(sb).append(".aggregate(");
                return fetcher.toString(sb).append(")");
            }
        };
    }

    @Override
    default public FlGenerator<T> shuffle() {
        return this.shuffle(this.randomSeedHint());
    }

    @Override
    default public FlGenerator<T> shuffle(long seed) {
        return ShufflingGenerator.shuffle(this, seed);
    }

    @Override
    default public FlGenerator<T> mixWith(DataSource<? extends T> ... more) {
        Generator<? extends T>[] generators = DataSource.toGenerators(this, more);
        return MixingGenerator.mix(generators);
    }

    @Override
    default public FlGenerator<T> alternateWith(DataSource<? extends T> ... more) {
        Generator<? extends T>[] generators = DataSource.toGenerators(this, more);
        return RoundRobinGenerator.alternate(generators);
    }

    @Override
    default public FlTemplate<T> snapshot() {
        throw new UnsupportedOperationException("not copayble");
    }

    @Override
    default public <U> BiGenerator<T, U> split(final Function<? super T, ? extends U> function) {
        return new BiGenerator.Anonymous<T, U>(){

            @Override
            public void next(BiConsumer<? super T, ? super U> bag) {
                Object t = FlGenerator.this.next();
                bag.accept(t, function.apply(t));
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                FlGenerator.this.toString(sb).append(".split(");
                return GeneratorTools.lambdaToString(function, sb).append(')');
            }
        };
    }

    @Override
    default public <U, V> BiGenerator<U, V> split(final BiConsumer<? super T, ? super BiConsumer<? super U, ? super V>> action) {
        return new BiGenerator.Anonymous<U, V>(){

            @Override
            public void next(BiConsumer<? super U, ? super V> bag) {
                action.accept(FlGenerator.this.next(), bag);
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                FlGenerator.this.toString(sb).append(".split(");
                return GeneratorTools.lambdaToString(action, sb).append(')');
            }
        };
    }

    @Override
    default public <U> BiGenerator<T, U> with(DataSource<U> source) {
        final Generator<U> gen2 = source.toGenerator();
        return new BiGenerator.Anonymous<T, U>(){

            @Override
            public void next(BiConsumer<? super T, ? super U> bag) {
                bag.accept(FlGenerator.this.next(), gen2.next());
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                FlGenerator.this.toString(sb.append('('));
                return gen2.toString(sb.append(';')).append(')');
            }
        };
    }

    @Override
    default public Stream<T> stream() {
        class GSpliterator
        extends Spliterators.AbstractSpliterator<T> {
            public GSpliterator() {
                super(Long.MAX_VALUE, 1024);
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                try {
                    action.accept(FlGenerator.this.next());
                    return true;
                }
                catch (GeneratorException e) {
                    return false;
                }
            }
        }
        return StreamSupport.stream(new GSpliterator(), false);
    }

    default public <R> R transform(Function<? super FlGenerator<? extends T>, ? extends R> function) {
        return function.apply(this);
    }
}

