/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.fluents;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.cthul.fixsure.Distribution;
import org.cthul.fixsure.Fixsure;
import org.cthul.fixsure.Sequence;
import org.cthul.fixsure.SequenceLength;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.fluents.BiSequence;
import org.cthul.fixsure.fluents.FlGenerator;
import org.cthul.fixsure.fluents.FlTemplate;
import org.cthul.fixsure.generators.AnonymousSequence;
import org.cthul.fixsure.generators.AnonymousTemplate;
import org.cthul.fixsure.generators.GeneratorTools;
import org.cthul.fixsure.generators.composite.RandomizedSequenceGenerator;
import org.cthul.fixsure.generators.composite.RoundRobinSequence;
import org.cthul.fixsure.generators.composite.ShuffledSequenceGenerator;
import org.cthul.fixsure.generators.value.ItemsSequence;

public interface FlSequence<T>
extends FlTemplate<T>,
Sequence<T> {
    public static final long LAMBDA_SEED_HINT = DistributionRandomizer.toSeed(FlSequence.class);

    @Override
    default public FlGenerator<T> newGenerator() {
        return Sequence.super.newGenerator();
    }

    @Override
    default public FlSequence<T> fluentData() {
        return this;
    }

    @Override
    default public Class<T> getValueType() {
        return null;
    }

    default public long randomSeedHint() {
        return LAMBDA_SEED_HINT;
    }

    @Override
    default public T first() {
        return this.value(0L);
    }

    @Override
    default public <R> FlSequence<R> map(final Function<? super T, ? extends R> function) {
        return new AnonymousSequence<R>(this){

            @Override
            public Class<R> getValueType() {
                return null;
            }

            @Override
            public R value(long n) {
                Object t = FlSequence.this.value(n);
                return function.apply(t);
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                FlSequence.this.toString(sb).append(".map(");
                return GeneratorTools.lambdaToString(function, sb).append(')');
            }
        };
    }

    @Override
    default public <U, R> FlSequence<R> map(FlSequence<U> other, BiFunction<? super T, ? super U, ? extends R> function) {
        return this.with((Sequence<U>)other).map((BiFunction)function);
    }

    @Override
    default public FlSequence<T> peek(Consumer<? super T> consumer) {
        return this.map((T e) -> {
            consumer.accept(e);
            return e;
        });
    }

    default public FlSequence<T> then(final Sequence<? extends T> ... more) {
        if (this.isUnbounded()) {
            return this;
        }
        final long[] lengths = new long[more.length];
        long length = this.length();
        boolean unbounded = false;
        for (int i = 0; i < more.length; ++i) {
            lengths[i] = more[i].length();
            if (!more[i].isUnbounded() && (length += lengths[i]) >= 0L) continue;
            lengths[i] = -1L;
            unbounded = true;
            break;
        }
        return new AnonymousSequence<T>(unbounded ? -1L : length){

            @Override
            public T value(long index) {
                this.assertInRange(index);
                if (index < FlSequence.this.length()) {
                    return FlSequence.this.value(index);
                }
                long l = index - FlSequence.this.length();
                for (int i = 0; i < more.length; ++i) {
                    long len = lengths[i];
                    if (l < len || len < 0L) {
                        return more[i].value(l);
                    }
                    l -= len;
                }
                throw new IndexOutOfBoundsException("" + index);
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                return GeneratorTools.printList(FlSequence.this, Arrays.asList(more), sb.append('{')).append('}');
            }
        };
    }

    @Override
    default public FlSequence<T> repeat() {
        if (this.isUnbounded()) {
            if (this.negativeIndices()) {
                return this;
            }
            return new AnonymousSequence<T>(this, -2L){

                @Override
                public T value(long n) {
                    return FlSequence.this.value(n &= Long.MAX_VALUE);
                }

                @Override
                public StringBuilder toString(StringBuilder sb) {
                    return super.toString(sb).append(".repeat()");
                }
            };
        }
        return Sequence.sequence(this.getValueType(), -2L, l -> this.value((l &= Long.MAX_VALUE) % this.length()));
    }

    @Override
    default public FlTemplate<T> shuffle() {
        return new AnonymousTemplate<T>(){

            @Override
            public FlGenerator<T> newGenerator() {
                return ShuffledSequenceGenerator.shuffle(FlSequence.this);
            }
        };
    }

    default public FlTemplate<T> random() {
        return this.random(this.randomSeedHint());
    }

    default public FlTemplate<T> random(long seed) {
        return this.random(Fixsure.uniformDistribution(), seed);
    }

    default public FlTemplate<T> random(Distribution distribution) {
        return this.random(distribution, this.randomSeedHint());
    }

    default public FlTemplate<T> random(final Distribution distribution, final long seed) {
        return new AnonymousTemplate<T>(){

            @Override
            public FlGenerator<T> newGenerator() {
                return new RandomizedSequenceGenerator(FlSequence.this, distribution, seed);
            }
        };
    }

    default public FlSequence<T> sorted() {
        if (this.isUnbounded()) {
            throw new UnsupportedOperationException("unbounded");
        }
        if (this.length() >= Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("too large (" + this.length() + ")");
        }
        ArrayList list = new ArrayList(this.all());
        Collections.sort(list);
        return ItemsSequence.sequence(list);
    }

    default public FlSequence<T> alternateWith(Sequence<? extends T> ... more) {
        Sequence[] sequences = new Sequence[more.length + 1];
        sequences[0] = this;
        System.arraycopy(more, 0, sequences, 1, more.length);
        return RoundRobinSequence.alternate(sequences);
    }

    @Override
    default public <U> BiSequence<T, U> split(final Function<? super T, ? extends U> function) {
        return new BiSequence.Anonymous<T, U>(this){

            @Override
            public void value(long index, BiConsumer<? super T, ? super U> bag) {
                Object t = FlSequence.this.value(index);
                bag.accept(t, function.apply(t));
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                FlSequence.this.toString(sb).append(".split(");
                return GeneratorTools.lambdaToString(function, sb).append(')');
            }
        };
    }

    @Override
    default public <U, V> BiSequence<U, V> split(final BiConsumer<? super T, ? super BiConsumer<? super U, ? super V>> action) {
        return new BiSequence.Anonymous<U, V>(this){

            @Override
            public void value(long index, BiConsumer<? super U, ? super V> bag) {
                action.accept(FlSequence.this.value(index), bag);
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                FlSequence.this.toString(sb).append(".split(");
                return GeneratorTools.lambdaToString(action, sb).append(')');
            }
        };
    }

    @Override
    default public <U> BiSequence<T, U> with(final Sequence<U> source) {
        SequenceLength min = SequenceLength.min(this, source);
        return new BiSequence.Anonymous<T, U>(min){

            @Override
            public void value(long index, BiConsumer<? super T, ? super U> bag) {
                Object t = FlSequence.this.value(index);
                Object u = source.value(index);
                bag.accept(t, u);
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                FlSequence.this.toString(sb.append('('));
                return source.toString(sb.append(';')).append(')');
            }
        };
    }

    @Override
    default public Stream<T> stream() {
        if (this.isUnbounded()) {
            return FlTemplate.super.stream();
        }
        int characteristics = 17488;
        class SSpliterator
        implements Spliterator<T> {
            long n;
            long end;

            public SSpliterator() {
                this.n = 0L;
                this.end = FlSequence.this.length();
            }

            public SSpliterator(long n, long end) {
                this.n = n;
                this.end = end;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                action.accept(FlSequence.this.value(this.n++));
                return this.n < this.end;
            }

            @Override
            public Spliterator<T> trySplit() {
                long n2 = (this.end - this.n) / 2L;
                if (n2 < 16L) {
                    return null;
                }
                long n0 = this.n;
                this.n += n2;
                return new SSpliterator(n0, n2);
            }

            @Override
            public long estimateSize() {
                return this.end - this.n;
            }

            @Override
            public int characteristics() {
                return 17488;
            }
        }
        return StreamSupport.stream(new SSpliterator(), false);
    }
}

