/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.fluents;

import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.Template;
import org.cthul.fixsure.Typed;
import org.cthul.fixsure.Values;
import org.cthul.fixsure.fluents.BiTemplate;
import org.cthul.fixsure.fluents.FlDataSource;
import org.cthul.fixsure.fluents.FlGenerator;
import org.cthul.fixsure.generators.AnonymousTemplate;
import org.cthul.fixsure.generators.GeneratorTools;
import org.cthul.fixsure.values.EagerValues;
import org.cthul.fixsure.values.LazyValues;

@FunctionalInterface
public interface FlTemplate<T>
extends FlDataSource<T>,
Template<T> {
    @Override
    public FlGenerator<T> newGenerator();

    @Override
    @Deprecated
    default public Generator<T> toGenerator() {
        return this.newGenerator();
    }

    @Override
    default public Class<T> getValueType() {
        return Typed.typeOf(this.newGenerator());
    }

    default public T first() {
        return this.newGenerator().next();
    }

    default public LazyValues<T> first(int length) {
        return LazyValues.any(length, this);
    }

    default public LazyValues<T> first(Generator<Integer> length) {
        return LazyValues.any(length, this);
    }

    @Override
    default public EagerValues<T> few() {
        return this.newGenerator().few();
    }

    @Override
    default public EagerValues<T> some() {
        return this.newGenerator().some();
    }

    @Override
    default public EagerValues<T> several() {
        return this.newGenerator().several();
    }

    @Override
    default public EagerValues<T> many() {
        return this.newGenerator().many();
    }

    @Override
    default public FlTemplate<T> distinct() {
        return new AnonymousTemplate<T>(){

            @Override
            public FlGenerator<T> newGenerator() {
                return FlTemplate.this.newGenerator().distinct();
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                return FlTemplate.this.toString(sb).append(".distrinct()");
            }
        };
    }

    @Override
    default public FlTemplate<T> filter(final Predicate<? super T> predicate) {
        return new AnonymousTemplate<T>(){

            @Override
            public FlGenerator<T> newGenerator() {
                return FlTemplate.this.newGenerator().filter(predicate);
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                FlTemplate.this.toString(sb).append(".filter(");
                GeneratorTools.lambdaToString(predicate, sb);
                return sb.append(")");
            }
        };
    }

    @Override
    default public <R> FlTemplate<R> flatMap(final Function<? super T, ? extends DataSource<R>> function) {
        return new AnonymousTemplate<R>(){

            @Override
            public FlGenerator<R> newGenerator() {
                return FlTemplate.this.newGenerator().flatMap(function);
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                FlTemplate.this.toString(sb).append(".flatMap(");
                GeneratorTools.lambdaToString(function, sb);
                return sb.append(")");
            }
        };
    }

    @Override
    default public <R> FlTemplate<R> map(final Function<? super T, ? extends R> function) {
        return new AnonymousTemplate<R>(){

            @Override
            public FlGenerator<R> newGenerator() {
                return FlTemplate.this.newGenerator().map(function);
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                FlTemplate.this.toString(sb).append(".map(");
                GeneratorTools.lambdaToString(function, sb);
                return sb.append(")");
            }
        };
    }

    @Override
    default public <U, R> FlTemplate<R> map(DataSource<U> other, BiFunction<? super T, ? super U, ? extends R> function) {
        return this.with((DataSource)other).map((BiFunction)function);
    }

    @Override
    default public FlTemplate<T> peek(Consumer<? super T> consumer) {
        return () -> this.newGenerator().peek(consumer);
    }

    @Override
    default public FlTemplate<T> then(final DataSource<? extends T> ... more) {
        return new AnonymousTemplate<T>(){

            @Override
            public FlGenerator<T> newGenerator() {
                return FlTemplate.this.newGenerator().then(more);
            }

            @Override
            public StringBuilder toString(StringBuilder sb) {
                sb.append('{');
                GeneratorTools.printList(FlTemplate.this, Arrays.asList(more), sb);
                return sb.append('}');
            }
        };
    }

    @Override
    default public FlTemplate<Values<T>> aggregate(DataSource<Integer> length) {
        return () -> this.newGenerator().aggregate(length);
    }

    @Override
    default public FlTemplate<Values<T>> aggregate(int length) {
        return () -> this.newGenerator().aggregate(length);
    }

    @Override
    default public FlTemplate<T> shuffle() {
        return () -> this.newGenerator().shuffle();
    }

    @Override
    default public FlTemplate<T> shuffle(long seed) {
        return () -> this.newGenerator().shuffle(seed);
    }

    @Override
    default public FlTemplate<T> mixWith(DataSource<? extends T> ... more) {
        return () -> this.newGenerator().mixWith(more);
    }

    @Override
    default public FlTemplate<T> alternateWith(DataSource<? extends T> ... more) {
        return () -> this.newGenerator().alternateWith(more);
    }

    @Override
    default public FlTemplate<T> snapshot() {
        return this;
    }

    @Override
    default public <U> BiTemplate<T, U> split(Function<? super T, ? extends U> function) {
        return () -> this.newGenerator().split(function);
    }

    @Override
    default public <U, V> BiTemplate<U, V> split(BiConsumer<? super T, ? super BiConsumer<? super U, ? super V>> action) {
        return () -> this.newGenerator().split(action);
    }

    @Override
    default public <U> BiTemplate<T, U> with(DataSource<U> source) {
        return () -> this.newGenerator().with(source);
    }

    default public <R> R transform(Function<? super FlTemplate<? extends T>, ? extends R> function) {
        return function.apply(this);
    }
}

