/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators;

import org.cthul.fixsure.Sequence;
import org.cthul.fixsure.SequenceLength;
import org.cthul.fixsure.api.AbstractStringify;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.fluents.FlSequence;
import org.cthul.fixsure.generators.GeneratorTools;

public abstract class AnonymousSequence<T>
extends AbstractStringify
implements FlSequence<T> {
    private final long length;
    private final Sequence<?> source;

    public AnonymousSequence(long length) {
        this(null, length);
    }

    public AnonymousSequence(SequenceLength length) {
        this(null, length);
    }

    public AnonymousSequence(Sequence source) {
        this(source, source);
    }

    public AnonymousSequence(Sequence<?> source, long length) {
        this.source = source;
        this.length = length;
    }

    public AnonymousSequence(Sequence<?> source, SequenceLength length) {
        this.source = source;
        this.length = SequenceLength.toLong(length);
    }

    @Override
    public long length() {
        return this.length;
    }

    protected void assertInRange(long n) {
        if (!SequenceLength.isInRange(n, this)) {
            throw new IndexOutOfBoundsException("" + n);
        }
    }

    @Override
    public Class<T> getValueType() {
        return GeneratorTools.typeOf(this.source);
    }

    @Override
    public long randomSeedHint() {
        if (this.source instanceof FlSequence) {
            return ((FlSequence)this.source).randomSeedHint();
        }
        return DistributionRandomizer.toSeed(this.getClass());
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (this.source != null) {
            return this.source.toString(sb);
        }
        return super.toString(sb);
    }
}

