/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.Sequence;
import org.cthul.fixsure.Template;
import org.cthul.fixsure.Typed;
import org.cthul.fixsure.api.Stringify;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.fetchers.EagerFetcher;
import org.cthul.fixsure.fetchers.Fetchers;
import org.cthul.fixsure.fluents.FlGenerator;
import org.cthul.fixsure.fluents.FlSequence;
import org.cthul.fixsure.generators.CopyableGenerator;
import org.cthul.fixsure.generators.value.ConstantValue;
import org.cthul.objects.Types;

public class GeneratorTools {
    private static final long GENERATOR_SEED = DistributionRandomizer.toSeed(GeneratorTools.class) ^ DistributionRandomizer.toSeed(Generator.class);
    private static final long SEQUENCE_SEED = DistributionRandomizer.toSeed(GeneratorTools.class) ^ DistributionRandomizer.toSeed(Sequence.class);
    private static final Map<FlGenerator<?>, Consumers> CONSUMERS = new WeakHashMap();

    private GeneratorTools() {
    }

    public static <T> Class<T> typeOf(Object o) {
        if (o instanceof Typed) {
            return ((Typed)o).getValueType();
        }
        return null;
    }

    public static <T> Class<T> commonTypeOf(Object ... generators) {
        List types = GeneratorTools.collectTypesOf(generators);
        if (types.isEmpty()) {
            return null;
        }
        if ((types = Types.lowestCommonSuperclasses(types)).size() == 1) {
            return (Class)types.get(0);
        }
        return null;
    }

    private static List<Class<?>> collectTypesOf(Object ... generators) {
        ArrayList result = new ArrayList(generators.length);
        for (Object g : generators) {
            Class t = GeneratorTools.typeOf(g);
            if (t == null) continue;
            result.add(t);
        }
        return result;
    }

    public static Class[] typesOf(Object ... generators) {
        Class[] result = new Class[generators.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = GeneratorTools.typeOf(generators[i]);
        }
        return result;
    }

    public static List<Class> typelistOf(Object ... generators) {
        return Arrays.asList(GeneratorTools.typesOf(generators));
    }

    public static Generator[] asGenerators(Object ... values) {
        Generator[] result = new Generator[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = GeneratorTools.asGenerator(values[i]);
        }
        return result;
    }

    public static <T> Generator<T> asGenerator(Object value) {
        if (value instanceof DataSource) {
            return ((DataSource)value).toGenerator();
        }
        return (Generator)((Object)ConstantValue.constant(value));
    }

    public static <T> Generator<T> copyGenerator(Object generator) {
        if (generator instanceof CopyableGenerator) {
            return ((CopyableGenerator)generator).copy();
        }
        if (generator instanceof Template) {
            return ((Template)generator).newGenerator();
        }
        throw new UnsupportedOperationException("Not copyable: " + generator);
    }

    public static StringBuilder lambdaToString(Object o, StringBuilder sb) {
        if (o == null) {
            return sb.append("null");
        }
        String str = o.getClass().getName();
        if (str.contains("$$Lambda$")) {
            int dot;
            int slash = str.indexOf(47);
            if (slash < 0) {
                slash = str.length();
            }
            if ((dot = str.lastIndexOf(46, slash) + 1) < 0) {
                dot = 0;
            }
            return sb.append(str, dot, slash);
        }
        return Stringify.toString(o, sb);
    }

    public static StringBuilder toAscii(long value, StringBuilder sb) {
        char[] values = new char[10];
        long bit1 = value & 1L;
        values[9] = (char)(33L + 2L * ((value >>>= 1) % 47L) + bit1);
        value /= 47L;
        for (int i = 0; i < 9; ++i) {
            values[8 - i] = (char)(33L + value % 94L);
            value /= 94L;
        }
        sb.append(values);
        return sb;
    }

    public static StringBuilder printList(Object first, Collection<?> list, StringBuilder sb) {
        Stringify.toString(first, sb);
        if (list == null || list.isEmpty()) {
            return sb;
        }
        return GeneratorTools.printList(list, sb.append(','), 1);
    }

    public static StringBuilder printList(Collection<?> list, StringBuilder sb) {
        return GeneratorTools.printList(list, sb, 2);
    }

    public static StringBuilder printList(Collection<?> list, StringBuilder sb, int max) {
        int n = -1;
        Iterator<?> it = list.iterator();
        while (++n < max && it.hasNext()) {
            if (n > 0) {
                sb.append(',');
            }
            Stringify.toString(it.next(), sb);
        }
        int len = sb.length();
        while (it.hasNext()) {
            sb.append(',');
            Stringify.toString(it.next(), sb);
            if (sb.length() - len <= 12) continue;
            sb.setLength(len);
            return sb.append(",").append(list.size() - max).append(" more...");
        }
        return sb;
    }

    public static synchronized Consumers cacheConsumers(FlGenerator<?> generator) {
        return CONSUMERS.computeIfAbsent(generator, k -> new Consumers(k.randomSeedHint()));
    }

    public static long getRandomSeedHint(Generator<?> generator) {
        if (generator instanceof FlGenerator) {
            return ((FlGenerator)generator).randomSeedHint();
        }
        return GENERATOR_SEED;
    }

    public static long getRandomSeedHint(Sequence<?> sequence) {
        if (sequence instanceof FlSequence) {
            return ((FlSequence)sequence).randomSeedHint();
        }
        return SEQUENCE_SEED ^ sequence.length();
    }

    public static class Consumers {
        private final long seed;
        private EagerFetcher few = null;
        private EagerFetcher some = null;
        private EagerFetcher several = null;
        private EagerFetcher many = null;

        public Consumers(long seed) {
            this.seed = seed;
        }

        public EagerFetcher getFew() {
            if (this.few == null) {
                this.few = Fetchers.few(this.seed).toFetcher();
            }
            return this.few;
        }

        public EagerFetcher getSome() {
            if (this.some == null) {
                this.some = Fetchers.some(this.seed).toFetcher();
            }
            return this.some;
        }

        public EagerFetcher getSeveral() {
            if (this.several == null) {
                this.several = Fetchers.several(this.seed).toFetcher();
            }
            return this.several;
        }

        public EagerFetcher getMany() {
            if (this.many == null) {
                this.many = Fetchers.many(this.seed).toFetcher();
            }
            return this.many;
        }
    }
}

