/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators;

import org.cthul.fixsure.Distribution;
import org.cthul.fixsure.api.AbstractStringify;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.distributions.UniformDistribution;
import org.cthul.fixsure.fluents.FlDistribution;
import org.cthul.fixsure.fluents.FlGenerator;

public abstract class GeneratorWithDistribution<T>
extends AbstractStringify
implements FlGenerator<T> {
    private final FlDistribution.FlRandom random;

    public GeneratorWithDistribution(long seedHint) {
        this.random = GeneratorWithDistribution.toRnd(null, seedHint);
    }

    public GeneratorWithDistribution(Distribution distribution, long seedHint) {
        this.random = GeneratorWithDistribution.toRnd(distribution, seedHint);
    }

    protected GeneratorWithDistribution(GeneratorWithDistribution src) {
        this.random = src.random.copy();
    }

    protected FlDistribution.FlRandom rnd() {
        return this.random;
    }

    @Override
    public long randomSeedHint() {
        return DistributionRandomizer.toSeed(this.getClass());
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        return this.random.toString(sb);
    }

    private static FlDistribution.FlRandom toRnd(Distribution distribution, long seedHint) {
        return distribution != null ? FlDistribution.wrap(distribution.toRandomNumbers(seedHint)) : UniformDistribution.uniform().toRandomNumbers(seedHint);
    }
}

