/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators;

import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Distribution;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.api.AbstractStringify;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.fluents.FlGenerator;
import org.cthul.fixsure.generators.GeneratorTools;
import org.cthul.fixsure.generators.primitives.RandomIntegersGenerator;

public abstract class GeneratorWithScalar<T>
extends AbstractStringify
implements FlGenerator<T> {
    private final int scalar;
    private final Generator<Integer> scalarGenerator;

    public GeneratorWithScalar(int scalar) {
        this.scalar = scalar;
        this.scalarGenerator = null;
    }

    public GeneratorWithScalar(DataSource<Integer> scalarGenerator) {
        this.scalar = -1;
        this.scalarGenerator = scalarGenerator.toGenerator();
    }

    public GeneratorWithScalar(int scalar, Distribution distribution, long seed) {
        this(RandomIntegersGenerator.integers(scalar).random(distribution, seed));
    }

    protected GeneratorWithScalar(GeneratorWithScalar src) {
        this.scalar = src.scalar;
        this.scalarGenerator = src.scalarGenerator;
    }

    protected int nextScalar() {
        if (this.scalarGenerator != null) {
            return this.scalarGenerator.next();
        }
        return this.scalar;
    }

    @Override
    public long randomSeedHint() {
        if (this.scalarGenerator != null) {
            return GeneratorTools.getRandomSeedHint(this.scalarGenerator) ^ this.classSeed();
        }
        return (long)this.scalar ^ this.classSeed();
    }

    protected long classSeed() {
        return DistributionRandomizer.toSeed(this.getClass());
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (this.scalarGenerator != null) {
            return this.scalarGenerator.toString(sb);
        }
        return sb.append(this.scalar);
    }
}

