/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.composite;

import java.util.HashSet;
import java.util.Set;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.GeneratorException;
import org.cthul.fixsure.api.AbstractStringify;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.generators.CopyableGenerator;
import org.cthul.fixsure.generators.GeneratorTools;

public class DistinctGenerator<T>
extends AbstractStringify
implements CopyableGenerator<T> {
    private static final int DEFAULT_MAX_ATTEMPTS = 128;
    private final int maxAttempts;
    private final Generator<T> source;
    private final Set<T> oldValues;

    public static <T> DistinctGenerator<T> distinct(DataSource<T> source) {
        return new DistinctGenerator<T>(source);
    }

    public static <T> DistinctGenerator<T> distinct(DataSource<T> source, int maxAttempts) {
        return new DistinctGenerator<T>(source, maxAttempts);
    }

    public DistinctGenerator(DataSource<T> source) {
        this(source, 128);
    }

    public DistinctGenerator(DataSource<T> source, int maxAttempts) {
        this.source = source.toGenerator();
        this.oldValues = new HashSet<T>();
        this.maxAttempts = maxAttempts;
    }

    protected DistinctGenerator(DistinctGenerator<T> src) {
        this.source = GeneratorTools.copyGenerator(src.source);
        this.oldValues = new HashSet<T>(src.oldValues);
        this.maxAttempts = src.maxAttempts;
    }

    @Override
    public long randomSeedHint() {
        return GeneratorTools.getRandomSeedHint(this.source) * 3L ^ DistributionRandomizer.toSeed(DistinctGenerator.class);
    }

    @Override
    public T next() {
        T next = null;
        for (int i = 0; i < this.maxAttempts; ++i) {
            next = this.source.next();
            if (!this.oldValues.add(next)) continue;
            return next;
        }
        throw new GeneratorException("No unique value after " + this.maxAttempts + " attempts: " + next);
    }

    @Override
    public DistinctGenerator<T> copy() {
        return new DistinctGenerator<T>(this);
    }

    @Override
    public Class<T> getValueType() {
        return GeneratorTools.typeOf(this.source);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        return this.source.toString(sb).append(".distinct");
    }
}

