/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.composite;

import java.util.function.Predicate;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.api.AbstractStringify;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.generators.CopyableGenerator;
import org.cthul.fixsure.generators.GeneratorTools;

public class FilteringGenerator<T>
extends AbstractStringify
implements CopyableGenerator<T> {
    private final Generator<T> source;
    private final Predicate<? super T> predicate;

    public static <T> FilteringGenerator<T> filter(DataSource<T> source, Predicate<? super T> predicate) {
        return new FilteringGenerator<T>(source, predicate);
    }

    public FilteringGenerator(DataSource<T> source, Predicate<? super T> predicate) {
        this.source = source.toGenerator();
        this.predicate = predicate;
    }

    protected FilteringGenerator(FilteringGenerator<T> src) {
        this.source = GeneratorTools.copyGenerator(src.source);
        this.predicate = src.predicate;
    }

    @Override
    public T next() {
        T next;
        while (!this.predicate.test(next = this.source.next())) {
        }
        return next;
    }

    @Override
    public FilteringGenerator<T> copy() {
        return new FilteringGenerator<T>(this);
    }

    @Override
    public Class<T> getValueType() {
        return GeneratorTools.typeOf(this.source);
    }

    @Override
    public long randomSeedHint() {
        return GeneratorTools.getRandomSeedHint(this.source) * 3L ^ DistributionRandomizer.toSeed(this.getClass());
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        this.source.toString(sb).append(".filter(");
        GeneratorTools.lambdaToString(this.predicate, sb);
        return sb.append(")");
    }
}

