/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.composite;

import java.util.function.Function;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.GeneratorException;
import org.cthul.fixsure.Typed;
import org.cthul.fixsure.api.AbstractStringify;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.generators.CopyableGenerator;
import org.cthul.fixsure.generators.GeneratorTools;

public class FlatMappingGenerator<T>
extends AbstractStringify
implements CopyableGenerator<T> {
    private final Convert<?, T> cnv;
    private Class<?> valueType = Void.TYPE;

    public static <In, Out> FlatMappingGenerator<Out> map(DataSource<In> src, Function<? super In, ? extends DataSource<Out>> function) {
        return new FlatMappingGenerator(src, function);
    }

    public <Src> FlatMappingGenerator(DataSource<Src> src, Function<? super Src, ? extends DataSource<T>> function) {
        this.cnv = new Convert(src, function);
    }

    protected FlatMappingGenerator(FlatMappingGenerator<T> src) {
        this.cnv = src.cnv.newFromTemplate();
    }

    @Override
    public T next() {
        return this.cnv.next();
    }

    @Override
    public Class<T> getValueType() {
        if (this.valueType == Void.TYPE) {
            this.valueType = this.cnv.getValueType();
        }
        return this.valueType;
    }

    @Override
    public FlatMappingGenerator<T> copy() {
        return new FlatMappingGenerator<T>(this);
    }

    @Override
    public long randomSeedHint() {
        return GeneratorTools.getRandomSeedHint(((Convert)this.cnv).src) * 3L ^ DistributionRandomizer.toSeed(FlatMappingGenerator.class);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        ((Convert)this.cnv).src.toString(sb).append(".flatMap(");
        GeneratorTools.lambdaToString(((Convert)this.cnv).function, sb);
        return sb.append(")");
    }

    private static class Convert<Src, Out> {
        private final Generator<Src> src;
        private final Function<? super Src, ? extends DataSource<Out>> function;
        private Generator<Out> current = null;

        public Convert(DataSource<Src> src, Function<? super Src, ? extends DataSource<Out>> function) {
            this.src = src.toGenerator();
            this.function = function;
        }

        public Out next() {
            while (true) {
                if (this.current == null) {
                    this.current = this.function.apply(this.src.next()).toGenerator();
                }
                try {
                    return this.current.next();
                }
                catch (GeneratorException e) {
                    this.current = null;
                    continue;
                }
                break;
            }
        }

        public Convert<Src, Out> newFromTemplate() {
            return new Convert<Src, Out>(GeneratorTools.copyGenerator(this.src), this.function);
        }

        public Class<?> getValueType() {
            if (this.current == null) {
                this.current = this.function.apply(this.src.next()).toGenerator();
            }
            return Typed.typeOf(this.current);
        }
    }
}

