/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.composite;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.GeneratorException;
import org.cthul.fixsure.api.AbstractStringify;
import org.cthul.fixsure.generators.CopyableGenerator;
import org.cthul.fixsure.generators.GeneratorTools;
import org.cthul.fixsure.generators.value.EmptySequence;

public class GeneratorQueue<T>
extends AbstractStringify
implements CopyableGenerator<T> {
    private Fetch<T> values;
    private Queue<Fetch<T>> moreValues = null;

    public static <T> GeneratorQueue<T> beginWith(DataSource<T> values) {
        return new GeneratorQueue<T>(values);
    }

    public static <T> GeneratorQueue<T> beginWith(int n, DataSource<T> values) {
        return new GeneratorQueue<T>(values, n);
    }

    public static <T> GeneratorQueue<T> beginWith(Generator<Integer> n, DataSource<T> values) {
        return new GeneratorQueue<T>(values, n.next());
    }

    public static <T> GeneratorQueue<T> queue(DataSource<T> ... values) {
        return new GeneratorQueue<T>(values);
    }

    public GeneratorQueue(DataSource<T> values) {
        this(values, -1, null);
    }

    public GeneratorQueue(DataSource<T> values, int n) {
        this(values, n, null);
    }

    protected GeneratorQueue(DataSource<T> values, int n, Collection<Fetch<T>> moreValues) {
        this.values = n < 0 ? new FetchAll<T>(values.toGenerator()) : new FetchFixed<T>(values.toGenerator(), n);
        if (moreValues != null) {
            this.moreValues = new ArrayDeque<Fetch<T>>(moreValues.size());
            this.copyAll(moreValues, this.moreValues);
        }
    }

    public GeneratorQueue(DataSource<T> ... values) {
        if (values.length == 0) {
            this.values = new FetchAll(EmptySequence.noValues());
        } else {
            this.values = new FetchAll<T>(values[0].toGenerator());
            for (int i = 1; i < values.length; ++i) {
                this._add(values[i].toGenerator());
            }
        }
    }

    protected GeneratorQueue(GeneratorQueue<T> src) {
        this.values = src.values.copy();
        if (src.moreValues != null) {
            this.moreValues = new ArrayDeque<Fetch<T>>(src.moreValues.size());
            this.copyAll(src.moreValues, this.moreValues);
        }
    }

    private void copyAll(Collection<? extends Fetch<T>> src, Collection<Fetch<T>> target) {
        src.forEach(f -> target.add(f.copy()));
    }

    protected void _add(DataSource<? extends T> value) {
        if (this.moreValues == null) {
            this.moreValues = new ArrayDeque<Fetch<T>>();
        }
        this.moreValues.add(new FetchAll<T>(value));
    }

    protected void _add(Generator<? extends T> value, int n) {
        if (n < 0) {
            this._add(value);
        } else {
            if (this.moreValues == null) {
                this.moreValues = new ArrayDeque<Fetch<T>>();
            }
            this.moreValues.add(new FetchFixed<T>(value, n));
        }
    }

    @Override
    public T next() {
        while (true) {
            block6: {
                try {
                    if (this.values.hasNext()) {
                        return this.values.fetch();
                    }
                }
                catch (GeneratorException e) {
                    if (!this.values.expectException()) {
                        throw e;
                    }
                    if (this.moreValues != null && !this.moreValues.isEmpty()) break block6;
                    throw e;
                }
            }
            if (this.moreValues == null || this.moreValues.isEmpty()) {
                throw new GeneratorException("End of queue");
            }
            this.values = this.moreValues.remove();
        }
    }

    public GeneratorQueue<T> then(Generator<? extends T> moreValues) {
        GeneratorQueue<? extends T> r = new GeneratorQueue<T>(this);
        r._add(moreValues);
        return r;
    }

    public GeneratorQueue<T> then(int n, Generator<? extends T> moreValues) {
        GeneratorQueue<? extends T> r = new GeneratorQueue<T>(this);
        r._add(moreValues, n);
        return r;
    }

    public GeneratorQueue<T> then(Generator<Integer> n, Generator<? extends T> moreValues) {
        return this.then(n.next(), moreValues);
    }

    @Override
    public GeneratorQueue<T> then(DataSource<? extends T> ... more) {
        return this.thenAll(more);
    }

    public GeneratorQueue<T> thenAll(DataSource<? extends T> ... moreValues) {
        GeneratorQueue<? extends T> r = new GeneratorQueue<T>(this);
        for (DataSource<? extends T> g : moreValues) {
            r._add(g);
        }
        return r;
    }

    @Override
    public GeneratorQueue<T> copy() {
        return new GeneratorQueue<T>(this);
    }

    @Override
    public long randomSeedHint() {
        return this.values.randomSeedHint();
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        return GeneratorTools.printList(this.values, this.moreValues, sb.append('{')).append('}');
    }

    private static class FetchAll<T>
    extends Fetch<T> {
        private final Generator<? extends T> values;

        public FetchAll(DataSource<? extends T> values) {
            this.values = values.toGenerator();
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public T fetch() {
            return this.values.next();
        }

        @Override
        public boolean expectException() {
            return true;
        }

        @Override
        public Fetch<T> copy() {
            return new FetchAll<T>(this.newFromTemplate());
        }

        public Generator<? extends T> newFromTemplate() {
            return GeneratorTools.copyGenerator(this.values);
        }

        @Override
        public long randomSeedHint() {
            return GeneratorTools.getRandomSeedHint(this.values) ^ 0xA77A77A77L;
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            return this.values.toString(sb);
        }
    }

    private static class FetchFixed<T>
    extends Fetch<T> {
        private final Generator<? extends T> values;
        private int rem;

        public FetchFixed(Generator<? extends T> values, int size) {
            this.values = values;
            this.rem = size;
        }

        @Override
        public boolean hasNext() {
            return this.rem > 0;
        }

        @Override
        public T fetch() {
            if (this.rem == 0) {
                throw new GeneratorException();
            }
            --this.rem;
            return this.values.next();
        }

        @Override
        public boolean expectException() {
            return this.rem == 0;
        }

        @Override
        public Fetch<T> copy() {
            return new FetchFixed<T>(this.newFromTemplate(), this.rem);
        }

        public Generator<? extends T> newFromTemplate() {
            return GeneratorTools.copyGenerator(this.values);
        }

        @Override
        public long randomSeedHint() {
            return GeneratorTools.getRandomSeedHint(this.values) ^ (long)this.rem;
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            return this.values.toString(sb.append(this.rem).append(" of "));
        }
    }

    protected static abstract class Fetch<T>
    extends AbstractStringify {
        protected Fetch() {
        }

        public abstract boolean hasNext();

        public abstract T fetch();

        public abstract boolean expectException();

        public abstract Fetch<T> copy();

        public abstract long randomSeedHint();
    }
}

