/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.composite;

import java.util.function.Function;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.Typed;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.generators.CopyableGenerator;
import org.cthul.fixsure.generators.GeneratorTools;

public class MappingGenerator<T>
implements CopyableGenerator<T> {
    private final Convert<?, T> cnv;
    private Class<?> valueType = Void.TYPE;

    public static <In, Out> MappingGenerator<Out> map(DataSource<In> src, Function<? super In, ? extends Out> function) {
        return new MappingGenerator<Out>(src, function);
    }

    public <Src> MappingGenerator(DataSource<Src> src, Function<? super Src, ? extends T> function) {
        this.cnv = new Convert<Src, T>(src, function);
    }

    protected MappingGenerator(MappingGenerator<T> src) {
        this.cnv = src.cnv.newFromTemplate();
    }

    @Override
    public T next() {
        return this.cnv.next();
    }

    @Override
    public Class<T> getValueType() {
        if (this.valueType == Void.TYPE) {
            this.valueType = this.cnv.getValueType();
        }
        return this.valueType;
    }

    @Override
    public MappingGenerator<T> copy() {
        return new MappingGenerator<T>(this);
    }

    @Override
    public long randomSeedHint() {
        return GeneratorTools.getRandomSeedHint(((Convert)this.cnv).src) * 3L ^ DistributionRandomizer.toSeed(MappingGenerator.class);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        ((Convert)this.cnv).src.toString(sb).append(".map(");
        return GeneratorTools.lambdaToString(((Convert)this.cnv).function, sb).append(')');
    }

    private static class Convert<Src, Out> {
        private final Generator<Src> src;
        private final Function<? super Src, ? extends Out> function;

        public Convert(DataSource<Src> src, Function<? super Src, ? extends Out> function) {
            this.src = src.toGenerator();
            this.function = function;
        }

        public Out next() {
            return this.function.apply(this.src.next());
        }

        public Convert<Src, Out> newFromTemplate() {
            return new Convert<Src, Out>(GeneratorTools.copyGenerator(this.src), this.function);
        }

        public Class<?> getValueType() {
            return Typed.typeOf(this.function);
        }
    }
}

